/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.fs.FSAttributes;
import org.catacombae.storage.fs.FSEntry;
import org.catacombae.storage.fs.FSLink;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSAttributes;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSEntry;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandler;
import org.catacombae.util.IOUtil;
import org.catacombae.util.Util;

public class HFSCommonFSLink
extends HFSCommonFSEntry
implements FSLink {
    private static final boolean DEBUG = Util.booleanEnabledByProperties(false, "org.catacombae.debug", "org.catacombae.storage.debug", "org.catacombae.storage.fs.debug", "org.catacombae.storage.fs.hfscommon.debug", "org.catacombae.storage.fs.hfscommon." + HFSCommonFSLink.class.getSimpleName() + ".debug");
    private final CommonHFSCatalogFileRecord linkRecord;

    public HFSCommonFSLink(HFSCommonFileSystemHandler fsHandler, CommonHFSCatalogFileRecord linkRecord) {
        super(fsHandler, linkRecord.getData());
        this.linkRecord = linkRecord;
        if (!linkRecord.getData().isSymbolicLink()) {
            throw new IllegalArgumentException("linkRecord is no symbolic link!");
        }
    }

    public String getLinkTargetPosixPath() {
        ReadableRandomAccessStream linkDataStream = this.fsHandler.getReadableDataForkStream(this.linkRecord);
        byte[] linkBytes = IOUtil.readFully(linkDataStream);
        linkDataStream.close();
        return Util.readString(linkBytes, "UTF-8");
    }

    public FSEntry getLinkTarget(String[] parentDir) {
        FSEntry res;
        String posixPath = this.getLinkTargetPosixPath();
        Object[] targetPath = this.fsHandler.getTruePathFromPosixPath(posixPath, parentDir);
        if (targetPath != null) {
            res = this.fsHandler.getEntry((String[])targetPath);
            if (res != null && res instanceof FSLink) {
                if ((res = this.fsHandler.resolveLinks((String[])targetPath, (FSLink)res)) == null && DEBUG) {
                    System.err.println("\ngetLinkTarget(): Could not resolve inner link \"" + Util.concatenateStrings(targetPath, "/") + "\"");
                }
            } else if (res == null && DEBUG) {
                System.err.println("\ngetLinkTarget(): Could not get entry for true path \"" + Util.concatenateStrings(targetPath, "/") + "\"");
            }
            if (res != null && res instanceof FSLink) {
                throw new RuntimeException("res still instanceof FSLink!");
            }
        } else {
            if (DEBUG) {
                System.err.println("\ngetLinkTarget(): Could not get true path!");
            }
            res = null;
        }
        if (res == null && DEBUG) {
            System.err.println("getLinkTarget(): FAILED to get entry by posix path for link " + this.linkRecord.getKey().getParentID().toLong() + ":\"" + this.fsHandler.getProperNodeName(this.linkRecord) + "\":");
            System.err.println("getLinkTarget():   posixPath=\"" + posixPath + "\"");
            System.err.println("getLinkTarget():   parentDir=\"" + Util.concatenateStrings(parentDir, "/") + "\"");
            System.err.println();
        }
        return res;
    }

    public FSAttributes getAttributes() {
        return new HFSCommonFSAttributes(this, this.linkRecord.getData());
    }

    public String getName() {
        return this.fsHandler.getProperNodeName(this.linkRecord);
    }

    public CommonHFSCatalogFileRecord getInternalCatalogFileRecord() {
        return this.linkRecord;
    }

    public String getLinkTargetString() {
        return this.getLinkTargetPosixPath();
    }

    public HFSCommonFileSystemHandler getFileSystemHandler() {
        return this.fsHandler;
    }
}

