/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import java.io.InputStream;
import java.io.OutputStream;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableRandomAccessInputStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.SynchronizedReadableRandomAccessStream;
import org.catacombae.io.TruncatableRandomAccessStream;
import org.catacombae.io.WritableRandomAccessStream;
import org.catacombae.storage.fs.FSFork;
import org.catacombae.storage.fs.FSForkType;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSFile;

public class HFSCommonFSFork
implements FSFork {
    private static final String RESOURCE_XATTR_NAME = "com.apple.ResourceFork";
    private final HFSCommonFSFile parent;
    private final FSForkType type;
    private final CommonHFSForkData forkData;

    HFSCommonFSFork(HFSCommonFSFile iParent, FSForkType iType, CommonHFSForkData iForkData) {
        if (iParent == null) {
            throw new IllegalArgumentException("iParent must not be null!");
        }
        if (iType == null) {
            throw new IllegalArgumentException("iType must not be null!");
        }
        if (iType != FSForkType.DATA && iType != FSForkType.MACOS_RESOURCE) {
            throw new IllegalArgumentException("iType is unsupported!");
        }
        if (iForkData == null) {
            throw new IllegalArgumentException("iForkData must not be null!");
        }
        this.parent = iParent;
        this.type = iType;
        this.forkData = iForkData;
    }

    public long getLength() {
        return this.forkData.getLogicalSize();
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isTruncatable() {
        return false;
    }

    public String getForkIdentifier() {
        switch (this.type) {
            case DATA: {
                return "Data fork";
            }
            case MACOS_RESOURCE: {
                return "Resource fork";
            }
        }
        throw new RuntimeException("INTERNAL ERROR: Incorrect fork type: " + (Object)((Object)this.type));
    }

    public InputStream getInputStream() {
        return new ReadableRandomAccessInputStream(new SynchronizedReadableRandomAccessStream(this.getReadableRandomAccessStream()));
    }

    public ReadableRandomAccessStream getReadableRandomAccessStream() {
        switch (this.type) {
            case DATA: {
                return this.parent.getReadableDataForkStream();
            }
            case MACOS_RESOURCE: {
                return this.parent.getReadableResourceForkStream();
            }
        }
        throw new RuntimeException("INTERNAL ERROR: Incorrect fork type: " + (Object)((Object)this.type));
    }

    public WritableRandomAccessStream getWritableRandomAccessStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RandomAccessStream getRandomAccessStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OutputStream getOutputStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TruncatableRandomAccessStream getForkStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasXattrName() {
        return this.type == FSForkType.MACOS_RESOURCE;
    }

    public String getXattrName() {
        if (this.type == FSForkType.MACOS_RESOURCE) {
            return RESOURCE_XATTR_NAME;
        }
        return null;
    }
}

