/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.storage.fs.FSAttributes;
import org.catacombae.storage.fs.FSEntry;
import org.catacombae.storage.fs.FSFolder;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSAttributes;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSEntry;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandler;

public class HFSCommonFSFolder
extends HFSCommonFSEntry
implements FSFolder {
    private final CommonHFSCatalogLeafRecord keyRecord;
    private final CommonHFSCatalogFolderRecord folderRecord;
    private final HFSCommonFSAttributes attributes;

    public HFSCommonFSFolder(HFSCommonFileSystemHandler iParent, CommonHFSCatalogFolderRecord iFolderRecord) {
        this(iParent, null, iFolderRecord);
    }

    HFSCommonFSFolder(HFSCommonFileSystemHandler iParent, CommonHFSCatalogFileRecord iHardLinkFileRecord, CommonHFSCatalogFolderRecord iFolderRecord) {
        super(iParent, iFolderRecord.getData());
        if (iParent == null) {
            throw new IllegalArgumentException("iParent must not be null!");
        }
        if (iFolderRecord == null) {
            throw new IllegalArgumentException("iFolderRecord must not be null!");
        }
        this.keyRecord = iHardLinkFileRecord != null ? iHardLinkFileRecord : iFolderRecord;
        this.folderRecord = iFolderRecord;
        this.attributes = new HFSCommonFSAttributes(this, this.folderRecord.getData());
    }

    public String[] list() {
        return this.fsHandler.listNames(this.folderRecord);
    }

    public FSEntry[] listEntries() {
        return this.fsHandler.listFSEntries(this.folderRecord);
    }

    public FSEntry getChild(String name) {
        return this.fsHandler.getEntry(this.folderRecord, name);
    }

    public long getValence() {
        return this.folderRecord.getData().getValence();
    }

    public FSAttributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.fsHandler.getProperNodeName(this.keyRecord);
    }

    public CommonHFSCatalogFolder getInternalCatalogFolder() {
        return this.folderRecord.getData();
    }

    CommonHFSCatalogFolderRecord getInternalCatalogFolderRecord() {
        return this.folderRecord;
    }
}

