/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.fs.FSAttributes;
import org.catacombae.storage.fs.FSFile;
import org.catacombae.storage.fs.FSFork;
import org.catacombae.storage.fs.FSForkType;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSAttributes;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSEntry;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSFork;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandler;

public class HFSCommonFSFile
extends HFSCommonFSEntry
implements FSFile {
    private final CommonHFSCatalogLeafRecord keyRecord;
    private final CommonHFSCatalogFileRecord fileRecord;
    private final HFSCommonFSAttributes attributes;
    private final FSFork dataFork;
    private final FSFork resourceFork;

    HFSCommonFSFile(HFSCommonFileSystemHandler iParent, CommonHFSCatalogFileRecord iFileRecord) {
        this(iParent, null, iFileRecord);
    }

    HFSCommonFSFile(HFSCommonFileSystemHandler iParent, CommonHFSCatalogLeafRecord iHardLinkRecord, CommonHFSCatalogFileRecord iFileRecord) {
        super(iParent, iFileRecord.getData());
        if (iParent == null) {
            throw new IllegalArgumentException("iParent must not be null!");
        }
        if (iFileRecord == null) {
            throw new IllegalArgumentException("iFileRecord must not be null!");
        }
        this.fileRecord = iFileRecord;
        this.keyRecord = iHardLinkRecord != null ? iHardLinkRecord : iFileRecord;
        CommonHFSCatalogFile catalogFile = this.fileRecord.getData();
        this.attributes = new HFSCommonFSAttributes(this, catalogFile);
        this.dataFork = new HFSCommonFSFork(this, FSForkType.DATA, catalogFile.getDataFork());
        this.resourceFork = new HFSCommonFSFork(this, FSForkType.MACOS_RESOURCE, catalogFile.getResourceFork());
    }

    public FSAttributes getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.fsHandler.getProperNodeName(this.keyRecord);
    }

    public FSFork getMainFork() {
        return this.getForkByType(FSForkType.DATA);
    }

    public FSFork[] getAllForks() {
        FSFork[] superForks = super.getAllForks();
        boolean hasResourceFork = this.resourceFork.getLength() > 0L;
        int numForks = superForks.length + 1;
        if (hasResourceFork) {
            ++numForks;
        }
        FSFork[] res = new FSFork[numForks];
        System.arraycopy(superForks, 0, res, 0, superForks.length);
        res[superForks.length] = this.dataFork;
        if (hasResourceFork) {
            res[superForks.length + 1] = this.resourceFork;
        }
        return res;
    }

    public FSFork getForkByType(FSForkType type) {
        switch (type) {
            case DATA: {
                return this.dataFork;
            }
            case MACOS_RESOURCE: {
                return this.resourceFork;
            }
        }
        return super.getForkByType(type);
    }

    public long getCombinedLength() {
        return super.getCombinedLength() + this.dataFork.getLength() + this.resourceFork.getLength();
    }

    ReadableRandomAccessStream getReadableDataForkStream() {
        return this.fsHandler.getReadableDataForkStream(this.fileRecord);
    }

    ReadableRandomAccessStream getReadableResourceForkStream() {
        return this.fsHandler.getReadableResourceForkStream(this.fileRecord);
    }

    public CommonHFSCatalogFile getInternalCatalogFile() {
        return this.fileRecord.getData();
    }
}

