/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogAttributes;
import org.catacombae.hfs.types.hfscommon.CommonHFSFinderInfo;
import org.catacombae.storage.fs.BasicFSEntry;
import org.catacombae.storage.fs.FSFork;
import org.catacombae.storage.fs.FSForkType;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandler;
import org.catacombae.storage.fs.hfscommon.HFSCommonFinderInfoFork;
import org.catacombae.util.Util;

public abstract class HFSCommonFSEntry
extends BasicFSEntry {
    protected final HFSCommonFileSystemHandler fsHandler;
    protected final CommonHFSCatalogAttributes catalogAttributes;
    private FSFork finderInfoFork = null;
    private boolean finderInfoForkLoaded = false;

    protected HFSCommonFSEntry(HFSCommonFileSystemHandler parentFileSystem, CommonHFSCatalogAttributes catalogAttributes) {
        super(parentFileSystem);
        this.fsHandler = parentFileSystem;
        this.catalogAttributes = catalogAttributes;
    }

    HFSCommonFileSystemHandler getFileSystemHandler() {
        return this.fsHandler;
    }

    public FSFork[] getAllForks() {
        FSFork fork = this.getFinderInfoFork();
        if (fork != null) {
            return new FSFork[]{fork};
        }
        return new FSFork[0];
    }

    public FSFork getForkByType(FSForkType type) {
        if (type == FSForkType.MACOS_FINDERINFO) {
            return this.getFinderInfoFork();
        }
        return null;
    }

    public long getCombinedLength() {
        FSFork fork = this.getFinderInfoFork();
        if (fork != null) {
            return this.finderInfoFork.getLength();
        }
        return 0L;
    }

    public FSFork getFinderInfoFork() {
        if (!this.finderInfoForkLoaded) {
            CommonHFSFinderInfo finderInfo = this.catalogAttributes.getFinderInfo();
            byte[] finderInfoBytes = finderInfo.getBytes();
            this.finderInfoFork = !Util.zeroed(finderInfoBytes) ? new HFSCommonFinderInfoFork(finderInfo) : null;
            this.finderInfoForkLoaded = true;
        }
        return this.finderInfoFork;
    }
}

