/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfscommon;

import java.util.Date;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogAttributes;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.storage.fs.FSAttributes;
import org.catacombae.storage.fs.WindowsFileAttributes;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSEntry;
import org.catacombae.util.Util;

class HFSCommonFSAttributes
extends FSAttributes {
    private final HFSCommonFSEntry parentEntry;
    private final CommonHFSCatalogAttributes attributes;
    private FSAttributes.POSIXFileAttributes posixAttributes = null;

    public HFSCommonFSAttributes(HFSCommonFSEntry parentEntry, CommonHFSCatalogAttributes attributes) {
        this.parentEntry = parentEntry;
        this.attributes = attributes;
    }

    public boolean hasPOSIXFileAttributes() {
        return this.attributes.hasPermissions();
    }

    public FSAttributes.POSIXFileAttributes getPOSIXFileAttributes() {
        if (this.attributes.hasPermissions()) {
            if (this.posixAttributes == null) {
                HFSPlusBSDInfo permissions = this.attributes.getPermissions();
                this.posixAttributes = new FSAttributes.DefaultPOSIXFileAttributes(Util.unsign(permissions.getOwnerID()), Util.unsign(permissions.getGroupID()), permissions.getFileMode(), this.attributes.getCatalogNodeID().toLong());
            }
            return this.posixAttributes;
        }
        throw new UnsupportedOperationException("Not supported.");
    }

    public WindowsFileAttributes getWindowsFileAttributes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Date getModifyDate() {
        return this.attributes.getContentModDateAsDate();
    }

    public boolean hasWindowsFileAttributes() {
        return false;
    }

    public boolean hasCreateDate() {
        return this.attributes.hasCreateDate();
    }

    public Date getCreateDate() {
        return this.attributes.getCreateDateAsDate();
    }

    public boolean hasModifyDate() {
        return this.attributes.hasContentModDate();
    }

    public boolean hasAttributeModifyDate() {
        return this.attributes.hasAttributeModDate();
    }

    public boolean hasAccessDate() {
        return this.attributes.hasAccessDate();
    }

    public Date getAccessDate() {
        return this.attributes.getAccessDateAsDate();
    }

    public boolean hasBackupDate() {
        return this.attributes.hasBackupDate();
    }

    public Date getBackupDate() {
        return this.attributes.getBackupDateAsDate();
    }

    public Date getAttributeModifyDate() {
        return this.attributes.getAttributeModDateAsDate();
    }

    public boolean hasLinkCount() {
        CommonHFSCatalogFileRecord fr;
        return this.attributes instanceof CommonHFSCatalogFileRecord && (fr = (CommonHFSCatalogFileRecord)((Object)this.attributes)).getData().isHardFileLink();
    }

    public Long getLinkCount() {
        if (this.attributes instanceof CommonHFSCatalogFileRecord) {
            CommonHFSCatalogFileRecord fr = (CommonHFSCatalogFileRecord)((Object)this.attributes);
            if (fr.getData().isHardFileLink()) {
                int inodeNumber = fr.getData().getHardLinkInode();
                CommonHFSCatalogFileRecord rec = this.parentEntry.getFileSystemHandler().lookupFileInode(inodeNumber);
                return Util.unsign(rec.getData().getPermissions().getSpecial());
            }
            if (fr.getData().isHardDirectoryLink()) {
                int inodeNumber = fr.getData().getHardLinkInode();
                CommonHFSCatalogFolderRecord rec = this.parentEntry.getFileSystemHandler().lookupDirectoryInode(inodeNumber);
                return Util.unsign(rec.getData().getPermissions().getSpecial());
            }
        }
        return null;
    }
}

