/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs.hfs;

import org.catacombae.storage.fs.DefaultFileSystemHandlerInfo;
import org.catacombae.storage.fs.FileSystemHandler;
import org.catacombae.storage.fs.FileSystemHandlerFactory;
import org.catacombae.storage.fs.FileSystemHandlerInfo;
import org.catacombae.storage.fs.FileSystemRecognizer;
import org.catacombae.storage.fs.hfs.HFSFileSystemHandler;
import org.catacombae.storage.fs.hfs.HFSFileSystemRecognizer;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandlerFactory;
import org.catacombae.storage.io.DataLocator;

public class HFSFileSystemHandlerFactory
extends HFSCommonFileSystemHandlerFactory {
    private static final FileSystemRecognizer recognizer = new HFSFileSystemRecognizer();
    private static final FileSystemHandlerInfo handlerInfo = new DefaultFileSystemHandlerInfo("org.catacombae.hfs_handler", "HFS file system handler", "1.0", 0L, "Erik Larsson, Catacombae Software");
    private static final FileSystemHandlerFactory.CustomAttribute stringEncodingAttribute = HFSFileSystemHandlerFactory.createCustomAttribute(FileSystemHandlerFactory.AttributeType.STRING, "HFS_STRING_ENCODING", "The string encoding for filenames in the current HFS file system", "MacRoman");

    public FileSystemHandler createHandler(DataLocator data) {
        boolean useCaching = this.createAttributes.getBooleanAttribute(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED);
        String encoding = this.createAttributes.getStringAttribute(stringEncodingAttribute);
        return this.createHandlerInternal(data, useCaching, encoding);
    }

    protected FileSystemHandler createHandlerInternal(DataLocator data, boolean useCaching, String encoding) {
        return new HFSFileSystemHandler(data, useCaching, encoding);
    }

    public FileSystemHandlerInfo getHandlerInfo() {
        return handlerInfo;
    }

    public FileSystemHandlerFactory.StandardAttribute[] getSupportedStandardAttributes() {
        this.setStandardAttributeDefaultValue(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED, true);
        return new FileSystemHandlerFactory.StandardAttribute[]{FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED};
    }

    public FileSystemHandlerFactory.CustomAttribute[] getSupportedCustomAttributes() {
        return new FileSystemHandlerFactory.CustomAttribute[]{stringEncodingAttribute};
    }

    public FileSystemHandlerFactory newInstance() {
        return new HFSFileSystemHandlerFactory();
    }

    public FileSystemRecognizer getRecognizer() {
        return recognizer;
    }
}

