/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs;

public class WindowsFileAttributes {
    private static final int FILE_ATTRIBUTE_READONLY = 1;
    private static final int FILE_ATTRIBUTE_HIDDEN = 2;
    private static final int FILE_ATTRIBUTE_SYSTEM = 4;
    private static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    private static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    private static final int FILE_ATTRIBUTE_NORMAL = 128;
    private static final int FILE_ATTRIBUTE_TEMPORARY = 256;
    private static final int FILE_ATTRIBUTE_SPARSE_FILE = 512;
    private static final int FILE_ATTRIBUTE_REPARSE_POINT = 1024;
    private static final int FILE_ATTRIBUTE_COMPRESSED = 2048;
    private static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
    private static final int FILE_ATTRIBUTE_OFFLINE = 4096;
    private static final int FILE_ATTRIBUTE_VIRTUAL = 65536;
    private final int attributeDword;

    public WindowsFileAttributes(int iAttributeDword) {
        this.attributeDword = iAttributeDword;
    }

    public boolean isReadOnly() {
        return (this.attributeDword & 1) != 0;
    }

    public boolean isHidden() {
        return (this.attributeDword & 2) != 0;
    }

    public boolean isSystem() {
        return (this.attributeDword & 4) != 0;
    }

    public boolean isDirectory() {
        return (this.attributeDword & 0x10) != 0;
    }

    public boolean isArchive() {
        return (this.attributeDword & 0x20) != 0;
    }

    public boolean isNormal() {
        return (this.attributeDword & 0x80) != 0;
    }

    public boolean isTemporary() {
        return (this.attributeDword & 0x100) != 0;
    }

    public boolean isSparseFile() {
        return (this.attributeDword & 0x200) != 0;
    }

    public boolean isReparsePoint() {
        return (this.attributeDword & 0x400) != 0;
    }

    public boolean isCompressed() {
        return (this.attributeDword & 0x800) != 0;
    }

    public boolean isEncrypted() {
        return (this.attributeDword & 0x4000) != 0;
    }

    public boolean isOffline() {
        return (this.attributeDword & 0x1000) != 0;
    }

    public boolean isVirtual() {
        return (this.attributeDword & 0x10000) != 0;
    }
}

