/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs;

import java.util.HashMap;
import java.util.Map;
import org.catacombae.storage.fs.FileSystemCapability;
import org.catacombae.storage.fs.FileSystemHandler;
import org.catacombae.storage.fs.FileSystemHandlerInfo;
import org.catacombae.storage.fs.FileSystemRecognizer;
import org.catacombae.storage.io.DataLocator;

public abstract class FileSystemHandlerFactory {
    protected final Attributes createAttributes = new Attributes(this.getSupportedStandardAttributes(), this.getSupportedCustomAttributes());

    protected FileSystemHandlerFactory() {
    }

    public abstract FileSystemRecognizer getRecognizer();

    public abstract FileSystemHandler createHandler(DataLocator var1);

    public abstract FileSystemHandlerInfo getHandlerInfo();

    public abstract FileSystemCapability[] getCapabilities();

    public boolean hasCapability(FileSystemCapability c) {
        for (FileSystemCapability cur : this.getCapabilities()) {
            if (cur != c) continue;
            return true;
        }
        return false;
    }

    public abstract FileSystemHandlerFactory newInstance();

    public Attributes getCreateAttributes() {
        return this.createAttributes;
    }

    public abstract StandardAttribute[] getSupportedStandardAttributes();

    public abstract CustomAttribute[] getSupportedCustomAttributes();

    public CustomAttribute getCustomAttribute(String name) {
        for (CustomAttribute attr : this.getSupportedCustomAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public boolean isSupported(StandardAttribute attr) {
        for (StandardAttribute sa : this.getSupportedStandardAttributes()) {
            if (sa != attr) continue;
            return true;
        }
        return false;
    }

    protected void setStandardAttributeDefaultValue(StandardAttribute attr, Object defaultValue) {
        attr.setDefaultValue(defaultValue);
    }

    protected static CustomAttribute createCustomAttribute(AttributeType iType, String iName, String iDescription, Object iDefaultValue) {
        CustomAttribute createdCustomAttribute = new CustomAttribute(iType, iName, iDescription, iDefaultValue);
        return createdCustomAttribute;
    }

    public static final class CustomAttribute {
        private final AttributeType type;
        private final String name;
        private final String description;
        private final Object defaultValue;

        private CustomAttribute(AttributeType iType, String iName, String iDescription, Object iDefaultValue) {
            if (iType == null) {
                throw new IllegalArgumentException("An attribute must have a type.");
            }
            if (iName == null) {
                throw new IllegalArgumentException("An attribute must have a name.");
            }
            if (iDescription == null) {
                throw new IllegalArgumentException("An attribute must have a description.");
            }
            if (iDefaultValue == null) {
                throw new IllegalArgumentException("An attribute must have a default value.");
            }
            if (!iType.isValidValue(iDefaultValue)) {
                throw new IllegalArgumentException("Illegal default value!");
            }
            this.type = iType;
            this.name = iName;
            this.description = iDescription;
            this.defaultValue = iDefaultValue;
        }

        public AttributeType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardAttribute {
        CACHING_ENABLED(AttributeType.BOOLEAN, new Boolean(false));

        private final AttributeType type;
        private Object defaultValue;

        private StandardAttribute(AttributeType iType, Object iDefaultValue) {
            this.type = iType;
            this.setDefaultValue(iDefaultValue);
        }

        public AttributeType getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        private void setDefaultValue(Object iDefaultValue) {
            if (!this.type.isValidValue(iDefaultValue)) {
                throw new IllegalArgumentException("Illegal default value!");
            }
            this.defaultValue = iDefaultValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeType {
        BOOLEAN(Boolean.class),
        INTEGER(Byte.class, Short.class, Integer.class, Long.class),
        STRING(String.class);

        private final Class[] valueSuperClasses;

        private AttributeType(Class ... iValueSuperClasses) {
            this.valueSuperClasses = iValueSuperClasses;
        }

        public boolean isValidValue(Object value) {
            for (Class c : this.valueSuperClasses) {
                if (!c.isInstance(value)) continue;
                return true;
            }
            return false;
        }
    }

    public class Attributes {
        private final Map<StandardAttribute, Object> standardCreateAttributeMap = new HashMap<StandardAttribute, Object>();
        private final Map<CustomAttribute, Object> customCreateAttributeMap = new HashMap<CustomAttribute, Object>();

        private Attributes(StandardAttribute[] iSupportedStandardAttributes, CustomAttribute[] iSupportedCustomAttributes) {
            for (StandardAttribute standardAttribute : iSupportedStandardAttributes) {
                this.standardCreateAttributeMap.put(standardAttribute, standardAttribute.getDefaultValue());
            }
            for (CustomAttribute customAttribute : iSupportedCustomAttributes) {
                this.customCreateAttributeMap.put(customAttribute, customAttribute.getDefaultValue());
            }
        }

        public final Boolean getBooleanAttribute(StandardAttribute attr) {
            return this.getBooleanAttribute(attr.getType(), this.standardCreateAttributeMap.get((Object)attr));
        }

        public final Long getIntegerAttribute(StandardAttribute attr) {
            return this.getIntegerAttribute(attr.getType(), this.standardCreateAttributeMap.get((Object)attr));
        }

        public final String getStringAttribute(StandardAttribute attr) {
            return this.getStringAttribute(attr.getType(), this.standardCreateAttributeMap.get((Object)attr));
        }

        public final Boolean getBooleanAttribute(CustomAttribute attr) {
            return this.getBooleanAttribute(attr.getType(), this.customCreateAttributeMap.get(attr));
        }

        public final Long getIntegerAttribute(CustomAttribute attr) {
            return this.getIntegerAttribute(attr.getType(), this.customCreateAttributeMap.get(attr));
        }

        public final String getStringAttribute(CustomAttribute attr) {
            return this.getStringAttribute(attr.getType(), this.customCreateAttributeMap.get(attr));
        }

        public void setBooleanAttribute(StandardAttribute attr, Boolean value) {
            this.setAttribute(attr, (Object)value, this.standardCreateAttributeMap.get((Object)attr));
        }

        public void setIntegerAttribute(StandardAttribute attr, Integer value) {
            this.setAttribute(attr, (Object)value, this.standardCreateAttributeMap.get((Object)attr));
        }

        public void setStringAttribute(StandardAttribute attr, String value) {
            this.setAttribute(attr, (Object)value, this.standardCreateAttributeMap.get((Object)attr));
        }

        public void setBooleanAttribute(CustomAttribute attr, Boolean value) {
            this.setAttribute(attr, (Object)value, this.customCreateAttributeMap.get(attr));
        }

        public void setIntegerAttribute(CustomAttribute attr, Integer value) {
            this.setAttribute(attr, (Object)value, this.customCreateAttributeMap.get(attr));
        }

        public void setStringAttribute(CustomAttribute attr, String value) {
            this.setAttribute(attr, (Object)value, this.customCreateAttributeMap.get(attr));
        }

        private final Boolean getBooleanAttribute(AttributeType type, Object value) {
            if (type != AttributeType.BOOLEAN) {
                throw new IllegalArgumentException("Tried to get BOOLEAN value from " + (Object)((Object)type) + " type!");
            }
            if (value == null) {
                throw new IllegalArgumentException("Attribute is not supported by this implementation!");
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new RuntimeException("INTERNAL ERROR: Kick the coder for inserting " + value.getClass() + " values in a " + "BOOLEAN attribute.");
        }

        private final Long getIntegerAttribute(AttributeType type, Object value) {
            if (type != AttributeType.INTEGER) {
                throw new IllegalArgumentException("Tried to get INTEGER value from " + (Object)((Object)type) + " type!");
            }
            if (value == null) {
                throw new IllegalArgumentException("Attribute is not supported by this implementation!");
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            throw new RuntimeException("INTERNAL ERROR: Kick the coder for inserting " + value.getClass() + " values in an " + "INTEGER attribute.");
        }

        private final String getStringAttribute(AttributeType type, Object value) {
            if (type != AttributeType.STRING) {
                throw new IllegalArgumentException("Tried to get STRING value from " + (Object)((Object)type) + " type!");
            }
            if (value == null) {
                throw new IllegalArgumentException("Attribute is not supported by this implementation!");
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new RuntimeException("INTERNAL ERROR: Kick the coder for inserting " + value.getClass() + " values in a " + "STRING attribute.");
        }

        private void setAttribute(StandardAttribute attr, Object newValue, Object oldValue) {
            if (!attr.getType().isValidValue(newValue)) {
                throw new IllegalArgumentException("Invalid value type (" + newValue.getClass() + ") for attribute (" + (Object)((Object)attr) + ")!");
            }
            if (oldValue == null) {
                throw new IllegalArgumentException("Attribute " + (Object)((Object)attr) + " is not supported " + "by this implementation!");
            }
            this.standardCreateAttributeMap.put(attr, newValue);
        }

        private void setAttribute(CustomAttribute attr, Object newValue, Object oldValue) {
            if (!attr.getType().isValidValue(newValue)) {
                throw new IllegalArgumentException("Invalid value type (" + newValue.getClass() + ") for attribute (" + attr + ")!");
            }
            if (oldValue == null) {
                throw new IllegalArgumentException("Attribute " + attr + " is not supported " + "by this implementation!");
            }
            this.customCreateAttributeMap.put(attr, newValue);
        }
    }
}

