/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs;

import java.util.LinkedList;
import org.catacombae.storage.fs.FSEntry;
import org.catacombae.storage.fs.FSFile;
import org.catacombae.storage.fs.FSFolder;
import org.catacombae.storage.fs.FSForkType;
import org.catacombae.storage.fs.FSLink;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystemHandler {
    private static final boolean DEBUG = Util.booleanEnabledByProperties(false, "org.catacombae.debug", "org.catacombae.storage.debug", "org.catacombae.storage.fs.debug", "org.catacombae.storage.fs." + FileSystemHandler.class.getSimpleName() + ".debug");

    public abstract FSEntry[] list(String ... var1);

    public abstract FSFolder getRoot();

    public abstract FSEntry getEntry(String ... var1);

    public FSEntry getEntryByPosixPath(String posixPath, String ... rootFolderPath) throws IllegalArgumentException {
        String[] path = this.getTruePathFromPosixPath(posixPath, rootFolderPath);
        if (path != null) {
            FSEntry entry = this.getEntry(path);
            return entry;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getTruePathFromPosixPath(String posixPath, String ... rootFolderPath) throws IllegalArgumentException {
        String[] components = posixPath.split("/");
        int i = 0;
        LinkedList<String> pathStack = new LinkedList<String>();
        LinkedList<String[]> visitedLinks = null;
        if (posixPath.startsWith("/")) {
            i = 1;
        } else {
            for (String pathComponent : rootFolderPath) {
                pathStack.addLast(pathComponent);
            }
        }
        FSEntry curEntry2 = null;
        while (i < components.length) {
            FSFolder curFolder;
            String[] curPath = null;
            if (curEntry2 == null) {
                if (curPath == null) {
                    curPath = pathStack.toArray(new String[pathStack.size()]);
                }
                curEntry2 = this.getEntry(curPath);
            }
            if (curEntry2 instanceof FSFolder) {
                curFolder = (FSFolder)curEntry2;
            } else {
                FSEntry linkTarget;
                if (!(curEntry2 instanceof FSLink)) return null;
                FSLink curLink = (FSLink)curEntry2;
                if (visitedLinks == null) {
                    visitedLinks = new LinkedList<String[]>();
                } else {
                    visitedLinks.clear();
                }
                if (curPath == null) {
                    curPath = pathStack.toArray(new String[pathStack.size()]);
                }
                if ((linkTarget = this.resolveLinks(curPath, curLink, visitedLinks)) == null) {
                    return null;
                }
                if (!(linkTarget instanceof FSFolder)) {
                    if (!(linkTarget instanceof FSFile)) throw new RuntimeException("Unknown type: " + linkTarget.getClass());
                    return null;
                }
                curFolder = (FSFolder)linkTarget;
                visitedLinks.clear();
            }
            String curPathComponent = components[i];
            if (curPathComponent.length() != 0 && !curPathComponent.equals(".")) {
                if (curPathComponent.equals("..")) {
                    if (pathStack.size() <= 0) return null;
                    pathStack.removeLast();
                    curEntry2 = null;
                } else {
                    String fsPathnameComponent = this.parsePosixPathnameComponent(curPathComponent);
                    FSEntry nextEntry = curFolder.getChild(fsPathnameComponent);
                    if (nextEntry == null) return null;
                    curEntry2 = nextEntry;
                    pathStack.add(nextEntry.getName());
                }
            }
            ++i;
        }
        return pathStack.toArray(new String[pathStack.size()]);
    }

    public FSEntry resolveLinks(String[] linkPath, FSLink link) {
        return this.resolveLinks(linkPath, link, new LinkedList<String[]>());
    }

    private FSEntry resolveLinks(String[] curPath, FSLink curLink, LinkedList<String[]> visitedLinks) {
        if (DEBUG) {
            System.err.println("resolveLinks(" + Util.concatenateStrings(curPath, "/") + ", " + curLink.getLinkTargetString() + ", ...);");
        }
        visitedLinks.add(curPath);
        FSEntry linkTarget = null;
        String[] curLinkPath = curPath;
        while (curLinkPath != null) {
            String[] linkTargetPath;
            Object[] parentPath = Util.arrayCopy(curLinkPath, 0, new String[curLinkPath.length - 1], 0, curLinkPath.length - 1);
            if (DEBUG) {
                System.err.println("  Resolving " + curLink.getLinkTargetString() + " from " + Util.concatenateStrings(parentPath, "/"));
            }
            if ((linkTargetPath = this.getTargetPath(curLink, (String[])parentPath)) == null) {
                return null;
            }
            if (Util.contains(visitedLinks, linkTargetPath)) {
                return null;
            }
            linkTarget = this.getEntry(linkTargetPath);
            if (linkTarget != null && linkTarget instanceof FSLink) {
                curLink = (FSLink)linkTarget;
                curLinkPath = linkTargetPath;
                visitedLinks.add(curLinkPath);
                continue;
            }
            curLinkPath = null;
        }
        return linkTarget;
    }

    public abstract String parsePosixPathnameComponent(String var1);

    public abstract String generatePosixPathnameComponent(String var1);

    public abstract String[] getTargetPath(FSLink var1, String[] var2);

    public abstract FSForkType[] getSupportedForkTypes();

    public abstract void close();
}

