/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.storage.fs;

import java.util.LinkedList;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.storage.fs.FileSystemHandlerFactory;
import org.catacombae.storage.fs.FileSystemMajorType;
import org.catacombae.storage.io.DataLocator;

public class FileSystemDetector {
    public static FileSystemMajorType[] detectFileSystem(DataLocator inputDataLocator) {
        ReadableRandomAccessStream dlStream = inputDataLocator.createReadOnlyFile();
        FileSystemMajorType[] result = FileSystemDetector.detectFileSystem(dlStream);
        dlStream.close();
        return result;
    }

    public static FileSystemMajorType[] detectFileSystem(ReadableRandomAccessStream fsStream) {
        long len;
        try {
            len = fsStream.length();
        }
        catch (RuntimeIOException e) {
            len = -1L;
        }
        return FileSystemDetector.detectFileSystem(fsStream, 0L, len);
    }

    public static FileSystemMajorType[] detectFileSystem(ReadableRandomAccessStream fsStream, long off, long len) {
        LinkedList<FileSystemMajorType> result = new LinkedList<FileSystemMajorType>();
        for (FileSystemMajorType type : FileSystemMajorType.values()) {
            FileSystemHandlerFactory fact = type.createDefaultHandlerFactory();
            if (fact == null || !fact.getRecognizer().detect(fsStream, off, len)) continue;
            result.add(type);
        }
        return result.toArray(new FileSystemMajorType[result.size()]);
    }
}

