/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class MainWindow
extends JFrame {
    private static final String BASE_TITLE = "jParted";
    private JMenuItem loadFileItem;
    private JMenuItem loadPathItem;
    private JMenuItem exitItem;
    private JMenuItem aboutItem;
    private JPanel mainPanel;

    public MainWindow(JPanel mainPanel) {
        super(BASE_TITLE);
        this.mainPanel = mainPanel;
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.setupMenus();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private static void setAbstractButtonListener(AbstractButton button, ActionListener listener) {
        for (ActionListener al : button.getActionListeners()) {
            button.removeActionListener(al);
        }
        button.addActionListener(listener);
    }

    public void setLoadFileItemListener(ActionListener listener) {
        MainWindow.setAbstractButtonListener(this.loadFileItem, listener);
    }

    public void setLoadPathItemListener(ActionListener listener) {
        MainWindow.setAbstractButtonListener(this.loadPathItem, listener);
    }

    public void setExitItemListener(ActionListener listener) {
        MainWindow.setAbstractButtonListener(this.exitItem, listener);
    }

    public void setAboutItemListener(ActionListener listener) {
        MainWindow.setAbstractButtonListener(this.aboutItem, listener);
    }

    public void setCurrentFilename(String filename) {
        this.setTitle("jParted - [" + filename + "]");
    }

    private void setupMenus() {
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        this.loadFileItem = new JMenuItem("Load from file...");
        fileMenu.add(this.loadFileItem);
        this.loadPathItem = new JMenuItem("Load from path...");
        fileMenu.add(this.loadPathItem);
        this.exitItem = new JMenuItem("Quit");
        fileMenu.add(this.exitItem);
        this.aboutItem = new JMenuItem("About...");
        helpMenu.add(this.aboutItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }
}

