/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.util.Util;

public class ResourceType
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 8;
    private final byte[] type = new byte[4];
    private final byte[] instanceCount = new byte[2];
    private final byte[] referenceListOffset = new byte[2];

    public ResourceType(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.type, 0, 4);
        System.arraycopy(data, offset + 4, this.instanceCount, 0, 2);
        System.arraycopy(data, offset + 6, this.referenceListOffset, 0, 2);
    }

    public static int length() {
        return 8;
    }

    public byte[] getType() {
        return Util.readByteArrayBE(this.type);
    }

    public short getInstanceCount() {
        return Util.readShortBE(this.instanceCount);
    }

    public short getReferenceListOffset() {
        return Util.readShortBE(this.referenceListOffset);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " type: " + Util.toASCIIString(this.getType()));
        ps.println(prefix + " instanceCount: " + this.getInstanceCount());
        ps.println(prefix + " referenceListOffset: " + this.getReferenceListOffset());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ResourceType:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[ResourceType.length()];
        int offset = 0;
        System.arraycopy(this.type, 0, result, offset, this.type.length);
        System.arraycopy(this.instanceCount, 0, result, offset += this.type.length, this.instanceCount.length);
        System.arraycopy(this.referenceListOffset, 0, result, offset += this.instanceCount.length, this.referenceListOffset.length);
        offset += this.referenceListOffset.length;
        return result;
    }

    public int size() {
        return ResourceType.length();
    }
}

