/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.io.FileOutputStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.storage.ps.gpt.types.GUIDPartitionTable;
import org.catacombae.util.Util;

public class PrintGPTPartitions {
    public static void main(String[] args) throws Exception {
        ReadableRandomAccessStream llf = ReadableWin32FileStream.isSystemSupported() ? new ReadableWin32FileStream(args[0]) : new ReadableFileStream(args[0]);
        byte[] referencetable = new byte[16896];
        llf.seek(512L);
        llf.readFully(referencetable);
        FileOutputStream refFile = new FileOutputStream("gpt_table_ref.debug");
        refFile.write(referencetable);
        refFile.close();
        System.out.println("Wrote the raw GPT table to file: gpt_table_ref.debug");
        System.out.println("Length of file: " + llf.length());
        GUIDPartitionTable gpt = new GUIDPartitionTable(llf, 0);
        System.out.println("Calculated checksum for header: 0x" + Util.toHexStringBE(gpt.calculatePrimaryHeaderChecksum()));
        System.out.println("Calculated checksum for entries: 0x" + Util.toHexStringBE(gpt.calculatePrimaryEntriesChecksum()));
        gpt.print(System.out, "");
        System.out.println("Is this partition table valid? " + gpt.isValid() + ".");
        FileOutputStream debug = new FileOutputStream("gpt_table.debug");
        debug.write(gpt.getPrimaryTableBytes());
        debug.close();
        System.out.println("Wrote the leading GPT table to file: gpt_table.debug");
        llf.close();
    }
}

