/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.LinkedList;
import org.catacombae.storage.ps.apm.types.APMPartition;
import org.catacombae.storage.ps.apm.types.DriverDescriptorRecord;
import org.catacombae.util.Util;

public class MkAPM {
    private static Options options = new Options();

    private static boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String curArg = args[i];
            System.err.println("Processing argument " + i + ": " + curArg);
            if (curArg.equals("--sector-size")) {
                if (i + 1 == args.length - 1) {
                    System.err.println("Incomplete sector size specification.");
                    return false;
                }
                try {
                    MkAPM.options.blockSize = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error: Invalid sector size \"" + args[i] + "\".");
                    return false;
                }
            }
            if (curArg.equals("--part")) {
                if (i + 4 == args.length - 1) {
                    System.err.println("Incomplete part specification.");
                    return false;
                }
                PartitionSpec p = new PartitionSpec();
                try {
                    p.partitionByteStart = Long.parseLong(args[++i]);
                    p.partitionByteLength = Long.parseLong(args[++i]);
                    p.partitionName = args[++i];
                    p.partitionType = args[++i];
                }
                catch (Exception e) {
                    System.err.println("Error: Invalid partition specification.");
                    return false;
                }
                MkAPM.options.partitions.add(p);
                continue;
            }
            System.err.println("Unrecognized argument: \"" + curArg + "\"");
            return false;
        }
        String filename = args[args.length - 1];
        try {
            MkAPM.options.file = new RandomAccessFile(filename, "r");
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: Failed to open file \"" + filename + "\".");
            return false;
        }
        if (MkAPM.options.blockSize == null) {
            System.err.println("Error: No block size specified.");
            return false;
        }
        int i = 0;
        for (PartitionSpec ps : MkAPM.options.partitions) {
            if (ps.partitionByteStart % (long)MkAPM.options.blockSize.intValue() != 0L) {
                System.err.println("Error: Start of partition " + i + " is not a multiple of sector size.");
                return false;
            }
            if (ps.partitionByteLength % (long)MkAPM.options.blockSize.intValue() != 0L) {
                System.err.println("Error: Length of partition " + i + " is not a multiple of sector size.");
                return false;
            }
            if (ps.partitionName.length() > 32) {
                System.err.println("Error: Name of partition " + i + " is too long.");
                return false;
            }
            if (ps.partitionType.length() > 32) {
                System.err.println("Error: Type of partition " + i + " is too long.");
                return false;
            }
            try {
                Util.encodeASCIIString(ps.partitionName);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error: Name of partition " + i + " contains invalid characters.");
                return false;
            }
            try {
                Util.encodeASCIIString(ps.partitionType);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error: Type of partition " + i + " contains invalid characters.");
                return false;
            }
        }
        try {
            MkAPM.options.file.close();
            MkAPM.options.file = new RandomAccessFile(filename, "rw");
        }
        catch (FileNotFoundException ex) {
            System.err.println("Error: Failed to open file \"" + filename + "\".");
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private static void printUsage() {
        System.err.println("usage: mkapm --sector-size <sector size> --part <start offset> <length> <partition name> <partition type>");
    }

    private static void writeWithPadding(RandomAccessFile file, byte[] data, int paddedSize) throws IOException {
        byte[] fullBlock = new byte[paddedSize];
        System.arraycopy(data, 0, fullBlock, 0, data.length);
        Arrays.fill(fullBlock, data.length, fullBlock.length, (byte)0);
        file.write(fullBlock);
    }

    public static void main(String[] args) {
        long deviceByteCount;
        System.err.println("YO! args.length=" + args.length);
        if (args.length == 0 || !MkAPM.parseOptions(args)) {
            MkAPM.printUsage();
            System.exit(1);
            return;
        }
        try {
            deviceByteCount = MkAPM.options.file.length();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
            return;
        }
        if (deviceByteCount % (long)MkAPM.options.blockSize.intValue() != 0L) {
            System.err.println("Error: File size is not a multiple of sector size.");
            MkAPM.printUsage();
            System.exit(1);
            return;
        }
        long deviceBlockCount = deviceByteCount / (long)MkAPM.options.blockSize.intValue();
        DriverDescriptorRecord ddr = new DriverDescriptorRecord(MkAPM.options.blockSize, deviceBlockCount);
        LinkedList<APMPartition> partitions = new LinkedList<APMPartition>();
        partitions.add(new APMPartition(2L, 1L, 15L, "Apple", "Apple_partition_map", 0, MkAPM.options.blockSize));
        for (PartitionSpec ps : MkAPM.options.partitions) {
            APMPartition curPart = new APMPartition(2L, ps.partitionByteStart / (long)MkAPM.options.blockSize.intValue(), ps.partitionByteLength / (long)MkAPM.options.blockSize.intValue(), ps.partitionName, ps.partitionType, 0x40000077, MkAPM.options.blockSize);
            partitions.add(curPart);
        }
        try {
            MkAPM.writeWithPadding(MkAPM.options.file, ddr.getData(), MkAPM.options.blockSize);
            for (APMPartition p : partitions) {
                System.err.println("Writing out partition:");
                p.print(System.err, "\t");
                MkAPM.writeWithPadding(MkAPM.options.file, p.getData(), MkAPM.options.blockSize);
            }
            MkAPM.writeWithPadding(MkAPM.options.file, new byte[0], 15 * MkAPM.options.blockSize - (partitions.size() + 1) * MkAPM.options.blockSize);
            MkAPM.options.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class Options {
        Integer blockSize = null;
        final LinkedList<PartitionSpec> partitions = new LinkedList();
        RandomAccessFile file = null;

        private Options() {
        }
    }

    private static class PartitionSpec {
        Long partitionByteStart = null;
        Long partitionByteLength = null;
        String partitionName = null;
        String partitionType = null;

        private PartitionSpec() {
        }
    }
}

