/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeSet;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfs.types.hfsplus.JournalInfoBlock;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.storage.fs.FileSystemDetector;
import org.catacombae.storage.fs.FileSystemHandler;
import org.catacombae.storage.fs.FileSystemHandlerFactory;
import org.catacombae.storage.fs.FileSystemMajorType;
import org.catacombae.storage.fs.hfs.HFSFileSystemHandler;
import org.catacombae.storage.fs.hfsplus.HFSPlusFileSystemHandler;
import org.catacombae.storage.fs.hfsx.HFSXFileSystemHandler;
import org.catacombae.storage.io.ReadableStreamDataLocator;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.util.Util;

public class DumpHfs {
    private static void printUsage() {
        System.err.println("usage: DumpHfs <device|file>");
    }

    public static void main(String[] args) {
        long i;
        boolean isHfsPlus;
        HFSVolume vol;
        if (args.length != 1) {
            DumpHfs.printUsage();
            System.exit(1);
            return;
        }
        String devicePath = args[0];
        ReadableRandomAccessStream stream = ReadableWin32FileStream.isSystemSupported() ? new ReadableWin32FileStream(devicePath) : new ReadableFileStream(devicePath);
        ReadableStreamDataLocator inputDataLocator = new ReadableStreamDataLocator(stream);
        FileSystemMajorType[] fsTypes = FileSystemDetector.detectFileSystem(inputDataLocator);
        FileSystemHandlerFactory fact = null;
        block7: for (FileSystemMajorType type : fsTypes) {
            switch (type) {
                case APPLE_HFS: 
                case APPLE_HFS_PLUS: 
                case APPLE_HFSX: {
                    fact = type.createDefaultHandlerFactory();
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        if (fact == null) {
            System.err.println("No HFS file system found.");
            System.exit(1);
            return;
        }
        FileSystemHandler fsHandler = fact.createHandler(inputDataLocator);
        if (fsHandler instanceof HFSFileSystemHandler) {
            vol = ((HFSFileSystemHandler)fsHandler).getFSView();
            isHfsPlus = false;
        } else if (fsHandler instanceof HFSPlusFileSystemHandler) {
            vol = ((HFSPlusFileSystemHandler)fsHandler).getFSView();
            isHfsPlus = true;
        } else if (fsHandler instanceof HFSXFileSystemHandler) {
            vol = ((HFSXFileSystemHandler)fsHandler).getFSView();
            isHfsPlus = true;
        } else {
            throw new RuntimeException("Unexpected handler type: " + fsHandler.getClass());
        }
        CommonHFSVolumeHeader volumeHeader = vol.getVolumeHeader();
        int sectorSize = 512;
        long allocationBlockSize = volumeHeader.getAllocationBlockSize();
        long sectorsPerAllocationBlock = allocationBlockSize / 512L;
        long allocationBlockStart = volumeHeader.getAllocationBlockStart();
        long allocationBlockCount = volumeHeader.getTotalBlocks();
        TreeSet<Long> inUseSectors = new TreeSet<Long>();
        ReadableRandomAccessStream fsStream = vol.createFSStream();
        byte[] buffer = new byte[512];
        if (allocationBlockSize % 512L != 0L) {
            throw new RuntimeException("Uneven block size: " + allocationBlockSize);
        }
        for (i = 0L; i < allocationBlockStart; ++i) {
            inUseSectors.add(i);
        }
        if (allocationBlockStart < 3L) {
            for (i = allocationBlockStart; i < 3L; ++i) {
                inUseSectors.add(i);
            }
        }
        for (i = 0L; i < sectorsPerAllocationBlock; ++i) {
            inUseSectors.add(allocationBlockStart + (allocationBlockCount - 1L) * sectorsPerAllocationBlock + i);
        }
        long sectorCount = (volumeHeader.getFileSystemEnd() - 1L) / 512L + 1L;
        inUseSectors.add(sectorCount - 1L);
        int i2 = 0;
        while ((long)i2 < sectorsPerAllocationBlock - 1L) {
            int res;
            try {
                fsStream.seek(sectorCount * 512L);
                res = fsStream.read(buffer);
            }
            catch (Exception exception) {
                break;
            }
            if (res == -1) break;
            inUseSectors.add(sectorCount);
            ++sectorCount;
            ++i2;
        }
        LinkedList<Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>> metadataForks = new LinkedList<Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>>();
        metadataForks.add(new Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>(volumeHeader.getCatalogFile(), CommonHFSCatalogNodeID.ReservedID.CATALOG_FILE));
        metadataForks.add(new Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>(volumeHeader.getExtentsOverflowFile(), CommonHFSCatalogNodeID.ReservedID.EXTENTS_FILE));
        metadataForks.add(new Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>(volumeHeader.getAllocationFile(), CommonHFSCatalogNodeID.ReservedID.ALLOCATION_FILE));
        metadataForks.add(new Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>(volumeHeader.getAttributesFile(), CommonHFSCatalogNodeID.ReservedID.ATTRIBUTES_FILE));
        metadataForks.add(new Util.Pair<CommonHFSForkData, CommonHFSCatalogNodeID.ReservedID>(volumeHeader.getStartupFile(), CommonHFSCatalogNodeID.ReservedID.STARTUP_FILE));
        for (Util.Pair pair : metadataForks) {
            CommonHFSExtentDescriptor[] allExtents;
            CommonHFSForkData curForkData = (CommonHFSForkData)pair.getA();
            CommonHFSCatalogNodeID.ReservedID curId = (CommonHFSCatalogNodeID.ReservedID)((Object)pair.getB());
            if (curForkData == null) continue;
            CommonHFSCatalogNodeID nodeId = isHfsPlus ? CommonHFSCatalogNodeID.getHFSPlusReservedID(curId) : CommonHFSCatalogNodeID.getHFSReservedID(curId);
            for (CommonHFSExtentDescriptor curExtent : allExtents = vol.getExtentsOverflowFile().getAllDataExtentDescriptors(nodeId, curForkData)) {
                long startSector = allocationBlockStart + curExtent.getStartBlock() * sectorsPerAllocationBlock;
                long endSector = startSector + curExtent.getBlockCount() * sectorsPerAllocationBlock;
                for (long i3 = startSector; i3 < endSector; ++i3) {
                    inUseSectors.add(i3);
                }
            }
        }
        Journal journal = vol.getJournal();
        if (isHfsPlus && journal != null) {
            long l = allocationBlockStart + ((CommonHFSVolumeHeader.HFSPlusImplementation)volumeHeader).getJournalInfoBlock() * sectorsPerAllocationBlock;
            inUseSectors.add(l);
            JournalInfoBlock jib = vol.getJournal().getJournalInfoBlock();
            long journalStartSector = jib.getRawOffset() / 512L;
            long journalLastSector = (jib.getRawOffset() + jib.getRawSize() - 1L) / 512L;
            for (long i4 = journalStartSector; i4 <= journalLastSector; ++i4) {
                inUseSectors.add(i4);
            }
        }
        byte[] byArray = new byte[512];
        Util.zero(new byte[][]{byArray});
        for (long i5 = 0L; i5 < sectorCount; ++i5) {
            byte[] curBuffer;
            if (inUseSectors.contains(i5)) {
                fsStream.seek(i5 * 512L);
                fsStream.readFully(buffer);
                curBuffer = buffer;
            } else {
                curBuffer = byArray;
            }
            try {
                System.out.write(curBuffer);
                continue;
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }
        fsStream.close();
    }
}

