/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.SelectDeviceDialog;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.ReadableStreamDataLocator;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionSystemDetector;
import org.catacombae.storage.ps.PartitionSystemHandler;
import org.catacombae.storage.ps.PartitionSystemHandlerFactory;
import org.catacombae.storage.ps.PartitionSystemType;
import org.catacombae.storage.ps.PartitionType;
import org.catacombae.storage.ps.apm.APMHandler;
import org.catacombae.storage.ps.apm.types.ApplePartitionMap;
import org.catacombae.storage.ps.apm.types.DriverDescriptorRecord;
import org.catacombae.storage.ps.gpt.GPTHandler;
import org.catacombae.storage.ps.gpt.types.GUIDPartitionTable;
import org.catacombae.storage.ps.mbr.MBRHandler;
import org.catacombae.storage.ps.mbr.types.MBRPartitionTable;

public class DumpFSInfo {
    public static void main(String[] args) throws Throwable {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            DumpFSInfo.dumpInfo(args);
            System.exit(0);
        }
        catch (Exception e) {
            GUIUtil.displayExceptionDialog(e, 25, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        System.exit(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpInfo(String[] args) throws Exception {
        long pos;
        File last64File;
        File first64File;
        long fsLength;
        long fsOffset;
        int partNum;
        LinkedList<File> generatedFiles;
        ReadableRandomAccessStream fsFile;
        long runTimestamp;
        block33: {
            int i;
            int firstPreferredPartition;
            Object[] partitions;
            PartitionSystemType detectedType;
            block34: {
                block31: {
                    FileOutputStream fos;
                    PartitionSystemHandler partSys;
                    block32: {
                        runTimestamp = System.currentTimeMillis();
                        if (args.length == 1) {
                            fsFile = ReadableWin32FileStream.isSystemSupported() ? new ReadableWin32FileStream(args[0]) : new ReadableFileStream(args[0]);
                        } else {
                            if (!SelectDeviceDialog.isSystemSupported()) {
                                System.out.println("Usage: java DumpFSInfo <filename>");
                                return;
                            }
                            if (args.length != 0) {
                                System.out.println("Usage: java DumpFSInfo <filename>");
                                System.out.println("        for reading directly from a specified file, or...");
                                System.out.println("       java DumpFSInfo");
                                System.out.println("        to pop up a device dialog where you can choose which device to read");
                                return;
                            }
                            SelectDeviceDialog swdd = SelectDeviceDialog.createSelectDeviceDialog(null, true, "Select device to extract info from");
                            swdd.setVisible(true);
                            fsFile = swdd.getPartitionStream();
                            if (fsFile == null) {
                                System.exit(0);
                            }
                        }
                        generatedFiles = new LinkedList<File>();
                        partNum = -1;
                        PartitionSystemType[] detectedTypes = PartitionSystemDetector.detectPartitionSystem(fsFile, false);
                        if (detectedTypes.length == 1) {
                            detectedType = detectedTypes[0];
                            PartitionSystemHandlerFactory fact = detectedType.createDefaultHandlerFactory();
                            partSys = fact.createHandler(new ReadableStreamDataLocator(fsFile));
                        } else if (detectedTypes.length == 0) {
                            detectedType = null;
                            partSys = null;
                        } else {
                            String msg = "Multiple partition system types detected:";
                            PartitionSystemType[] arr$ = detectedTypes;
                            int len$ = arr$.length;
                            int i$ = 0;
                            while (true) {
                                if (i$ >= len$) {
                                    throw new RuntimeException(msg);
                                }
                                PartitionSystemType t = arr$[i$];
                                msg = msg + " " + (Object)((Object)t);
                                ++i$;
                            }
                        }
                        if (partSys == null) break block31;
                        partitions = partSys.getPartitions();
                        if (partitions.length != 0) break block32;
                        fsOffset = 0L;
                        try {
                            fsLength = fsFile.length();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            fsLength = -1L;
                        }
                        break block33;
                    }
                    if (partSys instanceof APMHandler) {
                        APMHandler apmHandler = (APMHandler)partSys;
                        File ddrFile = new File("fsdump-" + runTimestamp + "_ddr.dat");
                        FileOutputStream fos2 = new FileOutputStream(ddrFile);
                        DriverDescriptorRecord ddr = apmHandler.readDriverDescriptorRecord();
                        fos2.write(ddr.getData());
                        fos2.close();
                        generatedFiles.add(ddrFile);
                        ApplePartitionMap apm = apmHandler.readPartitionMap();
                        if (apm == null) {
                            throw new RuntimeException("Failed to read APM data.");
                        }
                        File apmFile = new File("fsdump-" + runTimestamp + "_apm.dat");
                        fos2 = new FileOutputStream(apmFile);
                        fos2.write(apm.getData());
                        fos2.close();
                        generatedFiles.add(apmFile);
                    } else if (partSys instanceof GPTHandler) {
                        GPTHandler gptHandler = (GPTHandler)partSys;
                        File mbrFile = new File("fsdump-" + runTimestamp + "_protectivembr.dat");
                        byte[] mbrData = new byte[512];
                        fos = new FileOutputStream(mbrFile);
                        fsFile.seek(0L);
                        fsFile.readFully(mbrData);
                        fos.write(mbrData);
                        fos.close();
                        generatedFiles.add(mbrFile);
                        GUIDPartitionTable gpt = gptHandler.readPartitionTable();
                        if (gpt == null) {
                            throw new RuntimeException("Failed to read GPT data.");
                        }
                        File gptBeginFile = new File("fsdump-" + runTimestamp + "_gptprimary.dat");
                        fos = new FileOutputStream(gptBeginFile);
                        fos.write(gpt.getPrimaryTableBytes());
                        fos.close();
                        generatedFiles.add(gptBeginFile);
                        File gptEndFile = new File("fsdump-" + runTimestamp + "_gptbackup.dat");
                        fos = new FileOutputStream(gptEndFile);
                        fos.write(gpt.getBackupTableBytes());
                        fos.close();
                        generatedFiles.add(gptEndFile);
                    } else {
                        if (!(partSys instanceof MBRHandler)) {
                            throw new RuntimeException("Unknown partition system type!");
                        }
                        MBRHandler mbrHandler = (MBRHandler)partSys;
                        MBRPartitionTable mbr = mbrHandler.readPartitionTable();
                        File mbrFile = new File("fsdump-" + runTimestamp + "_mbr.dat");
                        fos = new FileOutputStream(mbrFile);
                        fos.write(mbr.getMasterBootRecord().getBytes());
                        fos.close();
                        generatedFiles.add(mbrFile);
                    }
                    firstPreferredPartition = 0;
                    break block34;
                }
                fsOffset = 0L;
                try {
                    fsLength = fsFile.length();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fsLength = -1L;
                }
                break block33;
            }
            for (i = 0; i < partitions.length; ++i) {
                Partition p = partitions[i];
                PartitionType pt = p.getType();
                if (pt != PartitionType.APPLE_HFS_CONTAINER && pt != PartitionType.APPLE_HFSX) continue;
                firstPreferredPartition = i;
                break;
            }
            Object selectedValue = JOptionPane.showInputDialog(null, "Select which partition to read", "Choose " + detectedType.getLongName() + " partition", 3, null, partitions, partitions[firstPreferredPartition]);
            for (i = 0; i < partitions.length; ++i) {
                if (partitions[i] != selectedValue) continue;
                partNum = i;
                break;
            }
            if (!(selectedValue instanceof Partition)) {
                throw new RuntimeException("Impossible error!");
            }
            Partition selectedPartition = (Partition)selectedValue;
            fsOffset = selectedPartition.getStartOffset();
            fsLength = selectedPartition.getLength();
        }
        byte[] buffer = new byte[65536];
        if (partNum == -1) {
            first64File = new File("fsdump-" + runTimestamp + "_first64.dat");
            last64File = new File("fsdump-" + runTimestamp + "_last64.dat");
        } else {
            first64File = new File("fsdump-" + runTimestamp + "_p" + partNum + "_first64.dat");
            last64File = new File("fsdump-" + runTimestamp + "_p" + partNum + "_last64.dat");
        }
        if (DumpFSInfo.extractDataToFile(fsFile, fsOffset, first64File, 65536)) {
            generatedFiles.add(first64File);
        }
        if ((pos = fsOffset + fsLength - (long)buffer.length) > fsOffset && DumpFSInfo.extractDataToFile(fsFile, pos, last64File, 65536)) {
            generatedFiles.add(last64File);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Dumped FS info to directory:\n    ");
        File firstFile = ((File)generatedFiles.getFirst()).getAbsoluteFile();
        File firstParent = firstFile.getParentFile();
        sb.append(firstParent.getAbsolutePath());
        sb.append("\nThe following files were generated:\n    ");
        Iterator i$ = generatedFiles.iterator();
        while (true) {
            if (!i$.hasNext()) {
                JOptionPane.showMessageDialog(null, sb.toString(), "Result", 1);
                return;
            }
            File f = (File)i$.next();
            sb.append(f.toString() + "\n    ");
        }
    }

    private static boolean extractDataToFile(ReadableRandomAccessStream fsFile, long pos, File outFile, int dataSize) {
        try {
            byte[] buffer = new byte[dataSize];
            fsFile.seek(pos);
            int bytesRead = fsFile.read(buffer);
            FileOutputStream fileOut = new FileOutputStream(outFile);
            fileOut.write(buffer, 0, bytesRead);
            fileOut.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

