/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.testcode.editgpt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.catacombae.hfsexplorer.testcode.editgpt.ContainerPanel;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.storage.io.win32.Win32FileStream;
import org.catacombae.storage.ps.gpt.types.GUIDPartitionTable;
import org.catacombae.storage.ps.gpt.types.MutableGUIDPartitionTable;

public class EditGPT
extends JPanel {
    private GUIDPartitionTable originalGPT = null;
    private MutableGUIDPartitionTable modifiedGPT = null;
    private ContainerPanel containerPanel = new ContainerPanel();

    public EditGPT() {
        this.initComponents();
        this.add((Component)this.containerPanel, "Center");
    }

    public void loadFile(File f) {
        ReadableRandomAccessStream llf = Win32FileStream.isSystemSupported() ? new ReadableWin32FileStream(f.getAbsolutePath()) : new ReadableFileStream(f.getAbsolutePath());
        GUIDPartitionTable gpt = new GUIDPartitionTable(llf, 0);
        this.setFields(gpt);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void setFields(GUIDPartitionTable gpt) {
        this.originalGPT = gpt;
        this.containerPanel.setFields(this.originalGPT.getStructElements());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            // empty catch block
        }
        File gptFile = new File(args[0]);
        JFrame jf = new JFrame("EditGPT");
        EditGPT egpt = new EditGPT();
        jf.add(new JScrollPane(egpt));
        egpt.loadFile(gptFile);
        jf.pack();
        jf.setLocationRelativeTo(null);
        jf.setVisible(true);
        jf.setDefaultCloseOperation(3);
    }
}

