/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.testcode;

import java.awt.Component;
import java.awt.Font;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.catacombae.hfs.UnicodeNormalizationToolkit;
import org.catacombae.util.Util;

public class VisualizeUnicodeNormalization
extends JFrame {
    public VisualizeUnicodeNormalization() {
        super("HFS+ Unicode Decomposition Table");
        JPanel mainPanel = new JPanel();
        JScrollPane mainPanelScroller = new JScrollPane(mainPanel, 20, 31);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanelScroller.getVerticalScrollBar().setUnitIncrement(20);
        UnicodeNormalizationToolkit unt = UnicodeNormalizationToolkit.getDefaultInstance();
        Map<Character, char[]> table = unt.getDecompositionTable();
        StringBuilder sb = new StringBuilder();
        Comparator<Map.Entry<Character, char[]>> cmp = new Comparator<Map.Entry<Character, char[]>>(){

            @Override
            public int compare(Map.Entry<Character, char[]> o1, Map.Entry<Character, char[]> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
        TreeSet<Map.Entry<Character, char[]>> ts = new TreeSet<Map.Entry<Character, char[]>>(cmp);
        for (Map.Entry<Character, char[]> ent : table.entrySet()) {
            ts.add(ent);
        }
        for (Map.Entry<Character, char[]> ent : ts) {
            Character key = ent.getKey();
            char[] value = ent.getValue();
            sb.append(Util.toHexStringBE(key.charValue()));
            sb.append(": \" ");
            sb.append(key.toString());
            sb.append(" \" -> \" ");
            sb.append(value[0]);
            for (int i = 1; i < value.length; ++i) {
                sb.append(" \", \" ");
                sb.append(value[i]);
            }
            sb.append(" \"");
            JLabel cur = new JLabel(sb.toString());
            cur.setFont(new Font("Monospaced", 0, 20));
            mainPanel.add(cur);
            sb.setLength(0);
        }
        this.add((Component)mainPanelScroller, "Center");
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) {
        VisualizeUnicodeNormalization frame = new VisualizeUnicodeNormalization();
        frame.setVisible(true);
    }
}

