/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import org.catacombae.util.Util;

public class JTextAreaOutputStream
extends OutputStream {
    private static final int MAX_LENGTH = 80000;
    private final PrintStream stdErr;
    private final JTextArea textArea;
    private final JScrollPane textAreaScroller;
    private final Object syncObject;
    private final String encoding;
    private final GapContent content;
    private boolean updateRequested = false;
    private PlainDocument document;

    public JTextAreaOutputStream(PrintStream stdErr, JTextArea textArea) {
        this(stdErr, textArea, textArea);
    }

    public JTextAreaOutputStream(PrintStream stdErr, JTextArea textArea, Object syncObject) {
        this(stdErr, textArea, syncObject, null);
    }

    public JTextAreaOutputStream(PrintStream stdErr, JTextArea textArea, Object syncObject, String encoding) {
        this(stdErr, textArea, null, syncObject, encoding);
    }

    public JTextAreaOutputStream(PrintStream stdErr, JTextArea textArea, JScrollPane textAreaScroller, Object syncObject, String encoding) {
        if (stdErr == null) {
            throw new IllegalArgumentException("stdErr == null");
        }
        if (textArea == null) {
            throw new IllegalArgumentException("textArea == null");
        }
        if (syncObject == null) {
            throw new IllegalArgumentException("syncObject == null");
        }
        this.stdErr = stdErr;
        this.textArea = textArea;
        this.textAreaScroller = textAreaScroller;
        this.syncObject = syncObject;
        this.encoding = encoding;
        this.content = new GapContent();
        this.document = new PlainDocument(this.content);
        textArea.setDocument(this.document);
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            try {
                String s = this.encoding == null ? new String(b, off, len) : new String(b, off, len, this.encoding);
                try {
                    int overrun;
                    if (s.length() > 80000) {
                        s = s.substring(s.length() - 80000);
                    }
                    if ((overrun = this.document.getLength() - 2 + s.length() - 80000) > 0) {
                        this.document.remove(0, overrun);
                    }
                    this.document.insertString(this.document.getLength(), s, null);
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException("Exception while updating content", ex);
                }
                if (this.textAreaScroller != null && !this.updateRequested) {
                    this.updateRequested = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = JTextAreaOutputStream.this.syncObject;
                            synchronized (object) {
                                JTextAreaOutputStream.this.updateRequested = false;
                                JScrollBar sb = JTextAreaOutputStream.this.textAreaScroller.getVerticalScrollBar();
                                sb.setValue(sb.getMaximum() - sb.getVisibleAmount());
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                Util.buildStackTrace(e, Integer.MAX_VALUE, sb);
                this.stdErr.println(sb.toString());
            }
        }
    }
}

