/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.types.hfsplus.JournalHeader;
import org.catacombae.hfs.types.hfsplus.JournalInfoBlock;
import org.catacombae.hfsexplorer.gui.JournalInfoBlockPanel;
import org.catacombae.hfsexplorer.gui.StructViewPanel;
import org.catacombae.util.Util;

public class JournalInfoPanel
extends JPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel contentsPanel = new JPanel();
    private JournalInfoBlockPanel infoBlockPanel = new JournalInfoBlockPanel();
    private StructViewPanel journalHeaderPanel = null;
    private JComponent journalContentsPanel = null;
    private JPanel noJournalPanel = new JPanel();
    private JLabel noJournalLabel = new JLabel("No journal present", 0);
    private CardLayout layout = new CardLayout();

    public JournalInfoPanel(Journal journal) {
        this.contentsPanel.setLayout(new BorderLayout());
        this.contentsPanel.add((Component)this.infoBlockPanel, "Center");
        this.tabbedPane.insertTab("Info block", null, this.contentsPanel, "The journal info block, describing the location of the journal.", 0);
        this.noJournalPanel.setLayout(new BorderLayout());
        this.noJournalPanel.add((Component)this.noJournalLabel, "Center");
        this.setLayout(this.layout);
        this.add((Component)this.noJournalPanel, "A");
        this.add((Component)this.tabbedPane, "B");
        this.layout.show(this, "A");
        this._setFields(journal);
    }

    private void _setFields(Journal journal) {
        JournalInfoBlock infoBlock = journal.getJournalInfoBlock();
        if (this.journalContentsPanel != null) {
            this.tabbedPane.remove(2);
        }
        if (this.journalHeaderPanel != null) {
            this.tabbedPane.remove(1);
        }
        this.infoBlockPanel.setFields(infoBlock);
        JournalHeader journalHeader = journal.getJournalHeader();
        if (journalHeader == null) {
            if (infoBlock.getFlagJournalNeedInit()) {
                this.noJournalLabel.setText("Journal not initialized.");
            } else if (infoBlock.getFlagJournalOnOtherDevice()) {
                this.noJournalLabel.setText("Journal is located on other device (0x" + Util.toHexStringBE(infoBlock.getDeviceSignature()) + ").");
            } else if (!infoBlock.getFlagJournalInFS()) {
                this.noJournalLabel.setText("Journal is not located inside the filesystem (but where?).");
            } else {
                this.noJournalLabel.setText("Unknown error while loading the journal header.\n");
            }
            this.layout.show(this, "A");
            return;
        }
        this.journalHeaderPanel = new StructViewPanel("Journal header", (journalHeader.isLittleEndian() ? "Little" : "Big") + "-endian fields", journalHeader.getStructElements());
        this.tabbedPane.insertTab("Header", null, this.journalHeaderPanel, "The journal header, describing the data inside the journal.", 1);
        try {
            Journal.Transaction[] transactions = journal.getPendingTransactions();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream((OutputStream)baos, false, "UTF-8");
            for (int i = 0; i < transactions.length; ++i) {
                Journal.Transaction t = transactions[i];
                ps.println("Transaction " + i + ":");
                for (int j = 0; j < t.blockLists.length; ++j) {
                    ps.println(" blockLists[" + j + "]:");
                    t.blockLists[j].print(ps, "  ");
                }
            }
            ps.flush();
            ps.close();
            JTextArea transactionsTextArea = new JTextArea(new String(baos.toByteArray(), "UTF-8"));
            baos.close();
            transactionsTextArea.setEditable(false);
            this.journalContentsPanel = new JScrollPane(transactionsTextArea);
            this.tabbedPane.insertTab("Transactions", null, this.journalContentsPanel, "The journal's pending transactions.", 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.layout.show(this, "B");
    }

    public void setFields(Journal journal) {
        this._setFields(journal);
    }
}

