/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.catacombae.csjc.structelements.Array;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.FlagField;
import org.catacombae.csjc.structelements.StringRepresentableField;
import org.catacombae.csjc.structelements.StructElement;
import org.catacombae.hfsexplorer.gui.FlagViewPanel;
import org.catacombae.hfsexplorer.gui.TextViewPanel;
import org.jdesktop.layout.GroupLayout;

public class InternalStructViewPanel
extends JPanel {
    private JPanel fieldsPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel structNameLabel;

    public InternalStructViewPanel(String label, Dictionary dict) {
        this(label, null, dict, false);
    }

    public InternalStructViewPanel(String label, Dictionary dict, boolean noRootEntry) {
        this(label, null, dict, noRootEntry);
    }

    public InternalStructViewPanel(String label, String tooltip, Dictionary dict) {
        this(label, tooltip, false);
    }

    public InternalStructViewPanel(String label, String tooltip, Dictionary dict, boolean noRootEntry) {
        this(label, tooltip, noRootEntry);
        String[] keys = dict.getKeys();
        JPanel[] subPanels = new JPanel[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String curKey = keys[i];
            StructElement curElement = dict.getElement(curKey);
            String curDescription = dict.getDescription(curKey);
            String subLabel = curDescription != null ? curDescription : curKey;
            subPanels[i] = InternalStructViewPanel.createPanel(subLabel, curElement);
            if (i == keys.length - 1) continue;
            subPanels[i].setBorder(new EmptyBorder(0, 0, 5, 0));
        }
        this.fieldsPanel.removeAll();
        for (JPanel subPanel : subPanels) {
            this.fieldsPanel.add(subPanel);
        }
    }

    public InternalStructViewPanel(String label, Array array) {
        this(label, null, array);
    }

    public InternalStructViewPanel(String label, String tooltip, Array array) {
        this(label, tooltip);
        StructElement[] elems = array.getElements();
        JPanel[] subPanels = new JPanel[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            StructElement curElement = elems[i];
            subPanels[i] = InternalStructViewPanel.createPanel("[" + i + "]", curElement);
            subPanels[i].setBorder(new EmptyBorder(0, 0, 5, 0));
        }
        this.fieldsPanel.removeAll();
        for (JPanel subPanel : subPanels) {
            this.fieldsPanel.add(subPanel);
        }
    }

    private InternalStructViewPanel(String label, String tooltip) {
        this(label, tooltip, false);
    }

    private InternalStructViewPanel(String label, String tooltip, boolean noRootEntry) {
        if (!noRootEntry) {
            this.initComponents();
            this.structNameLabel.setText(label);
            if (tooltip != null) {
                this.structNameLabel.setToolTipText(tooltip);
            }
        } else {
            this.setLayout(new BorderLayout());
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new BoxLayout(this.fieldsPanel, 3));
            this.add((Component)this.fieldsPanel, "Center");
        }
    }

    private static JPanel createPanel(String label, StructElement elem) {
        if (elem instanceof StringRepresentableField) {
            StringRepresentableField f = (StringRepresentableField)elem;
            return new TextViewPanel(label + ":", f);
        }
        if (elem instanceof FlagField) {
            FlagField f = (FlagField)elem;
            return new FlagViewPanel(label, f);
        }
        if (elem instanceof Array) {
            Array a = (Array)elem;
            return new InternalStructViewPanel(label + ":", a);
        }
        if (elem instanceof Dictionary) {
            Dictionary d = (Dictionary)elem;
            return new InternalStructViewPanel(label + ":", d);
        }
        throw new RuntimeException("Unsupported StructElement subtype: " + elem.getClass());
    }

    private void initComponents() {
        this.structNameLabel = new JLabel();
        this.fieldsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.structNameLabel.setText("structName");
        this.fieldsPanel.setLayout(new BoxLayout(this.fieldsPanel, 3));
        this.jLabel1.setText("jLabel1");
        this.fieldsPanel.add(this.jLabel1);
        this.jLabel2.setText("jLabel2");
        this.fieldsPanel.add(this.jLabel2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.structNameLabel).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)this.fieldsPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.structNameLabel).addPreferredGap(0).add((Component)this.fieldsPanel, -1, -1, Short.MAX_VALUE)));
    }
}

