/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.catacombae.hfs.ExtentsOverflowFile;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentLeafRecord;
import org.catacombae.hfsexplorer.FileSystemBrowser;
import org.catacombae.hfsexplorer.gui.BTreeInfoPanel;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentsInfoPanel
extends BTreeInfoPanel<CommonHFSExtentLeafRecord, ExtentsOverflowFile> {
    public ExtentsInfoPanel(HFSVolume fsView) {
        super(fsView.getExtentsOverflowFile());
    }

    @Override
    public String getRootNodeName() {
        return "Extents overflow root";
    }

    @Override
    public String getHeaderText() {
        return "View of the extent overflow file's B*-tree:";
    }

    @Override
    public void createCustomPanels(List<Util.Pair<JPanel, String>> customPanelsList) {
    }

    @Override
    public void expandNode(DefaultMutableTreeNode dmtn, CommonBTNode node, ExtentsOverflowFile extentsOverflowFile) {
        if (node instanceof CommonHFSExtentIndexNode) {
            List recs = ((CommonHFSExtentIndexNode)node).getBTRecords();
            for (CommonBTIndexRecord rec : recs) {
                long nodeNumber = rec.getIndex();
                CommonBTNode curNode = extentsOverflowFile.getNode(nodeNumber);
                CommonHFSExtentKey key = (CommonHFSExtentKey)rec.getKey();
                dmtn.add(new FileSystemBrowser.NoLeafMutableTreeNode(new BTreeInfoPanel.BTNodeStorage(nodeNumber, curNode, key.getFileID().toLong() + ":" + key.getForkType() + ":" + key.getStartBlock())));
            }
        } else if (node instanceof CommonHFSExtentLeafNode) {
            CommonHFSExtentLeafNode leafNode = (CommonHFSExtentLeafNode)node;
            CommonHFSExtentLeafRecord[] recs = leafNode.getLeafRecords();
            int[] recordOffsets = leafNode.getRecordOffsets();
            for (int i = 0; i < recs.length; ++i) {
                CommonHFSExtentLeafRecord rec = recs[i];
                CommonHFSExtentKey key = rec.getKey();
                dmtn.add(new DefaultMutableTreeNode(new BTreeInfoPanel.BTLeafStorage(i, recordOffsets[i], recordOffsets[i + 1] - recordOffsets[i], rec, key.getFileID().toLong() + ":" + key.getForkType() + ":" + key.getStartBlock())));
            }
        } else {
            throw new RuntimeException("Invalid node type in tree: " + node);
        }
    }

    @Override
    public boolean handleLeafRecord(BTreeInfoPanel.BTLeafStorage leafStorage) {
        return false;
    }
}

