/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.catacombae.hfs.CatalogFile;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.types.hfscommon.CommonBTIndexRecord;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFile;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogFolder;
import org.catacombae.hfsexplorer.FileSystemBrowser;
import org.catacombae.hfsexplorer.gui.BTreeInfoPanel;
import org.catacombae.hfsexplorer.gui.FileInfoPanel;
import org.catacombae.hfsexplorer.gui.FolderInfoPanel;
import org.catacombae.hfsexplorer.gui.LeafInfoPanel;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogInfoPanel
extends BTreeInfoPanel<CommonHFSCatalogLeafRecord, CatalogFile> {
    private final String FILE_NAME = "file";
    private final String FOLDER_NAME = "folder";
    private LeafInfoPanel fileInfoPanelHeader;
    private FileInfoPanel fileInfoPanel;
    private LeafInfoPanel folderInfoPanelHeader;
    private FolderInfoPanel folderInfoPanel;

    public CatalogInfoPanel(HFSVolume vol) {
        super(vol.getCatalogFile());
    }

    @Override
    public String getRootNodeName() {
        return "Catalog root";
    }

    @Override
    public String getHeaderText() {
        return "View of the catalog file's B*-tree:";
    }

    @Override
    public void createCustomPanels(List<Util.Pair<JPanel, String>> panelsList) {
        this.fileInfoPanelHeader = new LeafInfoPanel();
        this.fileInfoPanel = new FileInfoPanel();
        JPanel fileInfoPanelContainer = new JPanel(new BorderLayout());
        fileInfoPanelContainer.add((Component)this.fileInfoPanelHeader, "North");
        fileInfoPanelContainer.add((Component)this.fileInfoPanel, "Center");
        panelsList.add(new Util.Pair<JPanel, String>(fileInfoPanelContainer, "file"));
        this.folderInfoPanelHeader = new LeafInfoPanel();
        this.folderInfoPanel = new FolderInfoPanel();
        JPanel folderInfoPanelContainer = new JPanel(new BorderLayout());
        folderInfoPanelContainer.add((Component)this.folderInfoPanelHeader, "North");
        folderInfoPanelContainer.add((Component)this.folderInfoPanel, "Center");
        panelsList.add(new Util.Pair<JPanel, String>(folderInfoPanelContainer, "folder"));
    }

    @Override
    public void expandNode(DefaultMutableTreeNode dmtn, CommonBTNode node, CatalogFile catalogFile) {
        if (node instanceof CommonHFSCatalogIndexNode) {
            List recs = ((CommonHFSCatalogIndexNode)node).getBTRecords();
            for (CommonBTIndexRecord rec : recs) {
                long nodeNumber = rec.getIndex();
                CommonBTNode curNode = catalogFile.getNode(nodeNumber);
                CommonHFSCatalogKey key = (CommonHFSCatalogKey)rec.getKey();
                dmtn.add(new FileSystemBrowser.NoLeafMutableTreeNode(new BTreeInfoPanel.BTNodeStorage(nodeNumber, curNode, key.getParentID().toLong() + ":" + catalogFile.getVolume().decodeString(key.getNodeName()))));
            }
        } else if (node instanceof CommonHFSCatalogLeafNode) {
            CommonHFSCatalogLeafNode leafNode = (CommonHFSCatalogLeafNode)node;
            CommonHFSCatalogLeafRecord[] recs = leafNode.getLeafRecords();
            int[] recordOffsets = leafNode.getRecordOffsets();
            for (int i = 0; i < recs.length; ++i) {
                CommonHFSCatalogLeafRecord rec = recs[i];
                dmtn.add(new DefaultMutableTreeNode(new BTreeInfoPanel.BTLeafStorage(i, recordOffsets[i], recordOffsets[i + 1] - recordOffsets[i], rec, rec.getKey().getParentID().toLong() + ":" + catalogFile.getVolume().decodeString(rec.getKey().getNodeName()))));
            }
        } else {
            throw new RuntimeException("Invalid node type in tree.");
        }
    }

    @Override
    public boolean handleLeafRecord(BTreeInfoPanel.BTLeafStorage leafStorage) {
        CommonHFSCatalogLeafRecord rec = (CommonHFSCatalogLeafRecord)leafStorage.getRecord();
        if (rec instanceof CommonHFSCatalogFileRecord.HFSPlusImplementation) {
            CommonHFSCatalogFile fil = ((CommonHFSCatalogFileRecord)rec).getData();
            if (fil instanceof CommonHFSCatalogFile.HFSPlusImplementation) {
                HFSPlusCatalogFile underlying = ((CommonHFSCatalogFile.HFSPlusImplementation)fil).getUnderlying();
                this.fileInfoPanelHeader.setRecordNumber(leafStorage.getRecordNumber());
                this.fileInfoPanelHeader.setRecordOffset(leafStorage.getRecordOffset());
                this.fileInfoPanelHeader.setRecordSize(leafStorage.getRecordSize());
                this.fileInfoPanel.setFields(underlying);
                this.clLeaf.show(this.leafPanel, "file");
            } else {
                System.err.println("BTreeInfoPanel: Could not show file record type " + fil.getClass());
                this.clLeaf.show(this.leafPanel, "other");
            }
        } else if (rec instanceof CommonHFSCatalogFolderRecord.HFSPlusImplementation) {
            CommonHFSCatalogFolder fld = ((CommonHFSCatalogFolderRecord)rec).getData();
            if (fld instanceof CommonHFSCatalogFolder.HFSPlusImplementation) {
                HFSPlusCatalogFolder underlying = ((CommonHFSCatalogFolder.HFSPlusImplementation)fld).getUnderlying();
                this.folderInfoPanelHeader.setRecordNumber(leafStorage.getRecordNumber());
                this.folderInfoPanelHeader.setRecordOffset(leafStorage.getRecordOffset());
                this.folderInfoPanelHeader.setRecordSize(leafStorage.getRecordSize());
                this.folderInfoPanel.setFields(underlying);
                this.clLeaf.show(this.leafPanel, "folder");
            } else {
                System.err.println("BTreeInfoPanel: Could not show folder record type " + fld.getClass());
                this.clLeaf.show(this.leafPanel, "other");
            }
        } else {
            return false;
        }
        return true;
    }
}

