/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.BTreeFile;
import org.catacombae.hfs.types.hfscommon.CommonBTNode;
import org.catacombae.hfs.types.hfscommon.CommonBTNodeDescriptor;
import org.catacombae.hfsexplorer.FileSystemBrowser;
import org.catacombae.hfsexplorer.gui.LeafInfoPanel;
import org.catacombae.hfsexplorer.gui.StructViewPanel;
import org.catacombae.hfsexplorer.io.JTextAreaOutputStream;
import org.catacombae.util.Util;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreeInfoPanel<R, B extends BTreeFile>
extends JPanel {
    private static final int UNIT_INCREMENT = 10;
    protected final String INDEX_NAME = "index";
    protected final String LEAF_NAME = "leaf";
    protected final String PRINT_FIELDS_AREA_NAME = "printfieldsarea";
    protected final String OTHER_NAME = "other";
    protected final String STRUCT_VIEW_PANEL_NAME = "structview";
    protected final JPanel leafPanel;
    protected final CardLayout clLeaf;
    public JTree bTreeFileTree;
    private JScrollPane bTreeFileTreeScroller;
    private JLabel descriptionLabel;
    private JPanel infoPanel;
    private JPanel jPanel1;
    private JSplitPane jSplitPane1;

    public BTreeInfoPanel(B bTree) {
        this.initComponents();
        this.descriptionLabel.setText(this.getHeaderText());
        CommonBTNode iNode = ((BTreeFile)bTree).getRootNode();
        if (iNode == null) {
            DefaultTreeModel model = new DefaultTreeModel(new FileSystemBrowser.NoLeafMutableTreeNode("<empty>"));
            this.bTreeFileTree.setModel(model);
            this.leafPanel = null;
            this.clLeaf = null;
            return;
        }
        FileSystemBrowser.NoLeafMutableTreeNode rootNode = new FileSystemBrowser.NoLeafMutableTreeNode(new BTNodeStorage(((BTreeFile)bTree).getRootNodeNumber(), iNode, this.getRootNodeName()));
        this.expandNode(rootNode, iNode, bTree);
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        this.bTreeFileTree.setModel(model);
        this.bTreeFileTree.addTreeWillExpandListener(new TreeWillExpandListener((BTreeFile)bTree){
            final /* synthetic */ BTreeFile val$bTree;
            {
                this.val$bTree = bTreeFile;
            }

            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                Object obj2;
                DefaultMutableTreeNode dmtn;
                TreePath tp = e.getPath();
                Object obj = tp.getLastPathComponent();
                if (obj instanceof DefaultMutableTreeNode) {
                    dmtn = (DefaultMutableTreeNode)obj;
                    obj2 = dmtn.getUserObject();
                    if (!(obj2 instanceof BTNodeStorage)) {
                        throw new RuntimeException("Wrong user object type in expandable node!");
                    }
                } else {
                    throw new RuntimeException("Wrong node type in tree!");
                }
                CommonBTNode node = ((BTNodeStorage)obj2).getNode();
                BTreeInfoPanel.this.expandNode(dmtn, node, this.val$bTree);
            }

            public void treeWillCollapse(TreeExpansionEvent e) {
            }
        });
        final CardLayout clRoot = new CardLayout();
        this.leafPanel = new JPanel();
        this.clLeaf = new CardLayout();
        this.leafPanel.setLayout(this.clLeaf);
        this.leafPanel.add((Component)new JLabel("INTERNAL ERROR!", 0), "other");
        final JScrollPane structViewPanelScroller = new JScrollPane();
        structViewPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        structViewPanelScroller.getHorizontalScrollBar().setUnitIncrement(10);
        this.leafPanel.add((Component)structViewPanelScroller, "structview");
        LinkedList<Util.Pair<JPanel, String>> customPanelsList = new LinkedList<Util.Pair<JPanel, String>>();
        this.createCustomPanels(customPanelsList);
        for (Util.Pair pair : customPanelsList) {
            JScrollPane customPanelScroller = new JScrollPane((Component)pair.getA());
            customPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
            customPanelScroller.getHorizontalScrollBar().setUnitIncrement(10);
            this.leafPanel.add((Component)customPanelScroller, pair.getB());
        }
        final LeafInfoPanel printFieldsTextAreaHeader = new LeafInfoPanel();
        final JTextArea jTextArea = new JTextArea(0, 0);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(false);
        jTextArea.setOpaque(false);
        JPanel printFieldsTextAreaContainer = new JPanel(new BorderLayout());
        printFieldsTextAreaContainer.add((Component)printFieldsTextAreaHeader, "North");
        printFieldsTextAreaContainer.add((Component)jTextArea, "Center");
        JScrollPane printFieldsTextAreaScroller = new JScrollPane(printFieldsTextAreaContainer);
        printFieldsTextAreaScroller.getVerticalScrollBar().setUnitIncrement(10);
        printFieldsTextAreaScroller.getHorizontalScrollBar().setUnitIncrement(10);
        this.leafPanel.add((Component)printFieldsTextAreaScroller, "printfieldsarea");
        this.infoPanel.setLayout(clRoot);
        final JLabel indexNodeLabel = new JLabel("No selection.", 0);
        this.infoPanel.add((Component)indexNodeLabel, "index");
        this.infoPanel.add((Component)this.leafPanel, "leaf");
        this.bTreeFileTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent te) {
                Object o = te.getPath().getLastPathComponent();
                if (o instanceof DefaultMutableTreeNode) {
                    Object o2 = ((DefaultMutableTreeNode)o).getUserObject();
                    if (o2 instanceof BTNodeStorage) {
                        BTNodeStorage nodeStorage = (BTNodeStorage)o2;
                        CommonBTNode btn = nodeStorage.getNode();
                        CommonBTNodeDescriptor btnd = btn.getNodeDescriptor();
                        switch (btnd.getNodeType()) {
                            case INDEX: {
                                indexNodeLabel.setText("Index node " + nodeStorage.getNodeNumber() + " " + "with " + btnd.getNumberOfRecords() + " " + "records.");
                                break;
                            }
                            case LEAF: {
                                indexNodeLabel.setText("Leaf node " + nodeStorage.getNodeNumber() + " with " + btnd.getNumberOfRecords() + " " + "records.");
                                break;
                            }
                            default: {
                                indexNodeLabel.setText("Unknown error!");
                            }
                        }
                        clRoot.show(BTreeInfoPanel.this.infoPanel, "index");
                    } else {
                        BTLeafStorage leafStorage = (BTLeafStorage)o2;
                        Object rec = leafStorage.getRecord();
                        if (!BTreeInfoPanel.this.handleLeafRecord(leafStorage)) {
                            if (rec instanceof StructElements) {
                                Dictionary dict = ((StructElements)rec).getStructElements();
                                String label = dict.getTypeDescription();
                                if (label == null) {
                                    label = dict.getTypeName();
                                }
                                LeafInfoPanel leafInfoPanel = new LeafInfoPanel();
                                leafInfoPanel.setRecordNumber(leafStorage.getRecordNumber());
                                leafInfoPanel.setRecordOffset(leafStorage.getRecordOffset());
                                leafInfoPanel.setRecordSize(leafStorage.getRecordSize());
                                JPanel containerPanel = new JPanel(new BorderLayout());
                                containerPanel.add((Component)leafInfoPanel, "North");
                                containerPanel.add((Component)new StructViewPanel(label + ":", dict), "Center");
                                structViewPanelScroller.setViewportView(containerPanel);
                                BTreeInfoPanel.this.clLeaf.show(BTreeInfoPanel.this.leafPanel, "structview");
                            } else if (rec instanceof PrintableStruct) {
                                PrintStream ps = new PrintStream(new JTextAreaOutputStream(System.err, jTextArea));
                                printFieldsTextAreaHeader.setRecordNumber(leafStorage.getRecordNumber());
                                printFieldsTextAreaHeader.setRecordOffset(leafStorage.getRecordOffset());
                                printFieldsTextAreaHeader.setRecordSize(leafStorage.getRecordSize());
                                jTextArea.setText("");
                                ((PrintableStruct)rec).print(ps, "");
                                ps.close();
                                jTextArea.setCaretPosition(0);
                                BTreeInfoPanel.this.clLeaf.show(BTreeInfoPanel.this.leafPanel, "printfieldsarea");
                            } else {
                                System.err.println("BTreeInfoPanel: Could not show record type " + rec.getClass());
                                BTreeInfoPanel.this.clLeaf.show(BTreeInfoPanel.this.leafPanel, "other");
                            }
                        }
                        clRoot.show(BTreeInfoPanel.this.infoPanel, "leaf");
                    }
                } else {
                    System.err.println("WARNING: Unknown node type in bTreeFileTree - " + o.getClass().toString());
                }
            }
        });
    }

    public abstract String getRootNodeName();

    public abstract String getHeaderText();

    public abstract void createCustomPanels(List<Util.Pair<JPanel, String>> var1);

    public abstract void expandNode(DefaultMutableTreeNode var1, CommonBTNode var2, B var3);

    public abstract boolean handleLeafRecord(BTLeafStorage var1);

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.bTreeFileTreeScroller = new JScrollPane();
        this.bTreeFileTree = new JTree();
        this.infoPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.jSplitPane1.setDividerLocation(330);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.bTreeFileTreeScroller.setViewportView(this.bTreeFileTree);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.bTreeFileTreeScroller, -1, 359, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (Component)this.bTreeFileTreeScroller, -1, 329, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.infoPanel.setPreferredSize(new Dimension(100, 140));
        GroupLayout infoPanelLayout = new GroupLayout((Container)this.infoPanel);
        this.infoPanel.setLayout((LayoutManager)infoPanelLayout);
        infoPanelLayout.setHorizontalGroup((GroupLayout.Group)infoPanelLayout.createParallelGroup(1).add(0, 359, Short.MAX_VALUE));
        infoPanelLayout.setVerticalGroup((GroupLayout.Group)infoPanelLayout.createParallelGroup(1).add(0, 101, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.infoPanel);
        this.descriptionLabel.setText("View of the B*-tree:");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 361, Short.MAX_VALUE).add((Component)this.descriptionLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.descriptionLabel).addPreferredGap(0).add((Component)this.jSplitPane1, -1, 437, Short.MAX_VALUE).addContainerGap()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BTLeafStorage {
        private final int recordNumber;
        private final int recordOffset;
        private final int recordSize;
        private R rec;
        private String text;

        public BTLeafStorage(int recordNumber, int recordOffset, int recordSize, R rec, String text) {
            this.recordNumber = recordNumber;
            this.recordOffset = recordOffset;
            this.recordSize = recordSize;
            this.rec = rec;
            this.text = text;
        }

        public int getRecordNumber() {
            return this.recordNumber;
        }

        public int getRecordOffset() {
            return this.recordOffset;
        }

        public int getRecordSize() {
            return this.recordSize;
        }

        public R getRecord() {
            return this.rec;
        }

        public String toString() {
            return this.text;
        }
    }

    protected static class BTNodeStorage {
        private long nodeNumber;
        private CommonBTNode node;
        private String text;

        public BTNodeStorage(long nodeNumber, CommonBTNode node, String text) {
            this.nodeNumber = nodeNumber;
            this.node = node;
            this.text = text;
        }

        public long getNodeNumber() {
            return this.nodeNumber;
        }

        public CommonBTNode getNode() {
            return this.node;
        }

        public String toString() {
            return this.text;
        }
    }
}

