/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.catacombae.csjc.structelements.ArrayBuilder;
import org.catacombae.hfs.AllocationFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.gui.StructViewPanel;
import org.catacombae.util.ObjectContainer;
import org.jdesktop.layout.GroupLayout;

public class AllocationFileInfoPanel
extends JPanel {
    private final AllocationFile afView;
    private final ObjectContainer<Boolean> stopCountBlocksProcess = new ObjectContainer<Boolean>(false);
    private JButton allocateButton;
    private JTextField allocateSizeField;
    private JLabel allocateSizeLabel;
    private JLabel allocateUnitLabel;
    private JTextField allocatedBlocksField;
    private JLabel allocatedBlocksLabel;
    private JLabel allocationHeader;
    private JTextField freeBlocksField;
    private JLabel freeBlocksLabel;
    private JLabel resultLabel;
    private JPanel resultPanel;
    private JScrollPane resultScroller;

    public AllocationFileInfoPanel(JFrame window, final AllocationFile afView) {
        this.afView = afView;
        this.initComponents();
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((AllocationFileInfoPanel)AllocationFileInfoPanel.this).stopCountBlocksProcess.o = true;
            }
        });
        Thread t = new Thread(new Runnable(){

            public void run() {
                final ObjectContainer<Long> freeBlocks = new ObjectContainer<Long>(-1L);
                final ObjectContainer<Long> usedBlocks = new ObjectContainer<Long>(-1L);
                afView.countBlocks(freeBlocks, usedBlocks, AllocationFileInfoPanel.this.stopCountBlocksProcess);
                if (!((Boolean)((AllocationFileInfoPanel)AllocationFileInfoPanel.this).stopCountBlocksProcess.o).booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AllocationFileInfoPanel.this.allocatedBlocksField.setText(((Long)usedBlocks.o).toString());
                            AllocationFileInfoPanel.this.freeBlocksField.setText(((Long)freeBlocks.o).toString());
                        }
                    });
                } else {
                    System.err.println("AllocationFileInfoPanel thread aborted.");
                }
            }
        });
        t.start();
        this.allocateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AllocationFileInfoPanel.this.allocateButton.setEnabled(false);
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        block8: {
                            try {
                                long l = Long.parseLong(AllocationFileInfoPanel.this.allocateSizeField.getText());
                                CommonHFSExtentDescriptor[] descs = afView.findFreeSpace(l);
                                if (descs != null) {
                                    final ArrayBuilder ab = new ArrayBuilder("CommonHFSExtentDescriptor[" + descs.length + "]");
                                    for (CommonHFSExtentDescriptor desc : descs) {
                                        System.err.println("Found descriptor: ");
                                        desc.print(System.err, "  ");
                                        ab.add(desc.getStructElements());
                                    }
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            AllocationFileInfoPanel.this.resultScroller.setViewportView(new StructViewPanel("Possible allocations", ab.getResult()));
                                        }
                                    });
                                    break block8;
                                }
                                JOptionPane.showMessageDialog(AllocationFileInfoPanel.this, "Not enough space on volume!", "Info", 1);
                            }
                            catch (NumberFormatException ee) {
                                JOptionPane.showMessageDialog(AllocationFileInfoPanel.this, "Invalid long value.", "Error", 0);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        AllocationFileInfoPanel.this.allocateButton.setEnabled(true);
                                    }
                                });
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                GUIUtil.displayExceptionDialog(t, 10, AllocationFileInfoPanel.this, "Exception while trying to calculate available free extents:", "Exception", 0);
                                {
                                    catch (Throwable throwable) {
                                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        throw throwable;
                                    }
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                t.start();
            }
        });
    }

    private void initComponents() {
        this.allocatedBlocksLabel = new JLabel();
        this.allocatedBlocksField = new JTextField();
        this.freeBlocksLabel = new JLabel();
        this.freeBlocksField = new JTextField();
        this.allocationHeader = new JLabel();
        this.allocateSizeField = new JTextField();
        this.allocateSizeLabel = new JLabel();
        this.allocateButton = new JButton();
        this.allocateUnitLabel = new JLabel();
        this.resultScroller = new JScrollPane();
        this.resultPanel = new JPanel();
        this.resultLabel = new JLabel();
        this.allocatedBlocksLabel.setText("Number of allocated blocks:");
        this.allocatedBlocksField.setEditable(false);
        this.allocatedBlocksField.setText("calculating...");
        this.allocatedBlocksField.setBorder(null);
        this.allocatedBlocksField.setOpaque(false);
        this.freeBlocksLabel.setText("Number of free blocks:");
        this.freeBlocksField.setEditable(false);
        this.freeBlocksField.setText("calculating...");
        this.freeBlocksField.setBorder(null);
        this.freeBlocksField.setOpaque(false);
        this.allocationHeader.setText("Attempt allocation of a region");
        this.allocateSizeField.setHorizontalAlignment(11);
        this.allocateSizeLabel.setText("Size:");
        this.allocateButton.setText("Allocate");
        this.allocateUnitLabel.setText("bytes");
        GroupLayout resultPanelLayout = new GroupLayout((Container)this.resultPanel);
        this.resultPanel.setLayout((LayoutManager)resultPanelLayout);
        resultPanelLayout.setHorizontalGroup((GroupLayout.Group)resultPanelLayout.createParallelGroup(1).add(0, 340, Short.MAX_VALUE));
        resultPanelLayout.setVerticalGroup((GroupLayout.Group)resultPanelLayout.createParallelGroup(1).add(0, 194, Short.MAX_VALUE));
        this.resultScroller.setViewportView(this.resultPanel);
        this.resultLabel.setText("Result");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.resultScroller, -1, 344, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.allocationHeader).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allocateSizeLabel).addPreferredGap(0).add((Component)this.allocateSizeField, -1, 173, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.allocateUnitLabel))).addPreferredGap(0).add((Component)this.allocateButton)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.allocatedBlocksLabel).addPreferredGap(0).add((Component)this.allocatedBlocksField, -1, 156, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.freeBlocksLabel).addPreferredGap(0).add((Component)this.freeBlocksField, -1, 189, Short.MAX_VALUE)).add(1, (Component)this.resultLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allocatedBlocksLabel).add((Component)this.allocatedBlocksField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.freeBlocksLabel).add((Component)this.freeBlocksField, -2, -1, -2)).add(18, 18, 18).add((Component)this.allocationHeader).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.allocateSizeLabel).add((Component)this.allocateSizeField, -2, -1, -2).add((Component)this.allocateButton).add((Component)this.allocateUnitLabel)).addPreferredGap(0).add((Component)this.resultLabel).addPreferredGap(0).add((Component)this.resultScroller, -1, 198, Short.MAX_VALUE).addContainerGap()));
    }
}

