/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import org.catacombae.hfsexplorer.fs.AppleSingleBuilder;
import org.catacombae.hfsexplorer.types.applesingle.AppleSingleHeader;
import org.catacombae.hfsexplorer.types.applesingle.EntryDescriptor;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessSubstream;
import org.catacombae.io.SynchronizedReadableRandomAccessStream;
import org.catacombae.util.Util;

public class AppleSingleHandler {
    private final SynchronizedReadableRandomAccessStream stream;

    public AppleSingleHandler(ReadableRandomAccessStream stream) {
        this(new SynchronizedReadableRandomAccessStream(stream));
    }

    public AppleSingleHandler(SynchronizedReadableRandomAccessStream stream) {
        this.stream = stream;
    }

    public AppleSingleHeader getHeader() {
        byte[] headerData = new byte[AppleSingleHeader.length()];
        this.stream.readFullyFrom(0L, headerData);
        return new AppleSingleHeader(headerData, 0);
    }

    public EntryDescriptor[] getEntryDescriptors() {
        AppleSingleHeader header = this.getHeader();
        long pos = AppleSingleHeader.length();
        EntryDescriptor[] result = new EntryDescriptor[Util.unsign(header.getNumEntries())];
        byte[] descriptorData = new byte[EntryDescriptor.length()];
        for (int i = 0; i < result.length; ++i) {
            this.stream.readFullyFrom(pos, descriptorData);
            pos += (long)EntryDescriptor.length();
            result[i] = new EntryDescriptor(descriptorData, 0);
        }
        return result;
    }

    public ReadableRandomAccessStream getEntryStream(EntryDescriptor descriptor) {
        long pos = Util.unsign(descriptor.getEntryOffset());
        long len = Util.unsign(descriptor.getEntryLength());
        return new ReadableConcatenatedStream(new ReadableRandomAccessSubstream(this.stream), pos, len);
    }

    public static AppleSingleBuilder.FileType detectFileFormat(ReadableRandomAccessStream stream, long offset) {
        byte[] magicBytes = new byte[4];
        stream.seek(offset);
        stream.readFully(magicBytes);
        int magic = Util.readIntBE(magicBytes);
        for (AppleSingleBuilder.FileType f : AppleSingleBuilder.FileType.values()) {
            if (f.getMagic() != magic) continue;
            return f;
        }
        return null;
    }

    public EntryDescriptor getResourceEntryDescriptor() {
        for (EntryDescriptor descriptor : this.getEntryDescriptors()) {
            if (descriptor.getEntryId() != AppleSingleBuilder.EntryType.RESOURCE_FORK.getTypeNumber()) continue;
            return descriptor;
        }
        return null;
    }
}

