/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.catacombae.hfs.AttributesFile;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.Journal;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.gui.AttributesInfoPanel;
import org.catacombae.hfsexplorer.gui.CatalogInfoPanel;
import org.catacombae.hfsexplorer.gui.ExtentsInfoPanel;
import org.catacombae.hfsexplorer.gui.JournalInfoPanel;
import org.catacombae.hfsexplorer.gui.StructViewPanel;

public class VolumeInfoWindow
extends JFrame {
    public VolumeInfoWindow(HFSVolume fsView) {
        JTabbedPane tabs;
        block18: {
            JScrollPane headerRecordPanelScroller;
            StructViewPanel headerRecordPanel;
            super("File system info");
            tabs = new JTabbedPane();
            try {
                CommonHFSVolumeHeader volHeader = fsView.getVolumeHeader();
                StructViewPanel volumeInfoPanel = new StructViewPanel("Volume header", volHeader.getStructElements(), true);
                JScrollPane volumeInfoPanelScroller = new JScrollPane(volumeInfoPanel, 20, 31);
                tabs.addTab("Volume header", volumeInfoPanelScroller);
                volumeInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                JTabbedPane catalogTabs = new JTabbedPane();
                try {
                    headerRecordPanel = new StructViewPanel("B-tree header record", fsView.getCatalogFile().getCatalogHeaderNode().getHeaderRecord().getStructElements());
                    headerRecordPanelScroller = new JScrollPane(headerRecordPanel, 20, 31);
                    headerRecordPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
                    catalogTabs.addTab("Header record", headerRecordPanelScroller);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CatalogInfoPanel catalogInfoPanel = new CatalogInfoPanel(fsView);
                JScrollPane catalogInfoPanelScroller = new JScrollPane(catalogInfoPanel, 20, 31);
                catalogInfoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
                catalogTabs.addTab("Tree", catalogInfoPanelScroller);
                tabs.addTab("Catalog file", catalogTabs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                JTabbedPane extentsTabs = new JTabbedPane();
                try {
                    headerRecordPanel = new StructViewPanel("B-tree header record", fsView.getExtentsOverflowFile().getHeaderNode().getHeaderRecord().getStructElements());
                    headerRecordPanelScroller = new JScrollPane(headerRecordPanel, 20, 31);
                    headerRecordPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
                    extentsTabs.addTab("Header record", headerRecordPanelScroller);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ExtentsInfoPanel extentsInfoPanel = new ExtentsInfoPanel(fsView);
                JScrollPane scroller = new JScrollPane(extentsInfoPanel, 20, 31);
                scroller.getVerticalScrollBar().setUnitIncrement(10);
                extentsTabs.addTab("Tree", scroller);
                tabs.addTab("Extents overflow file", extentsTabs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                AttributesFile attributesFile = fsView.getAttributesFile();
                if (attributesFile == null) break block18;
                JTabbedPane attributesTabs = new JTabbedPane();
                try {
                    StructViewPanel headerRecordPanel2 = new StructViewPanel("B-tree header record", attributesFile.getHeaderNode().getHeaderRecord().getStructElements());
                    JScrollPane headerRecordPanelScroller2 = new JScrollPane(headerRecordPanel2, 20, 31);
                    headerRecordPanelScroller2.getVerticalScrollBar().setUnitIncrement(10);
                    attributesTabs.addTab("Header record", headerRecordPanelScroller2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AttributesInfoPanel attributesInfoPanel = new AttributesInfoPanel(fsView.getAttributesFile());
                JScrollPane scroller = new JScrollPane(attributesInfoPanel, 20, 31);
                scroller.getVerticalScrollBar().setUnitIncrement(10);
                attributesTabs.addTab("Tree", scroller);
                tabs.addTab("Attributes file", attributesTabs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Journal journal = fsView.getJournal();
            if (journal != null) {
                JournalInfoPanel journalInfoPanel = new JournalInfoPanel(journal);
                tabs.addTab("Journal", journalInfoPanel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)tabs, "Center");
        this.setDefaultCloseOperation(2);
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        int adjustedHeight = width + width / 2;
        if (adjustedHeight < height) {
            this.setSize(width, adjustedHeight);
        }
        this.setLocationRelativeTo(null);
    }
}

