/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.catacombae.hfsexplorer.gui.SelectDevicePanel;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemRecognizer;
import org.catacombae.storage.io.ReadableStreamDataLocator;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.storage.ps.Partition;
import org.catacombae.storage.ps.PartitionSystemDetector;
import org.catacombae.storage.ps.PartitionSystemHandler;
import org.catacombae.storage.ps.PartitionSystemHandlerFactory;
import org.catacombae.storage.ps.PartitionSystemType;
import org.catacombae.storage.ps.PartitionType;
import org.catacombae.util.ObjectContainer;

public abstract class SelectDeviceDialog
extends JDialog {
    private SelectDevicePanel guiPanel;
    private JButton autodetectButton;
    private JRadioButton selectDeviceButton;
    private JRadioButton specifyDeviceNameButton;
    private JButton loadButton;
    private JButton cancelButton;
    private JTextField specifyDeviceNameField;
    private JComboBox detectedDevicesCombo;
    private ButtonGroup selectSpecifyGroup;
    private ReadableRandomAccessStream result = null;
    private String resultCreatePath = null;
    private String[] detectedDeviceNames;
    private static final SelectDeviceDialogFactory[] factories = new SelectDeviceDialogFactory[]{new WindowsFactory(), new LinuxFactory(), new MacOSXFactory(), new FreeBSDFactory(), new SolarisFactory()};

    protected SelectDeviceDialog(Frame owner, boolean modal, String title) {
        super(owner, modal);
        this.setTitle(title);
        this.guiPanel = new SelectDevicePanel(this.getExampleDeviceName());
        this.autodetectButton = this.guiPanel.autodetectButton;
        this.selectDeviceButton = this.guiPanel.selectDeviceButton;
        this.specifyDeviceNameButton = this.guiPanel.specifyDeviceNameButton;
        this.loadButton = this.guiPanel.loadButton;
        this.cancelButton = this.guiPanel.cancelButton;
        this.specifyDeviceNameField = this.guiPanel.specifyDeviceNameField;
        this.detectedDevicesCombo = this.guiPanel.detectedDevicesCombo;
        this.selectSpecifyGroup = new ButtonGroup();
        this.selectSpecifyGroup.add(this.selectDeviceButton);
        this.selectSpecifyGroup.add(this.specifyDeviceNameButton);
        this.detectedDevicesCombo.removeAllItems();
        for (String name : this.detectedDeviceNames = this.detectDevices()) {
            this.detectedDevicesCombo.addItem(name);
        }
        if (this.detectedDeviceNames.length > 0) {
            this.detectedDevicesCombo.setSelectedIndex(0);
            this.specifyDeviceNameField.setText(this.getDevicePrefix() + this.detectedDevicesCombo.getSelectedItem().toString());
        }
        this.autodetectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectDeviceDialog.this.autodetectFilesystems();
            }
        });
        this.detectedDevicesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    SelectDeviceDialog.this.specifyDeviceNameField.setText(SelectDeviceDialog.this.getDevicePrefix() + ie.getItem().toString());
                }
            }
        });
        this.selectDeviceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectDeviceDialog.this.detectedDevicesCombo.setEnabled(true);
                SelectDeviceDialog.this.specifyDeviceNameField.setEnabled(false);
                SelectDeviceDialog.this.specifyDeviceNameField.setText(SelectDeviceDialog.this.getDevicePrefix() + SelectDeviceDialog.this.detectedDevicesCombo.getSelectedItem().toString());
            }
        });
        this.specifyDeviceNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectDeviceDialog.this.detectedDevicesCombo.setEnabled(false);
                SelectDeviceDialog.this.specifyDeviceNameField.setEnabled(true);
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectDeviceDialog.this.resultCreatePath = SelectDeviceDialog.this.specifyDeviceNameField.getText();
                SelectDeviceDialog.this.result = SelectDeviceDialog.this.createStream(SelectDeviceDialog.this.resultCreatePath);
                SelectDeviceDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SelectDeviceDialog.this.setVisible(false);
            }
        });
        this.add((Component)this.guiPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    public ReadableRandomAccessStream getPartitionStream() {
        return this.result;
    }

    public String getPathName() {
        return this.resultCreatePath;
    }

    protected ReadableRandomAccessStream createStream(String path) {
        return new ReadableFileStream(path);
    }

    protected abstract String getDevicePrefix();

    protected abstract String getExampleDeviceName();

    protected abstract boolean isPartition(String var1);

    protected abstract String[] detectDevices();

    public static boolean isSystemSupported() {
        boolean supported = false;
        for (SelectDeviceDialogFactory factory : factories) {
            if (!factory.isSystemSupported()) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public static SelectDeviceDialog createSelectDeviceDialog(Frame owner, boolean modal, String title) {
        SelectDeviceDialog dialog = null;
        for (SelectDeviceDialogFactory factory : factories) {
            if (!factory.isSystemSupported()) continue;
            dialog = factory.createDeviceDialog(owner, modal, title);
            break;
        }
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autodetectFilesystems() {
        LinkedList<String> plainFileSystems = new LinkedList<String>();
        LinkedList<EmbeddedPartitionEntry> embeddedFileSystems = new LinkedList<EmbeddedPartitionEntry>();
        for (int i = 0; i < this.detectedDeviceNames.length; ++i) {
            String deviceName = this.detectedDeviceNames[i];
            ReadableRandomAccessStream llf = null;
            PartitionSystemHandler partSys = null;
            try {
                HFSCommonFileSystemRecognizer.FileSystemType fsType;
                PartitionSystemType pst;
                llf = this.createStream(this.getDevicePrefix() + deviceName);
                PartitionSystemType[] detectedTypes = PartitionSystemDetector.detectPartitionSystem(llf, false);
                if (detectedTypes.length == 1) {
                    pst = detectedTypes[0];
                } else if (detectedTypes.length == 0) {
                    pst = null;
                } else {
                    String msg = detectedTypes.length + " partition " + "types detected: { ";
                    for (PartitionSystemType t : detectedTypes) {
                        msg = msg + (Object)((Object)t) + " ";
                    }
                    msg = msg + "} Cannot continue.";
                    throw new RuntimeException(msg);
                }
                boolean fileSystemFound = false;
                if (pst != null) {
                    PartitionSystemHandlerFactory fact = pst.createDefaultHandlerFactory();
                    partSys = fact.createHandler(new ReadableStreamDataLocator(llf));
                    Partition[] parts = partSys.getPartitions();
                    for (int j = 0; j < parts.length; ++j) {
                        HFSCommonFileSystemRecognizer.FileSystemType fsType2;
                        Partition part = parts[j];
                        PartitionType pt = part.getType();
                        if (pt != PartitionType.APPLE_HFS_CONTAINER && pt != PartitionType.APPLE_HFSX || !HFSCommonFileSystemRecognizer.isTypeSupported(fsType2 = HFSCommonFileSystemRecognizer.detectFileSystem(llf, part.getStartOffset()))) continue;
                        fileSystemFound = true;
                        embeddedFileSystems.add(new EmbeddedPartitionEntry(deviceName, j, pst, part));
                    }
                }
                if (fileSystemFound || this.isPartition(deviceName) || !HFSCommonFileSystemRecognizer.isTypeSupported(fsType = HFSCommonFileSystemRecognizer.detectFileSystem(llf, 0L))) continue;
                plainFileSystems.add(deviceName);
                continue;
            }
            catch (Exception e) {
                HFSCommonFileSystemRecognizer.FileSystemType fsType;
                System.out.println("INFO: Non-critical exception while detecting partition system at \"" + this.getDevicePrefix() + deviceName + "\": " + e.toString());
                if (llf == null || !HFSCommonFileSystemRecognizer.isTypeSupported(fsType = HFSCommonFileSystemRecognizer.detectFileSystem(llf, 0L))) continue;
                plainFileSystems.add(deviceName);
                continue;
            }
            finally {
                if (partSys != null) {
                    partSys.close();
                }
            }
        }
        if (plainFileSystems.size() >= 1 || embeddedFileSystems.size() >= 1) {
            String[] plainStrings = plainFileSystems.toArray(new String[plainFileSystems.size()]);
            String[] embeddedStrings = new String[embeddedFileSystems.size()];
            int i = 0;
            for (EmbeddedPartitionEntry cur : embeddedFileSystems) {
                embeddedStrings[i++] = cur.toString();
            }
            Object[] allOptions = new String[plainStrings.length + embeddedStrings.length];
            for (i = 0; i < plainStrings.length; ++i) {
                allOptions[i] = plainStrings[i];
            }
            for (i = 0; i < embeddedStrings.length; ++i) {
                allOptions[plainStrings.length + i] = embeddedStrings[i];
            }
            Object selectedValue = JOptionPane.showInputDialog(this, "Autodetection complete! Found " + allOptions.length + " " + "HFS+ file systems.\n" + "Please choose which one to load:", "Load HFS+ file system", 3, null, allOptions, allOptions[0]);
            if (selectedValue != null) {
                int selectedIndex = -1;
                for (i = 0; i < allOptions.length; ++i) {
                    if (!selectedValue.equals(allOptions[i])) continue;
                    selectedIndex = i;
                    break;
                }
                if (selectedIndex == -1) {
                    throw new RuntimeException("selectedIndex == -1");
                }
                if (selectedIndex >= plainStrings.length) {
                    EmbeddedPartitionEntry embeddedInfo = (EmbeddedPartitionEntry)embeddedFileSystems.get(selectedIndex -= plainStrings.length);
                    if (embeddedInfo == null) {
                        throw new RuntimeException("embeddedInfo == null");
                    }
                    switch (embeddedInfo.psType) {
                        case APM: 
                        case GPT: 
                        case MBR: {
                            ReadableRandomAccessStream llf = this.createStream(this.getDevicePrefix() + embeddedInfo.deviceName);
                            Partition p = embeddedInfo.partition;
                            this.resultCreatePath = this.getDevicePrefix() + selectedValue.toString();
                            this.result = new ReadableConcatenatedStream(llf, p.getStartOffset(), p.getLength());
                            this.setVisible(false);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected partition system: " + (Object)((Object)embeddedInfo.psType));
                        }
                    }
                } else {
                    this.resultCreatePath = this.getDevicePrefix() + selectedValue.toString();
                    this.result = this.createStream(this.resultCreatePath);
                    this.setVisible(false);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "No HFS+ file systems found...", "Result", 1);
        }
    }

    private static final class EmbeddedPartitionEntry {
        public final String deviceName;
        public final long partitionNumber;
        public final PartitionSystemType psType;
        public final Partition partition;

        public EmbeddedPartitionEntry(String deviceName, long partitionNumber, PartitionSystemType psType, Partition partition) {
            this.deviceName = deviceName;
            this.partitionNumber = partitionNumber;
            this.psType = psType;
            this.partition = partition;
        }

        private String getPartitionSystemString() {
            switch (this.psType) {
                case MBR: {
                    return "MBR";
                }
                case GPT: {
                    return "GPT";
                }
                case APM: {
                    return "APM";
                }
                case DOS_EXTENDED: {
                    return "EBR";
                }
            }
            return "Unknown partition system";
        }

        public String toString() {
            return this.deviceName + "[" + this.getPartitionSystemString() + ":Partition" + this.partitionNumber + "]";
        }
    }

    private static class Solaris
    extends CommonUNIX {
        private static final FilenameFilter diskDeviceFileNameFilter = new SolarisDeviceFilenameFilter();

        public Solaris(Frame owner, boolean modal, String title) {
            super(owner, modal, title);
        }

        protected FilenameFilter getDiskDeviceFileNameFilter() {
            return diskDeviceFileNameFilter;
        }

        protected String getDevicePrefix() {
            return "/dev/dsk/";
        }

        protected String getExampleDeviceName() {
            return "/dev/dsk/c0t0d0s0";
        }

        protected boolean isPartition(String deviceName) {
            return deviceName.matches("[ps][0-9]+$");
        }

        private static class SolarisDeviceFilenameFilter
        implements FilenameFilter {
            private SolarisDeviceFilenameFilter() {
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }
    }

    private static class SolarisFactory
    implements SelectDeviceDialogFactory {
        private SolarisFactory() {
        }

        public boolean isSystemSupported() {
            return System.getProperty("os.name").toLowerCase().startsWith("sunos");
        }

        public SelectDeviceDialog createDeviceDialog(Frame owner, boolean modal, String title) {
            return new Solaris(owner, modal, title);
        }
    }

    private static class FreeBSD
    extends CommonUNIX {
        private static final FilenameFilter genericdiskDeviceFileNameFilter = new FreeBSDDeviceFilenameFilter(null);

        public FreeBSD(Frame owner, boolean modal, String title) {
            super(owner, modal, title);
        }

        protected FilenameFilter getDiskDeviceFileNameFilter() {
            String[] devices = null;
            Process sysctlProcess = null;
            BufferedReader sysctlStdoutReader = null;
            try {
                sysctlProcess = Runtime.getRuntime().exec(new String[]{"/sbin/sysctl", "kern.disks"});
                sysctlStdoutReader = new BufferedReader(new InputStreamReader(sysctlProcess.getInputStream(), "UTF-8"));
                String disksString = sysctlStdoutReader.readLine();
                int retval = sysctlProcess.waitFor();
                if (retval != 0) {
                    System.err.println("sysctl returned error value (" + retval + "). Falling back on exhaustive " + "detection method.");
                } else if (disksString.startsWith("kern.disks: ")) {
                    devices = disksString.substring("kern.disks: ".length()).split("\\s");
                    if (devices.length == 0) {
                        System.err.println("No disks returned from sysctl. Falling back on exhaustive detection method...");
                        devices = null;
                    }
                } else {
                    System.err.println("Unexpected output from sysctl command: \"" + disksString + "\" Falling back " + "on exhaustive detection method...");
                }
            }
            catch (IOException ex) {
                System.err.println("Exception while issuing sysctl command:");
                ex.printStackTrace();
                System.err.println("Falling back on exhaustive detection method...");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (sysctlStdoutReader != null) {
                    try {
                        sysctlStdoutReader.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            FilenameFilter filter = devices != null ? new FreeBSDDeviceFilenameFilter(devices) : genericdiskDeviceFileNameFilter;
            return filter;
        }

        protected String getExampleDeviceName() {
            return "/dev/da0";
        }

        protected boolean isPartition(String deviceName) {
            return deviceName.matches("s[0-9]+$");
        }

        private static class FreeBSDDeviceFilenameFilter
        implements FilenameFilter {
            public String[] knownDevices;

            public FreeBSDDeviceFilenameFilter(String[] knownDevices) {
                this.knownDevices = knownDevices;
            }

            public boolean accept(File dir, String name) {
                if (this.knownDevices != null) {
                    return this.acceptSpecific(dir, name);
                }
                return this.acceptGeneric(dir, name);
            }

            private boolean acceptSpecific(File dir, String name) {
                boolean acceptResult = false;
                for (String device : this.knownDevices) {
                    if (!name.matches("^" + device + "+([sp][0-9]+([a-z]+)?)?$")) continue;
                    acceptResult = true;
                    break;
                }
                return acceptResult;
            }

            private boolean acceptGeneric(File dir, String name) {
                return name.matches("ada[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("ad[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("da[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("cd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("acd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("fd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("mcd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("scd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("sa[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("ast[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("aacd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("mlxd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("mlyd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("amrd[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("idad[0-9]+([sp][0-9]+([a-z]+)?)?$") || name.matches("twed[0-9]+([sp][0-9]+([a-z]+)?)?$");
            }
        }
    }

    private static class FreeBSDFactory
    implements SelectDeviceDialogFactory {
        private FreeBSDFactory() {
        }

        public boolean isSystemSupported() {
            return System.getProperty("os.name").toLowerCase().startsWith("freebsd");
        }

        public SelectDeviceDialog createDeviceDialog(Frame owner, boolean modal, String title) {
            return new FreeBSD(owner, modal, title);
        }
    }

    private static class MacOSX
    extends CommonUNIX {
        private static final FilenameFilter diskDeviceFileNameFilter = new MacOSXDeviceFilenameFilter();

        public MacOSX(Frame owner, boolean modal, String title) {
            super(owner, modal, title);
        }

        protected FilenameFilter getDiskDeviceFileNameFilter() {
            return diskDeviceFileNameFilter;
        }

        protected String getExampleDeviceName() {
            return "/dev/disk0s1";
        }

        protected boolean isPartition(String deviceName) {
            return deviceName.matches("s[0-9]+$");
        }

        private static class MacOSXDeviceFilenameFilter
        implements FilenameFilter {
            private MacOSXDeviceFilenameFilter() {
            }

            public boolean accept(File dir, String name) {
                return name.matches("disk[0-9]+(s[0-9]+)?$");
            }
        }
    }

    private static class MacOSXFactory
    implements SelectDeviceDialogFactory {
        private MacOSXFactory() {
        }

        public boolean isSystemSupported() {
            return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        }

        public SelectDeviceDialog createDeviceDialog(Frame owner, boolean modal, String title) {
            return new MacOSX(owner, modal, title);
        }
    }

    private static class Linux
    extends CommonUNIX {
        private static final FilenameFilter diskDeviceFileNameFilter = new LinuxDeviceFilenameFilter();

        public Linux(Frame owner, boolean modal, String title) {
            super(owner, modal, title);
        }

        protected FilenameFilter getDiskDeviceFileNameFilter() {
            return diskDeviceFileNameFilter;
        }

        protected String getExampleDeviceName() {
            return "/dev/sda1";
        }

        protected boolean isPartition(String deviceName) {
            return deviceName.matches("[0-9]+$");
        }

        protected String[] detectDevices() {
            LinkedList<String> deviceNames = new LinkedList<String>();
            BufferedReader r = null;
            try {
                String curLine;
                try {
                    r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/partitions"), "UTF-8"));
                }
                catch (IOException e) {
                    System.err.println("Unable to open /proc/partitions for reading! Falling back on common UNIX method for device detection.");
                    return super.detectDevices();
                }
                r.readLine();
                while ((curLine = r.readLine()) != null) {
                    int i;
                    if (curLine.trim().length() == 0) continue;
                    char[] curLineChars = curLine.toCharArray();
                    for (i = 0; i < curLineChars.length && Character.isWhitespace(curLineChars[i]); ++i) {
                    }
                    while (i < curLineChars.length && !Character.isWhitespace(curLineChars[i])) {
                        ++i;
                    }
                    while (i < curLineChars.length && Character.isWhitespace(curLineChars[i])) {
                        ++i;
                    }
                    while (i < curLineChars.length && !Character.isWhitespace(curLineChars[i])) {
                        ++i;
                    }
                    while (i < curLineChars.length && Character.isWhitespace(curLineChars[i])) {
                        ++i;
                    }
                    while (i < curLineChars.length && !Character.isWhitespace(curLineChars[i])) {
                        ++i;
                    }
                    while (i < curLineChars.length && Character.isWhitespace(curLineChars[i])) {
                        ++i;
                    }
                    if (i < curLineChars.length) {
                        String curName = new String(curLineChars, i, curLineChars.length - i).trim();
                        try {
                            FileInputStream is = new FileInputStream(this.getDevicePrefix() + curName);
                            is.close();
                            deviceNames.add(curName);
                        }
                        catch (IOException ex) {}
                        continue;
                    }
                    System.err.println("Error while parsing /proc/partitions line \"" + curLine + "\".");
                }
                Object[] deviceNamesArray = deviceNames.toArray(new String[deviceNames.size()]);
                Arrays.sort(deviceNamesArray);
                return deviceNamesArray;
            }
            catch (IOException ex) {
                throw new RuntimeIOException(ex);
            }
        }

        private static class LinuxDeviceFilenameFilter
        implements FilenameFilter {
            private LinuxDeviceFilenameFilter() {
            }

            public boolean accept(File dir, String name) {
                return name.matches("sd[a-z]+([0-9]+)?$") || name.matches("hd[a-z]+([0-9]+)?$") || name.matches("sr[0-9]+$") || name.matches("fd[0-9]+$") || name.matches("dm-[0-9]+$") || name.matches("mmcblk[0-9]+(p[0-9]+)?$");
            }
        }
    }

    private static class LinuxFactory
    implements SelectDeviceDialogFactory {
        private LinuxFactory() {
        }

        public boolean isSystemSupported() {
            return System.getProperty("os.name").toLowerCase().startsWith("linux");
        }

        public SelectDeviceDialog createDeviceDialog(Frame owner, boolean modal, String title) {
            return new Linux(owner, modal, title);
        }
    }

    private static abstract class CommonUNIX
    extends SelectDeviceDialog {
        public CommonUNIX(Frame owner, boolean modal, String title) {
            super(owner, modal, title);
        }

        protected abstract FilenameFilter getDiskDeviceFileNameFilter();

        protected String getDevicePrefix() {
            return "/dev/";
        }

        protected String[] detectDevices() {
            File devDirFile = new File(this.getDevicePrefix());
            File[] diskDevices = devDirFile.listFiles(this.getDiskDeviceFileNameFilter());
            ArrayList<String> deviceNames = new ArrayList<String>(diskDevices.length);
            for (int i = 0; i < diskDevices.length; ++i) {
                final String curName = diskDevices[i].getName();
                final ObjectContainer<Object> canRead = new ObjectContainer<Object>(null);
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FileInputStream is = null;
                        try {
                            is = new FileInputStream(CommonUNIX.this.getDevicePrefix() + curName);
                            canRead.o = true;
                        }
                        catch (IOException ex) {
                            canRead.o = false;
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                };
                t.start();
                try {
                    t.join(5000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                t.interrupt();
                if (canRead.o == null) {
                    System.err.println("Timeout while detecting device at: " + this.getDevicePrefix() + curName);
                    continue;
                }
                if (!((Boolean)canRead.o).booleanValue()) continue;
                deviceNames.add(curName);
            }
            Object[] deviceNamesArray = deviceNames.toArray(new String[deviceNames.size()]);
            Arrays.sort(deviceNamesArray);
            return deviceNamesArray;
        }
    }

    private static class Windows
    extends SelectDeviceDialog {
        public Windows(Frame owner, boolean modal, String title) {
            super(owner, modal, title);
        }

        protected ReadableRandomAccessStream createStream(String path) {
            return new ReadableWin32FileStream(path);
        }

        protected String getDevicePrefix() {
            return "\\\\?\\GLOBALROOT\\Device\\";
        }

        protected String getExampleDeviceName() {
            return "\\\\?\\GLOBALROOT\\Device\\Harddisk0\\Partition1";
        }

        protected boolean isPartition(String deviceName) {
            return !deviceName.endsWith("Partition0") && deviceName.matches("Harddisk[0-9]+\\\\Partition[0-9]+$");
        }

        protected String[] detectDevices() {
            LinkedList<String> activeDeviceNames = new LinkedList<String>();
            int i = 0;
            while (true) {
                boolean anyFound = false;
                int j = 0;
                while (true) {
                    try {
                        String currentDevice = "Harddisk" + i + "\\Partition" + j;
                        ReadableRandomAccessStream curFile = this.createStream(this.getDevicePrefix() + currentDevice);
                        curFile.close();
                        activeDeviceNames.addLast(currentDevice);
                        anyFound = true;
                    }
                    catch (Exception e) {
                        if (j >= 20) break;
                    }
                    ++j;
                }
                if (!anyFound && i >= 20) break;
                ++i;
            }
            i = 0;
            while (true) {
                try {
                    String currentDevice = "CdRom" + i;
                    ReadableRandomAccessStream curFile = this.createStream(this.getDevicePrefix() + currentDevice);
                    curFile.close();
                    activeDeviceNames.addLast(currentDevice);
                }
                catch (Exception e) {
                    if (i >= 20) break;
                }
                ++i;
            }
            for (char c = 'A'; c <= 'Z'; c = (char)(c + 1)) {
                try {
                    String currentDevice = "TrueCryptVolume" + c;
                    ReadableRandomAccessStream curFile = this.createStream(this.getDevicePrefix() + currentDevice);
                    curFile.close();
                    activeDeviceNames.addLast(currentDevice);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return activeDeviceNames.toArray(new String[activeDeviceNames.size()]);
        }
    }

    private static class WindowsFactory
    implements SelectDeviceDialogFactory {
        private WindowsFactory() {
        }

        public boolean isSystemSupported() {
            return System.getProperty("os.name").toLowerCase().startsWith("windows");
        }

        public SelectDeviceDialog createDeviceDialog(Frame owner, boolean modal, String title) {
            return new Windows(owner, modal, title);
        }
    }

    private static interface SelectDeviceDialogFactory {
        public boolean isSystemSupported();

        public SelectDeviceDialog createDeviceDialog(Frame var1, boolean var2, String var3);
    }
}

