/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MacUtil {
    public static boolean isMacOSX() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static void registerMacApplicationHandler(MacApplicationHandler qh) {
        try {
            MacUtil.registerMacApplicationHandlerInternal(qh);
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static void registerMacApplicationHandlerInternal(final MacApplicationHandler qh) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
        Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        Class<?> applicationEventClass = Class.forName("com.apple.eawt.ApplicationEvent");
        Method applicationGetApplicationMethod = applicationClass.getMethod("getApplication", new Class[0]);
        Object applicationObject = applicationGetApplicationMethod.invoke(null, new Object[0]);
        final Method applicationEventSetHandledMethod = applicationEventClass.getMethod("setHandled", Boolean.TYPE);
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("handleQuit")) {
                    Object event = args[0];
                    if (qh.acceptQuit()) {
                        applicationEventSetHandledMethod.invoke(event, true);
                    } else {
                        applicationEventSetHandledMethod.invoke(event, false);
                    }
                    return null;
                }
                if (method.getName().equals("handleAbout")) {
                    Object event = args[0];
                    qh.showAboutDialog();
                    applicationEventSetHandledMethod.invoke(event, true);
                    return null;
                }
                if (method.getName().equals("handleOpenApplication") || method.getName().equals("handleOpenFile") || method.getName().equals("handlePreferences") || method.getName().equals("handlePrintFile") || method.getName().equals("handleReOpenApplication")) {
                    return null;
                }
                throw new NoSuchMethodException("No \"" + method.getName() + "\" defined.");
            }
        };
        Object applicationAdapterObject = Proxy.newProxyInstance(applicationListenerClass.getClassLoader(), new Class[]{applicationListenerClass}, invocationHandler);
        Method applicationAddApplicationListenerMethod = applicationClass.getMethod("addApplicationListener", applicationListenerClass);
        applicationAddApplicationListenerMethod.invoke(applicationObject, applicationAdapterObject);
    }

    public static interface MacApplicationHandler {
        public boolean acceptQuit();

        public void showAboutDialog();
    }
}

