/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Java7Util {
    public static boolean isJava7OrHigher() {
        return System.getProperty("java.specification.version").compareTo("1.7") >= 0;
    }

    public static void setFileTimes(String path, Date creationTime, Date lastAccessTime, Date lastModifiedTime) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        Object lastModifiedFileTimeObject;
        Object lastAccessFileTimeObject;
        Object creationFileTimeObject;
        Class<?> pathClass = Class.forName("java.nio.file.Path");
        Class<?> fileSystemsClass = Class.forName("java.nio.file.FileSystems");
        Class<?> fileSystemClass = Class.forName("java.nio.file.FileSystem");
        Class<?> basicFileAttributeViewClass = Class.forName("java.nio.file.attribute.BasicFileAttributeView");
        Class<?> filesClass = Class.forName("java.nio.file.Files");
        Class<?> linkOptionClass = Class.forName("java.nio.file.LinkOption");
        Class<?> fileTimeClass = Class.forName("java.nio.file.attribute.FileTime");
        Method fileSystemsGetDefaultMethod = fileSystemsClass.getMethod("getDefault", new Class[0]);
        Object defaultFileSystemObject = fileSystemsGetDefaultMethod.invoke(null, new Object[0]);
        Method fileSystemGetPathMethod = fileSystemClass.getMethod("getPath", String.class, String[].class);
        Object pObject = fileSystemGetPathMethod.invoke(defaultFileSystemObject, path, new String[0]);
        Field noFollowLinksField = linkOptionClass.getField("NOFOLLOW_LINKS");
        Object noFollowLinksObject = noFollowLinksField.get(null);
        Object linkOptionsArray = Array.newInstance(linkOptionClass, 1);
        Array.set(linkOptionsArray, 0, noFollowLinksObject);
        Method getFileAttributeViewMethod = filesClass.getMethod("getFileAttributeView", pathClass, Class.class, linkOptionsArray.getClass());
        Object attrViewObject = getFileAttributeViewMethod.invoke(null, pObject, basicFileAttributeViewClass, linkOptionsArray);
        if (creationTime != null) {
            Method fileTimefromMillisMethod = fileTimeClass.getMethod("fromMillis", Long.TYPE);
            creationFileTimeObject = fileTimefromMillisMethod.invoke(null, creationTime.getTime());
        } else {
            creationFileTimeObject = null;
        }
        if (lastAccessTime != null) {
            Method fileTimefromMillisMethod = fileTimeClass.getMethod("fromMillis", Long.TYPE);
            lastAccessFileTimeObject = fileTimefromMillisMethod.invoke(null, lastAccessTime.getTime());
        } else {
            lastAccessFileTimeObject = null;
        }
        if (lastModifiedTime != null) {
            Method fileTimefromMillisMethod = fileTimeClass.getMethod("fromMillis", Long.TYPE);
            lastModifiedFileTimeObject = fileTimefromMillisMethod.invoke(null, lastModifiedTime.getTime());
        } else {
            lastModifiedFileTimeObject = null;
        }
        Method basicFileAttributeViewSetTimesMethod = basicFileAttributeViewClass.getMethod("setTimes", fileTimeClass, fileTimeClass, fileTimeClass);
        basicFileAttributeViewSetTimesMethod.invoke(attrViewObject, lastModifiedFileTimeObject, lastAccessFileTimeObject, creationFileTimeObject);
    }

    public static void setPosixPermissions(String path, boolean ownerRead, boolean ownerWrite, boolean ownerExecute, boolean groupRead, boolean groupWrite, boolean groupExecute, boolean othersRead, boolean othersWrite, boolean othersExecute) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        Object curObject;
        Field curField;
        Class<?> fileSystemsClass = Class.forName("java.nio.file.FileSystems");
        Class<?> fileSystemClass = Class.forName("java.nio.file.FileSystem");
        Class<?> pathClass = Class.forName("java.nio.file.Path");
        Class<?> posixFileAttributeViewClass = Class.forName("java.nio.file.attribute.PosixFileAttributeView");
        Class<?> filesClass = Class.forName("java.nio.file.Files");
        Class<?> linkOptionClass = Class.forName("java.nio.file.LinkOption");
        Class<?> posixFilePermissionClass = Class.forName("java.nio.file.attribute.PosixFilePermission");
        Method fileSystemsGetDefaultMethod = fileSystemsClass.getMethod("getDefault", new Class[0]);
        Object defaultFileSystemObject = fileSystemsGetDefaultMethod.invoke(null, new Object[0]);
        Method fileSystemGetPathMethod = fileSystemClass.getMethod("getPath", String.class, String[].class);
        Object pObject = fileSystemGetPathMethod.invoke(defaultFileSystemObject, path, new String[0]);
        Field noFollowLinksField = linkOptionClass.getField("NOFOLLOW_LINKS");
        Object noFollowLinksObject = noFollowLinksField.get(null);
        Object linkOptionsArray = Array.newInstance(linkOptionClass, 1);
        Array.set(linkOptionsArray, 0, noFollowLinksObject);
        Method getFileAttributeViewMethod = filesClass.getMethod("getFileAttributeView", pathClass, Class.class, linkOptionsArray.getClass());
        Object attrViewObject = getFileAttributeViewMethod.invoke(null, pObject, posixFileAttributeViewClass, linkOptionsArray);
        if (attrViewObject == null) {
            return;
        }
        HashSet<Object> perms = new HashSet<Object>();
        if (ownerRead) {
            curField = posixFilePermissionClass.getField("OWNER_READ");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (ownerWrite) {
            curField = posixFilePermissionClass.getField("OWNER_WRITE");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (ownerExecute) {
            curField = posixFilePermissionClass.getField("OWNER_EXECUTE");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (groupRead) {
            curField = posixFilePermissionClass.getField("GROUP_READ");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (groupWrite) {
            curField = posixFilePermissionClass.getField("GROUP_WRITE");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (groupExecute) {
            curField = posixFilePermissionClass.getField("GROUP_EXECUTE");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (othersRead) {
            curField = posixFilePermissionClass.getField("OTHERS_READ");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (othersWrite) {
            curField = posixFilePermissionClass.getField("OTHERS_WRITE");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        if (othersExecute) {
            curField = posixFilePermissionClass.getField("OTHERS_EXECUTE");
            curObject = curField.get(null);
            perms.add(curObject);
        }
        Method posixFileAttributeViewSetPermissionMethod = posixFileAttributeViewClass.getMethod("setPermissions", Set.class);
        posixFileAttributeViewSetPermissionMethod.invoke(attrViewObject, perms);
    }

    public static void setPosixOwners(String path, int ownerId, int groupId) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        block2: {
            Class<?> fileSystemsClass = Class.forName("java.nio.file.FileSystems");
            Class<?> fileSystemClass = Class.forName("java.nio.file.FileSystem");
            Class<?> pathClass = Class.forName("java.nio.file.Path");
            Class<?> filesClass = Class.forName("java.nio.file.Files");
            Class<?> linkOptionClass = Class.forName("java.nio.file.LinkOption");
            Method fileSystemsGetDefaultMethod = fileSystemsClass.getMethod("getDefault", new Class[0]);
            Method fileSystemGetPathMethod = fileSystemClass.getMethod("getPath", String.class, String[].class);
            Field noFollowLinksField = linkOptionClass.getField("NOFOLLOW_LINKS");
            Object noFollowLinksObject = noFollowLinksField.get(null);
            Object linkOptionsArray = Array.newInstance(linkOptionClass, 1);
            Array.set(linkOptionsArray, 0, noFollowLinksObject);
            Object defaultFileSystemObject = fileSystemsGetDefaultMethod.invoke(null, new Object[0]);
            Object pObject = fileSystemGetPathMethod.invoke(defaultFileSystemObject, path, new String[0]);
            Method filesSetAttributeMethod = filesClass.getMethod("setAttribute", pathClass, String.class, Object.class, linkOptionsArray.getClass());
            try {
                filesSetAttributeMethod.invoke(null, pObject, "unix:uid", ownerId, linkOptionsArray);
                filesSetAttributeMethod.invoke(null, pObject, "unix:gid", groupId, linkOptionsArray);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof UnsupportedOperationException) break block2;
                throw ex;
            }
        }
    }

    public static void createSymbolicLink(String linkPathString, String targetPathString) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        Class<?> fileSystemsClass = Class.forName("java.nio.file.FileSystems");
        Class<?> fileSystemClass = Class.forName("java.nio.file.FileSystem");
        Class<?> pathClass = Class.forName("java.nio.file.Path");
        Class<?> filesClass = Class.forName("java.nio.file.Files");
        Class<?> fileAttributeClass = Class.forName("java.nio.file.attribute.FileAttribute");
        Object emptyFileAttributeArray = Array.newInstance(fileAttributeClass, 0);
        Method fileSystemsGetDefaultMethod = fileSystemsClass.getMethod("getDefault", new Class[0]);
        Method fileSystemGetPathMethod = fileSystemClass.getMethod("getPath", String.class, String[].class);
        Method fileSystemsCreateSymbolicLinkMethod = filesClass.getMethod("createSymbolicLink", pathClass, pathClass, emptyFileAttributeArray.getClass());
        Object defaultFileSystemObject = fileSystemsGetDefaultMethod.invoke(null, new Object[0]);
        Object linkPathObject = fileSystemGetPathMethod.invoke(defaultFileSystemObject, linkPathString, new String[0]);
        Object targetPathObject = fileSystemGetPathMethod.invoke(defaultFileSystemObject, targetPathString, new String[0]);
        fileSystemsCreateSymbolicLinkMethod.invoke(null, linkPathObject, targetPathObject, emptyFileAttributeArray);
    }
}

