/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java6Util
extends org.catacombae.util.Java6Util {
    public static boolean canOpen() {
        try {
            return Java6Util.canOpenInternal();
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static boolean canOpenInternal() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        Class<?> desktopClass = Class.forName("java.awt.Desktop");
        Class<?> desktopActionClass = Class.forName("java.awt.Desktop$Action");
        Method desktopGetDesktopMethod = desktopClass.getMethod("getDesktop", new Class[0]);
        Object desktopObject = desktopGetDesktopMethod.invoke(null, new Object[0]);
        Field desktopActionOpenField = desktopActionClass.getField("OPEN");
        Object openActionObject = desktopActionOpenField.get(null);
        Method desktopIsSupportedMethod = desktopClass.getMethod("isSupported", desktopActionClass);
        Object returnObject = desktopIsSupportedMethod.invoke(desktopObject, openActionObject);
        if (!(returnObject instanceof Boolean)) {
            throw new RuntimeException("Unexpected type returned from java.awt.Desktop.isSupported(java.awt.Desktop.Action): " + returnObject.getClass());
        }
        return (Boolean)returnObject;
    }

    public static void openFile(File f) throws IOException {
        try {
            Java6Util.openFileInternal(f);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
            }
            throw new RuntimeException(e);
        }
    }

    private static void openFileInternal(File f) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        Class<?> desktopClass = Class.forName("java.awt.Desktop");
        Method desktopGetDesktopMethod = desktopClass.getMethod("getDesktop", new Class[0]);
        Object desktopObject = desktopGetDesktopMethod.invoke(null, new Object[0]);
        Method desktopOpenFileMethod = desktopClass.getMethod("open", File.class);
        desktopOpenFileMethod.invoke(desktopObject, f);
    }

    public static void setIconImages(ImageIcon[] icons, Window window) {
        LinkedList<Image> iconImages = new LinkedList<Image>();
        for (ImageIcon ii : icons) {
            iconImages.addLast(ii.getImage());
        }
        try {
            Class<?> c = window.getClass();
            Method m = c.getMethod("setIconImages", List.class);
            m.invoke((Object)window, iconImages);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void addRowSorter(JTable table, DefaultTableModel tableModel, int defaultSortColumn, List<Comparator<?>> columnComparators) {
        try {
            Class<?> rowSorterClass = Class.forName("javax.swing.RowSorter");
            Class<?> tableRowSorterClass = Class.forName("javax.swing.table.TableRowSorter");
            Method tableRowSorterSetComparatorMethod = tableRowSorterClass.getMethod("setComparator", Integer.TYPE, Comparator.class);
            Method tableRowSorterToggleSortOrderMethod = tableRowSorterClass.getMethod("toggleSortOrder", Integer.TYPE);
            Object sorter = tableRowSorterClass.getConstructor(TableModel.class).newInstance(tableModel);
            int i = 0;
            for (Comparator<?> c : columnComparators) {
                if (c != null) {
                    tableRowSorterSetComparatorMethod.invoke(sorter, i, c);
                }
                ++i;
            }
            tableRowSorterToggleSortOrderMethod.invoke(sorter, defaultSortColumn);
            Class<?> c = table.getClass();
            Method m = c.getMethod("setRowSorter", rowSorterClass);
            m.invoke((Object)table, sorter);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

