/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfs.HFSVolume;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileThread;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFileThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThread;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolderThreadRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSExtentDescriptor;
import org.catacombae.hfs.types.hfscommon.CommonHFSForkData;
import org.catacombae.hfs.types.hfscommon.CommonHFSVolumeHeader;
import org.catacombae.hfsexplorer.Pair;
import org.catacombae.hfsexplorer.fs.NullProgressMonitor;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.storage.fs.FileSystemDetector;
import org.catacombae.storage.fs.FileSystemHandler;
import org.catacombae.storage.fs.FileSystemHandlerFactory;
import org.catacombae.storage.fs.FileSystemMajorType;
import org.catacombae.storage.fs.hfscommon.HFSCommonFileSystemHandler;
import org.catacombae.storage.io.ReadableStreamDataLocator;
import org.catacombae.storage.io.win32.ReadableWin32FileStream;
import org.catacombae.storage.ps.apm.types.APMPartition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HFSExplorer {
    public static final String VERSION = "0.22.1";
    public static final String COPYRIGHT = "Copyright \u00a9 Erik Larsson 2006-2014";
    public static final String[] NOTICES = new String[]{"This program is distributed under the GNU General Public License version 3.", "See <http://www.gnu.org/copyleft/gpl.html> for the details.", "", "Libraries used:", "    swing-layout <https://swing-layout.dev.java.net/>", "        Copyright \u00a9 2005-2006 Sun Microsystems, Inc. Licensed under", "        the Lesser General Public License.", "        See <http://www.gnu.org/licenses/lgpl.html> for the details.", "    iHarder Base64 encoder/decoder <http://iharder.sourceforge.net>", "        Public domain software.", "    Apache Ant bzip2 library <http://ant.apache.org/>", "        Copyright \u00a9 the Apache Software Foundation (ASF). Licensed", "        under the Apache License, Version 2.0.", "        See <http://www.apache.org/licenses/LICENSE-2.0> for the details."};
    public static BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
    private static Options options = new Options();
    private static Operation operation;
    private static BufferedReader stdIn;

    public static void main(String[] args) throws IOException {
        long length;
        long offset;
        if (args.length == 0) {
            HFSExplorer.printUsageInfo();
            System.exit(0);
        }
        if (!HFSExplorer.parseOptions(args, 0, args.length)) {
            System.exit(1);
            return;
        }
        ReadableRandomAccessStream isoRaf = ReadableWin32FileStream.isSystemSupported() ? new ReadableWin32FileStream(operation.getFilename()) : new ReadableFileStream(operation.getFilename());
        if (HFSExplorer.options.readAPM) {
            HFSExplorer.println("Reading the Apple Partition Map...");
            isoRaf.seek(512L);
            byte[] currentBlock = new byte[512];
            byte[] signature = new byte[2];
            ArrayList<APMPartition> partitions = new ArrayList<APMPartition>();
            for (int i = 0; i < 20; ++i) {
                isoRaf.readFully(currentBlock);
                signature[0] = currentBlock[0];
                signature[1] = currentBlock[1];
                if (!new String(signature, "ASCII").equals("PM")) break;
                HFSExplorer.print("Partition " + i + ": ");
                APMPartition p = new APMPartition(currentBlock, 0, 512);
                partitions.add(p);
                if (HFSExplorer.options.verbose) {
                    HFSExplorer.println();
                    p.printPartitionInfo(System.out);
                    continue;
                }
                HFSExplorer.println("\"" + p.getPmPartNameAsString() + "\" (" + p.getPmParTypeAsString() + ")");
            }
            HFSExplorer.print("Which partition do you wish to explore [0-" + (partitions.size() - 1) + "]? ");
            int partNum = Integer.parseInt(stdin.readLine());
            APMPartition chosenPartition = (APMPartition)partitions.get(partNum);
            String partitionType = chosenPartition.getPmParTypeAsString();
            if (!partitionType.trim().equals("Apple_HFS")) {
                HFSExplorer.println("The partition is not an HFS partition!");
                System.exit(0);
            }
            HFSExplorer.println("Parsing partition " + partNum + " (" + chosenPartition.getPmPartNameAsString().trim() + "/" + partitionType.trim() + ")");
            offset = (chosenPartition.getPmPyPartStart() + chosenPartition.getPmLgDataStart()) * 512;
            length = chosenPartition.getPmDataCnt() * 512;
        } else {
            offset = 0L;
            length = isoRaf.length();
        }
        switch (operation) {
            case BROWSE: {
                HFSExplorer.operationBrowse(operation, isoRaf, offset, length);
                break;
            }
            case FRAGCHECK: {
                HFSExplorer.operationFragCheck(operation, isoRaf, offset, length);
                break;
            }
            case SYSTEMFILEINFO: {
                HFSExplorer.operationSystemFileInfo(operation, isoRaf, offset, length);
                break;
            }
            default: {
                throw new RuntimeException("Unknown operation: " + (Object)((Object)operation));
            }
        }
    }

    private static void operationBrowse(Operation op, ReadableRandomAccessStream hfsFile, long fsOffset, long fsLength) {
        CommonHFSCatalogFolderRecord rootRecord;
        ReadableStreamDataLocator inputDataLocator = new ReadableStreamDataLocator(new ReadableConcatenatedStream(hfsFile, fsOffset, fsLength));
        FileSystemMajorType[] fsTypes = FileSystemDetector.detectFileSystem(inputDataLocator);
        FileSystemMajorType hfsType = null;
        block22: for (FileSystemMajorType type : fsTypes) {
            switch (type) {
                case APPLE_HFS: 
                case APPLE_HFS_PLUS: 
                case APPLE_HFSX: {
                    if (hfsType != null) {
                        throw new RuntimeException("Conflicting file system types: Detected both " + (Object)((Object)hfsType) + " and " + (Object)((Object)type) + ".");
                    }
                    hfsType = type;
                    continue block22;
                }
            }
        }
        if (hfsType == null) {
            System.err.println("No HFS file system found.");
            System.exit(1);
        } else {
            System.out.println("Detected a " + (Object)((Object)hfsType) + " file system.");
        }
        FileSystemHandlerFactory fact = hfsType.createDefaultHandlerFactory();
        FileSystemHandler fsHandler = fact.createHandler(inputDataLocator);
        if (!(fsHandler instanceof HFSCommonFileSystemHandler)) {
            throw new RuntimeException("Unexpected HFS fsHandler type: " + fsHandler.getClass());
        }
        HFSCommonFileSystemHandler hfsHandler = (HFSCommonFileSystemHandler)fsHandler;
        HFSVolume fsView = hfsHandler.getFSView();
        CommonHFSCatalogLeafRecord currentDir = rootRecord = fsView.getCatalogFile().getRootFolder();
        LinkedList<String> pathStack = new LinkedList<String>();
        LinkedList<CommonHFSCatalogFolderRecord> pathThread = new LinkedList<CommonHFSCatalogFolderRecord>();
        pathStack.addLast("");
        while (true) {
            CommonHFSCatalogLeafRecord[] recordsInDir;
            CommonHFSCatalogFolderThread currentThread = null;
            StringBuilder currentPath = new StringBuilder();
            for (String pathComponent : pathStack) {
                currentPath.append(pathComponent);
                currentPath.append("/");
            }
            HFSExplorer.println("Listing files in \"" + currentPath.toString() + "\":");
            boolean atLeastOneNonThreadEntryFound = false;
            for (CommonHFSCatalogLeafRecord rec : recordsInDir = fsView.getCatalogFile().listRecords(currentDir)) {
                PrintableStruct catThread;
                CommonHFSCatalogLeafRecord catThreadRec;
                if (rec instanceof CommonHFSCatalogFileRecord) {
                    CommonHFSCatalogFileRecord catFileRec = (CommonHFSCatalogFileRecord)rec;
                    CommonHFSCatalogFile catFile = catFileRec.getData();
                    HFSExplorer.println("  [" + catFile.getFileID() + "] \"" + rec.getKey().getNodeName() + "\" (" + catFile.getDataFork().getLogicalSize() + " B)");
                    if (atLeastOneNonThreadEntryFound) continue;
                    atLeastOneNonThreadEntryFound = true;
                    continue;
                }
                if (rec instanceof CommonHFSCatalogFolderRecord) {
                    CommonHFSCatalogFolderRecord catFolderRec = (CommonHFSCatalogFolderRecord)rec;
                    CommonHFSCatalogFolder catFolder = catFolderRec.getData();
                    HFSExplorer.println("  [" + catFolder.getFolderID() + "] \"" + catFolderRec.getKey().getNodeName() + "/\"");
                    if (atLeastOneNonThreadEntryFound) continue;
                    atLeastOneNonThreadEntryFound = true;
                    continue;
                }
                if (rec instanceof CommonHFSCatalogFolderThreadRecord) {
                    catThreadRec = (CommonHFSCatalogFolderThreadRecord)rec;
                    catThread = ((CommonHFSCatalogFolderThreadRecord)catThreadRec).getData();
                    HFSExplorer.println("  [Folder Thread: [" + ((CommonHFSCatalogFolderThread)catThread).getParentID() + "] \"" + ((CommonHFSCatalogFolderThread)catThread).getNodeName() + "\"]");
                    if (currentThread == null) {
                        currentThread = ((CommonHFSCatalogFolderThreadRecord)catThreadRec).getData();
                        continue;
                    }
                    HFSExplorer.println("WARNING: Found more than one folder thread in " + currentPath + "!");
                    continue;
                }
                if (!(rec instanceof CommonHFSCatalogFileThreadRecord)) continue;
                catThreadRec = (CommonHFSCatalogFileThreadRecord)rec;
                catThread = ((CommonHFSCatalogFileThreadRecord)catThreadRec).getData();
                HFSExplorer.println("  [File Thread: [" + ((CommonHFSCatalogFileThread)catThread).getParentID() + "] \"" + ((CommonHFSCatalogFileThread)catThread).getNodeName() + "\"]");
            }
            if (currentThread == null && atLeastOneNonThreadEntryFound) {
                HFSExplorer.println("WARNING: Found no folder thread in " + currentPath + "! Won't be able to go back from children in hierarchy.");
            }
            while (true) {
                HFSExplorer.print("Command[?]: ");
                String input = null;
                try {
                    input = stdIn.readLine().trim();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
                if (input.equalsIgnoreCase("?")) {
                    HFSExplorer.println("Available commands:");
                    HFSExplorer.println(" ls                List contents of current directory");
                    HFSExplorer.println(" cd <dirName>      Changes directory by name");
                    HFSExplorer.println(" cdn <dirID>       Changes directory by ID");
                    HFSExplorer.println(" info <fileID>     Gets extensive information about the file.");
                    HFSExplorer.println(" extract <fileID>  Extracts <fileID> to current directory");
                    HFSExplorer.println(" q                 Quits program");
                    continue;
                }
                if (input.equals("q")) {
                    return;
                }
                if (input.equals("ls")) break;
                if (input.startsWith("extract ")) {
                    input = input.substring("extract ".length()).trim();
                    try {
                        long nextID = Long.parseLong(input);
                        CommonHFSCatalogLeafRecord selectedFileRecord = null;
                        CommonHFSCatalogFile selectedFile = null;
                        for (CommonHFSCatalogLeafRecord rec : recordsInDir) {
                            CommonHFSCatalogFileRecord catFileRec;
                            CommonHFSCatalogFile catFile;
                            if (!(rec instanceof CommonHFSCatalogFileRecord) || (catFile = (catFileRec = (CommonHFSCatalogFileRecord)rec).getData()).getFileID().toLong() != nextID) continue;
                            selectedFileRecord = rec;
                            selectedFile = catFile;
                            break;
                        }
                        if (selectedFileRecord == null) {
                            HFSExplorer.println("ID not present in dir.");
                            continue;
                        }
                        String dataForkFilename = selectedFileRecord.getKey().getNodeName().toString();
                        FileOutputStream dataOut = new FileOutputStream(dataForkFilename);
                        HFSExplorer.print("Extracting data fork to file \"" + dataForkFilename + "\"...");
                        try {
                            long bytesExtracted = fsView.extractDataForkToStream(selectedFileRecord, dataOut, NullProgressMonitor.getInstance());
                            HFSExplorer.println("extracted " + bytesExtracted + " bytes.");
                            dataOut.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            try {
                                dataOut.close();
                            }
                            catch (IOException ioe2) {}
                            continue;
                        }
                        String resourceForkFilename = dataForkFilename + ".resourcefork";
                        FileOutputStream resourceOut = new FileOutputStream(resourceForkFilename);
                        HFSExplorer.print("Extracting resource fork to file \"" + resourceForkFilename + "\"...");
                        try {
                            long bytesExtracted = fsView.extractResourceForkToStream(selectedFileRecord, resourceOut, NullProgressMonitor.getInstance());
                            HFSExplorer.println("extracted " + bytesExtracted + " bytes.");
                            resourceOut.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            try {
                                dataOut.close();
                            }
                            catch (IOException ioe2) {
                            }
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (NumberFormatException nfe) {
                        HFSExplorer.println("Invalid input!");
                    }
                    continue;
                }
                if (input.startsWith("info ")) {
                    input = input.substring("info ".length()).trim();
                    try {
                        long nextID = Long.parseLong(input);
                        CommonHFSCatalogLeafRecord selectedFileRecord = null;
                        for (CommonHFSCatalogLeafRecord rec : recordsInDir) {
                            CommonHFSCatalogFileRecord catFileRec;
                            CommonHFSCatalogFile catFile;
                            if (!(rec instanceof CommonHFSCatalogFileRecord) || (catFile = (catFileRec = (CommonHFSCatalogFileRecord)rec).getData()).getFileID().toLong() != nextID) continue;
                            selectedFileRecord = rec;
                            rec.print(System.out, "");
                            break;
                        }
                        if (selectedFileRecord != null) continue;
                        HFSExplorer.println("ID not present in dir.");
                    }
                    catch (NumberFormatException nfe) {
                        HFSExplorer.println("Invalid input!");
                    }
                    continue;
                }
                if (input.startsWith("cdn ")) {
                    if ((input = input.substring("cdn ".length()).trim()).equals("..")) {
                        HFSExplorer.println("Not yet implemented.");
                        continue;
                    }
                    try {
                        long nextID = Long.parseLong(input);
                        CommonHFSCatalogLeafRecord nextDir = null;
                        for (CommonHFSCatalogLeafRecord rec : recordsInDir) {
                            CommonHFSCatalogFolderRecord catFolderRec;
                            CommonHFSCatalogFolder catFolder;
                            if (!(rec instanceof CommonHFSCatalogFolderRecord) || (catFolder = (catFolderRec = (CommonHFSCatalogFolderRecord)rec).getData()).getFolderID().toLong() != nextID) continue;
                            nextDir = rec;
                            break;
                        }
                        if (nextDir == null) {
                            HFSExplorer.println("ID not present in dir.");
                            continue;
                        }
                        pathStack.addLast(nextDir.getKey().getNodeName().toString());
                        pathThread.addLast((CommonHFSCatalogFolderRecord)currentDir);
                        currentDir = nextDir;
                        break;
                    }
                    catch (Exception e) {
                        HFSExplorer.println("Invalid input!");
                        continue;
                    }
                }
                if (input.startsWith("cd ")) {
                    if ((input = input.substring("cd ".length())).equals("..")) {
                        pathStack.removeLast();
                        currentDir = (CommonHFSCatalogLeafRecord)pathThread.removeLast();
                        break;
                    }
                    try {
                        CommonHFSCatalogLeafRecord nextDir = null;
                        for (CommonHFSCatalogLeafRecord rec : recordsInDir) {
                            if (!(rec instanceof CommonHFSCatalogFolderRecord)) continue;
                            CommonHFSCatalogFolderRecord folderRec = (CommonHFSCatalogFolderRecord)rec;
                            if (!rec.getKey().getNodeName().toString().equals(input)) continue;
                            nextDir = rec;
                            break;
                        }
                        if (nextDir == null) {
                            HFSExplorer.println("Unknown directory.");
                            continue;
                        }
                        pathStack.addLast(nextDir.getKey().getNodeName().toString());
                        pathThread.addLast((CommonHFSCatalogFolderRecord)currentDir);
                        currentDir = nextDir;
                        break;
                    }
                    catch (Exception e) {
                        HFSExplorer.println("Invalid input!");
                        continue;
                    }
                }
                HFSExplorer.println("Unknown command.");
            }
            HFSExplorer.println();
        }
    }

    private static void operationFragCheck(Operation op, ReadableRandomAccessStream hfsFile, long fsOffset, long fsLength) {
        CommonHFSCatalogFolderRecord rootRecord;
        HFSExplorer.println("Gathering information about the files on the volume...");
        int numberOfFilesToDisplay = 10;
        ArrayList<Pair<CommonHFSCatalogLeafRecord, Integer>> mostFragmentedList = new ArrayList<Pair<CommonHFSCatalogLeafRecord, Integer>>(11);
        ReadableStreamDataLocator inputDataLocator = new ReadableStreamDataLocator(new ReadableConcatenatedStream(hfsFile, fsOffset, fsLength));
        FileSystemMajorType[] fsTypes = FileSystemDetector.detectFileSystem(inputDataLocator);
        FileSystemMajorType hfsType = null;
        block3: for (FileSystemMajorType type : fsTypes) {
            switch (type) {
                case APPLE_HFS: 
                case APPLE_HFS_PLUS: 
                case APPLE_HFSX: {
                    if (hfsType != null) {
                        throw new RuntimeException("Conflicting file system types: Detected both " + (Object)((Object)hfsType) + " and " + (Object)((Object)type) + ".");
                    }
                    hfsType = type;
                    continue block3;
                }
            }
        }
        if (hfsType == null) {
            System.err.println("No HFS file system found.");
            System.exit(1);
        } else {
            System.out.println("Detected a " + (Object)((Object)hfsType) + " file system.");
        }
        FileSystemHandlerFactory fact = hfsType.createDefaultHandlerFactory();
        FileSystemHandler fsHandler = fact.createHandler(inputDataLocator);
        if (!(fsHandler instanceof HFSCommonFileSystemHandler)) {
            throw new RuntimeException("Unexpected HFS fsHandler type: " + fsHandler.getClass());
        }
        HFSCommonFileSystemHandler hfsHandler = (HFSCommonFileSystemHandler)fsHandler;
        HFSVolume fsView = hfsHandler.getFSView();
        CommonHFSCatalogFolderRecord currentDir = rootRecord = fsView.getCatalogFile().getRootFolder();
        HFSExplorer.recursiveFragmentSearch(fsView, rootRecord, mostFragmentedList, 10, HFSExplorer.options.verbose);
        if (!HFSExplorer.options.verbose) {
            HFSExplorer.println();
        }
        HFSExplorer.println("Most fragmented files: ");
        for (Pair<CommonHFSCatalogLeafRecord, Integer> phi : mostFragmentedList) {
            HFSExplorer.println(phi.b + " - \"" + ((CommonHFSCatalogLeafRecord)phi.a).getKey().getNodeName() + "\"");
        }
    }

    private static void recursiveFragmentSearch(HFSVolume fsView, CommonHFSCatalogLeafRecord currentDir, ArrayList<Pair<CommonHFSCatalogLeafRecord, Integer>> mostFragmentedList, int listMaxLength, boolean verbose) {
        for (CommonHFSCatalogLeafRecord rec : fsView.getCatalogFile().listRecords(currentDir)) {
            PrintableStruct catThread;
            if (rec instanceof CommonHFSCatalogFileRecord) {
                CommonHFSCatalogFile catFile = ((CommonHFSCatalogFileRecord)rec).getData();
                CommonHFSExtentDescriptor[] descs = fsView.getExtentsOverflowFile().getAllDataExtentDescriptors(rec);
                mostFragmentedList.add(new Pair<CommonHFSCatalogLeafRecord, Integer>(rec, descs.length));
                for (int i = mostFragmentedList.size() - 1; i > 0; --i) {
                    Pair<CommonHFSCatalogLeafRecord, Integer> lower = mostFragmentedList.get(i);
                    Pair<CommonHFSCatalogLeafRecord, Integer> higher = mostFragmentedList.get(i - 1);
                    if ((Integer)lower.b <= (Integer)higher.b) break;
                    mostFragmentedList.set(i - 1, lower);
                    mostFragmentedList.set(i, higher);
                }
                while (mostFragmentedList.size() > listMaxLength) {
                    mostFragmentedList.remove(mostFragmentedList.size() - 1);
                }
                continue;
            }
            if (rec instanceof CommonHFSCatalogFolderRecord) {
                CommonHFSCatalogFolder catFolder = ((CommonHFSCatalogFolderRecord)rec).getData();
                if (verbose) {
                    HFSExplorer.println("  Processing folder \"" + rec.getKey().getNodeName().toString() + "\"");
                } else {
                    HFSExplorer.print(".");
                }
                HFSExplorer.recursiveFragmentSearch(fsView, rec, mostFragmentedList, listMaxLength, verbose);
                continue;
            }
            if (rec instanceof CommonHFSCatalogFolderThreadRecord) {
                catThread = ((CommonHFSCatalogFolderThreadRecord)rec).getData();
                continue;
            }
            if (rec instanceof CommonHFSCatalogFileThreadRecord) {
                catThread = ((CommonHFSCatalogFileThreadRecord)rec).getData();
                continue;
            }
            throw new RuntimeException("Unknown record type: " + rec.getClass());
        }
    }

    private static void operationSystemFileInfo(Operation op, ReadableRandomAccessStream hfsFile, long fsOffset, long fsLength) {
        String[] labels;
        CommonHFSForkData[] interestingFiles;
        CommonHFSCatalogNodeID.ReservedID[] ids;
        ReadableStreamDataLocator inputDataLocator = new ReadableStreamDataLocator(new ReadableConcatenatedStream(hfsFile, fsOffset, fsLength));
        FileSystemMajorType[] fsTypes = FileSystemDetector.detectFileSystem(inputDataLocator);
        FileSystemMajorType hfsType = null;
        block3: for (FileSystemMajorType type : fsTypes) {
            switch (type) {
                case APPLE_HFS: 
                case APPLE_HFS_PLUS: 
                case APPLE_HFSX: {
                    if (hfsType != null) {
                        throw new RuntimeException("Conflicting file system types: Detected both " + (Object)((Object)hfsType) + " and " + (Object)((Object)type) + ".");
                    }
                    hfsType = type;
                    continue block3;
                }
            }
        }
        if (hfsType == null) {
            System.err.println("No HFS file system found.");
            System.exit(1);
        } else {
            System.out.println("Detected a " + (Object)((Object)hfsType) + " file system.");
        }
        FileSystemHandlerFactory fact = hfsType.createDefaultHandlerFactory();
        FileSystemHandler fsHandler = fact.createHandler(inputDataLocator);
        if (!(fsHandler instanceof HFSCommonFileSystemHandler)) {
            throw new RuntimeException("Unexpected HFS fsHandler type: " + fsHandler.getClass());
        }
        HFSCommonFileSystemHandler hfsHandler = (HFSCommonFileSystemHandler)fsHandler;
        HFSVolume fsView = hfsHandler.getFSView();
        CommonHFSVolumeHeader header = fsView.getVolumeHeader();
        if (header instanceof CommonHFSVolumeHeader.HFSPlusImplementation) {
            CommonHFSVolumeHeader.HFSPlusImplementation plusHeader = (CommonHFSVolumeHeader.HFSPlusImplementation)header;
            ids = new CommonHFSCatalogNodeID.ReservedID[]{CommonHFSCatalogNodeID.ReservedID.ALLOCATION_FILE, CommonHFSCatalogNodeID.ReservedID.EXTENTS_FILE, CommonHFSCatalogNodeID.ReservedID.CATALOG_FILE, CommonHFSCatalogNodeID.ReservedID.ATTRIBUTES_FILE, CommonHFSCatalogNodeID.ReservedID.STARTUP_FILE};
            interestingFiles = new CommonHFSForkData[]{plusHeader.getAllocationFile(), plusHeader.getExtentsOverflowFile(), plusHeader.getCatalogFile(), plusHeader.getAttributesFile(), plusHeader.getStartupFile()};
            labels = new String[]{"Allocation file", "Extents file", "Catalog file", "Attributes file", "Startup file"};
        } else {
            ids = new CommonHFSCatalogNodeID.ReservedID[]{CommonHFSCatalogNodeID.ReservedID.EXTENTS_FILE, CommonHFSCatalogNodeID.ReservedID.CATALOG_FILE};
            interestingFiles = new CommonHFSForkData[]{header.getExtentsOverflowFile(), header.getCatalogFile()};
            labels = new String[]{"Extents file", "Catalog file"};
        }
        for (CommonHFSForkData f : interestingFiles) {
            f.print(System.out, "");
        }
        for (int i = 0; i < interestingFiles.length; ++i) {
            System.out.println(labels[i] + ":");
            CommonHFSForkData currentFile = interestingFiles[i];
            long basicExtentsBlockCount = 0L;
            CommonHFSExtentDescriptor[] basicExtents = currentFile.getBasicExtents();
            long numberOfExtents = 0L;
            for (CommonHFSExtentDescriptor cur : basicExtents) {
                if (cur.getStartBlock() == 0L && cur.getBlockCount() == 0L) break;
                basicExtentsBlockCount += cur.getBlockCount();
                ++numberOfExtents;
            }
            if (currentFile.getLogicalSize() <= basicExtentsBlockCount * header.getAllocationBlockSize()) {
                System.out.println("  Number of extents: " + numberOfExtents + " (all in basic)");
                continue;
            }
            CommonHFSCatalogNodeID.ReservedID currentID = ids[i];
            if (currentID == CommonHFSCatalogNodeID.ReservedID.EXTENTS_FILE) {
                System.out.println("  OVERFLOW IN EXTENTS OVERFLOW FILE!!");
                continue;
            }
            CommonHFSExtentDescriptor[] allDescriptors = fsView.getExtentsOverflowFile().getAllDataExtentDescriptors(fsView.getCommonHFSCatalogNodeID(currentID), currentFile);
            System.out.println("  Number of extents: " + allDescriptors.length + " (overflowed)");
        }
    }

    public static void printUsageInfo() {
        HFSExplorer.println("hfsx - HFSExplorer Command Line Interface");
        HFSExplorer.println("Version 0.22.1 Build #220100");
        HFSExplorer.println(COPYRIGHT);
        HFSExplorer.println();
        HFSExplorer.println("Utility to explore various aspects of an HFS/HFS+/HFSX filesystem.");
        HFSExplorer.println("usage: hfsx [common options] <verb> [verb options] <file/device>");
        HFSExplorer.println();
        HFSExplorer.println("  Common options:");
        HFSExplorer.println("    -apm  Specifies that the HFS partition is embedded within an Apple");
        HFSExplorer.println("          Partition Map. The user will be allowed to choose which partition in");
        HFSExplorer.println("          the map to attempt reading.");
        HFSExplorer.println("    -v    Verbose operation.");
        HFSExplorer.println();
        HFSExplorer.println("  Verbs:");
        HFSExplorer.println("    browse  Launches a mode where the user can browse the files in a HFS+ file");
        HFSExplorer.println("            system.");
        HFSExplorer.println("    chfrag  Lists the 10 most fragmented files of the volume.");
        HFSExplorer.println();
        HFSExplorer.println("  Verb options:");
        HFSExplorer.println("    <none currently defined>");
    }

    public static void println() {
        System.out.println();
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static void vprintln() {
        if (HFSExplorer.options.verbose) {
            System.out.println();
        }
    }

    public static void vprintln(String s) {
        if (HFSExplorer.options.verbose) {
            System.out.println(s);
        }
    }

    public static void vprint(String s) {
        if (HFSExplorer.options.verbose) {
            System.out.print(s);
        }
    }

    public static boolean parseOptions(String[] arguments, int offset, int length) {
        int i;
        String currentArg = null;
        for (i = offset; i < length && (currentArg = arguments[i]).startsWith("-"); ++i) {
            if (currentArg.equals("-apm")) {
                HFSExplorer.options.readAPM = true;
                continue;
            }
            if (currentArg.equals("-v")) {
                HFSExplorer.options.verbose = true;
                continue;
            }
            HFSExplorer.println("\"" + currentArg + "\" is not a valid parameter.");
        }
        if (currentArg.equals("browse")) {
            operation = Operation.BROWSE;
        } else if (currentArg.equals("chfrag")) {
            operation = Operation.FRAGCHECK;
        } else if (currentArg.equals("systemfileinfo")) {
            operation = Operation.SYSTEMFILEINFO;
        } else {
            System.err.println("Unknown operation: " + currentArg);
            return false;
        }
        if (operation != null) {
            ++i;
            while (i < length) {
                operation.addArg(arguments[i]);
                ++i;
            }
        }
        return true;
    }

    static {
        stdIn = new BufferedReader(new InputStreamReader(System.in));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        BROWSE,
        FRAGCHECK,
        TEST,
        SYSTEMFILEINFO;

        private final LinkedList<String> argsList = new LinkedList();

        public void addArg(String argument) {
            this.argsList.add(argument);
        }

        public String[] getArgs() {
            return this.argsList.toArray(new String[this.argsList.size()]);
        }

        public String getFilename() {
            return this.argsList.getLast();
        }
    }

    private static class Options {
        public boolean readAPM = false;
        public boolean verbose = false;

        private Options() {
        }
    }
}

