/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.catacombae.hfsexplorer.Java6Util;
import org.catacombae.hfsexplorer.Pair;
import org.catacombae.hfsexplorer.SpeedUnitUtils;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.gui.FilesystemBrowserPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemBrowser<A> {
    private final FileSystemProvider<A> controller;
    private final FilesystemBrowserPanel viewComponent;
    private final JTextField addressField;
    private final JButton upButton;
    private final JButton extractButton;
    private final JButton infoButton;
    private final JButton goButton;
    private final JLabel statusLabel;
    private final JTable fileTable;
    private final JScrollPane fileTableScroller;
    private final JTree dirTree;
    private final Vector<String> colNames = new Vector();
    private final DefaultTableModel tableModel;
    private long fileTableLastFocus = 0L;
    private long dirTreeLastFocus = 0L;
    private int totalColumnWidth = 0;
    private final DecimalFormat sizeFormat = new DecimalFormat("0.00");
    private final boolean[] disableColumnListener = new boolean[]{false};
    private final ObjectContainer<int[]> lastWidths = new ObjectContainer<Object>(null);
    private DefaultTreeModel treeModel;
    private final GenericPlaceholder<A> genericPlaceholder = new GenericPlaceholder();
    private TreePath lastTreeSelectionPath = null;

    public FileSystemBrowser(FileSystemProvider<A> iController) {
        this.controller = iController;
        this.viewComponent = new FilesystemBrowserPanel();
        this.addressField = this.viewComponent.addressField;
        this.upButton = this.viewComponent.upButton;
        this.infoButton = this.viewComponent.infoButton;
        this.extractButton = this.viewComponent.extractButton;
        this.goButton = this.viewComponent.goButton;
        this.statusLabel = this.viewComponent.statusLabel;
        this.fileTable = this.viewComponent.fileTable;
        this.fileTableScroller = this.viewComponent.fileTableScroller;
        this.dirTree = this.viewComponent.dirTree;
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSystemBrowser.this.actionGotoParentDir();
            }
        });
        this.extractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSystemBrowser.this.actionExtractToDir();
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSystemBrowser.this.actionGetInfo();
            }
        });
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSystemBrowser.this.actionGotoDir();
            }
        });
        this.addressField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSystemBrowser.this.actionGotoDir();
            }
        });
        Class<?> objectClass = new Object().getClass();
        this.colNames.add("Name");
        this.colNames.add("Size");
        this.colNames.add("Type");
        this.colNames.add("Date Modified");
        this.colNames.add("");
        this.tableModel = new DefaultTableModel(this.colNames, 0){

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.fileTable.setModel(this.tableModel);
        this.fileTable.setSelectionMode(2);
        this.fileTable.setAutoResizeMode(0);
        int COLUMN_WIDTH_NAME = 180;
        int COLUMN_WIDTH_SIZE = 96;
        int COLUMN_WIDTH_TYPE = 120;
        int COLUMN_WIDTH_DATE = 130;
        this.fileTable.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.fileTable.getColumnModel().getColumn(1).setPreferredWidth(96);
        this.fileTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.fileTable.getColumnModel().getColumn(3).setPreferredWidth(130);
        this.fileTable.getColumnModel().getColumn(4).setPreferredWidth(0);
        this.totalColumnWidth = 526;
        this.fileTable.getColumnModel().getColumn(4).setMinWidth(0);
        this.fileTable.getColumnModel().getColumn(4).setResizable(false);
        if (Java6Util.isJava6OrHigher()) {
            ComparableComparator c = new ComparableComparator();
            ArrayList rowComparators = new ArrayList(5);
            for (int i = 0; i < 5; ++i) {
                rowComparators.add(c);
            }
            Java6Util.addRowSorter(this.fileTable, this.tableModel, 4, rowComparators);
        }
        TableColumnModelListener columnListener = new TableColumnModelListener(){
            private boolean locked = false;
            private int[] w1 = null;

            public void columnAdded(TableColumnModelEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void columnMarginChanged(ChangeEvent e) {
                if (FileSystemBrowser.this.disableColumnListener[0]) {
                    return;
                }
                7 var2_2 = this;
                synchronized (var2_2) {
                    if (this.locked) {
                        return;
                    }
                    this.locked = true;
                }
                int columnCount = FileSystemBrowser.this.fileTable.getColumnModel().getColumnCount();
                TableColumn lastColumn = FileSystemBrowser.this.fileTable.getColumnModel().getColumn(columnCount - 1);
                if (((FileSystemBrowser)FileSystemBrowser.this).lastWidths.o == null) {
                    ((FileSystemBrowser)FileSystemBrowser.this).lastWidths.o = new int[columnCount];
                }
                if (this.w1 == null || this.w1.length != columnCount) {
                    this.w1 = new int[columnCount];
                }
                int diffSum = 0;
                int currentWidth = 0;
                for (int i = 0; i < this.w1.length; ++i) {
                    this.w1[i] = FileSystemBrowser.this.fileTable.getColumnModel().getColumn(i).getWidth();
                    currentWidth += this.w1[i];
                    int diff = this.w1[i] - ((int[])((FileSystemBrowser)FileSystemBrowser.this).lastWidths.o)[i];
                    if (i >= this.w1.length - 1) continue;
                    diffSum += diff;
                }
                int lastDiff = this.w1[columnCount - 1] - ((int[])((FileSystemBrowser)FileSystemBrowser.this).lastWidths.o)[columnCount - 1];
                if (lastDiff != -diffSum) {
                    int importantColsWidth = currentWidth - this.w1[columnCount - 1];
                    int newLastColumnWidth = FileSystemBrowser.this.totalColumnWidth - importantColsWidth;
                    int nextTotalWidth = importantColsWidth + newLastColumnWidth;
                    if (newLastColumnWidth >= 0) {
                        if (nextTotalWidth <= FileSystemBrowser.this.totalColumnWidth || diffSum > 0) {
                            lastColumn.setPreferredWidth(newLastColumnWidth);
                            lastColumn.setWidth(newLastColumnWidth);
                            FileSystemBrowser.this.fileTableScroller.invalidate();
                            FileSystemBrowser.this.fileTableScroller.validate();
                        }
                    } else if (lastColumn.getWidth() != 0) {
                        lastColumn.setPreferredWidth(0);
                        lastColumn.setWidth(0);
                        FileSystemBrowser.this.fileTableScroller.invalidate();
                        FileSystemBrowser.this.fileTableScroller.validate();
                    }
                }
                for (int i = 0; i < this.w1.length; ++i) {
                    this.w1[i] = FileSystemBrowser.this.fileTable.getColumnModel().getColumn(i).getWidth();
                }
                int[] usedArray = (int[])((FileSystemBrowser)FileSystemBrowser.this).lastWidths.o;
                ((FileSystemBrowser)FileSystemBrowser.this).lastWidths.o = this.w1;
                this.w1 = usedArray;
                7 var8_12 = this;
                synchronized (var8_12) {
                    this.locked = false;
                }
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
        this.fileTable.getColumnModel().addColumnModelListener(columnListener);
        final TableCellRenderer objectRenderer = this.fileTable.getDefaultRenderer(objectClass);
        this.fileTable.setDefaultRenderer(objectClass, new TableCellRenderer(){
            private JLabel theOne = new JLabel();
            private JLabel theTwo = new JLabel("", 4);
            private ImageIcon documentIcon = new ImageIcon(ClassLoader.getSystemResource("res/emptydocument.png"));
            private ImageIcon folderIcon = new ImageIcon(ClassLoader.getSystemResource("res/folder.png"));
            private ImageIcon emptyIcon = new ImageIcon(ClassLoader.getSystemResource("res/nothing.png"));

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof RecordContainer) {
                    final Component objectComponent = objectRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    final JLabel jl = this.theOne;
                    Record rec = ((RecordContainer)value).getRecord(FileSystemBrowser.this.genericPlaceholder);
                    switch (rec.getType()) {
                        case FOLDER: 
                        case FOLDER_LINK: {
                            jl.setIcon(this.folderIcon);
                            break;
                        }
                        case FILE: 
                        case FILE_LINK: {
                            jl.setIcon(this.documentIcon);
                            break;
                        }
                        case BROKEN_LINK: {
                            jl.setIcon(this.emptyIcon);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled RecordType: " + (Object)((Object)rec.getType()));
                        }
                    }
                    jl.setVisible(true);
                    Component c = new Component(){
                        {
                            jl.setSize(jl.getPreferredSize());
                            jl.setLocation(0, 0);
                            objectComponent.setSize(objectComponent.getPreferredSize());
                            objectComponent.setLocation(jl.getWidth(), 0);
                            this.setSize(jl.getWidth() + objectComponent.getWidth(), Math.max(jl.getHeight(), objectComponent.getHeight()));
                        }

                        public void paint(Graphics g) {
                            jl.paint(g);
                            int translatex = jl.getWidth();
                            g.translate(translatex, 0);
                            objectComponent.paint(g);
                            g.translate(-translatex, 0);
                        }
                    };
                    return c;
                }
                if (column == 1) {
                    this.theTwo.setText(value.toString());
                    return this.theTwo;
                }
                return objectRenderer.getTableCellRendererComponent(table, value, false, false, row, column);
            }
        });
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int[] selection = FileSystemBrowser.this.fileTable.getSelectedRows();
                long selectionSize = 0L;
                for (int selectedRow : selection) {
                    Record rec;
                    Object o = FileSystemBrowser.this.fileTable.getValueAt(selectedRow, 0);
                    if (!(o instanceof RecordContainer) || (rec = ((RecordContainer)o).getRecord(FileSystemBrowser.this.genericPlaceholder)).getType() != RecordType.FILE && rec.getType() != RecordType.FILE_LINK) continue;
                    selectionSize += rec.getSize();
                }
                FileSystemBrowser.this.setSelectionStatus(selection.length, selectionSize);
            }
        });
        this.fileTableScroller.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row = FileSystemBrowser.this.fileTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    FileSystemBrowser.this.fileTable.clearSelection();
                }
            }
        });
        this.fileTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = FileSystemBrowser.this.fileTable.rowAtPoint(e.getPoint());
                    int col = FileSystemBrowser.this.fileTable.columnAtPoint(e.getPoint());
                    if (col == 0 && row >= 0) {
                        int[] currentSelection = FileSystemBrowser.this.fileTable.getSelectedRows();
                        if (!Util.contains(currentSelection, row)) {
                            FileSystemBrowser.this.fileTable.clearSelection();
                            FileSystemBrowser.this.fileTable.changeSelection(row, col, false, false);
                        }
                        FileSystemBrowser.this.fileTable.requestFocus();
                        List selection = FileSystemBrowser.this.getTableSelection();
                        List selectionParentPath = FileSystemBrowser.this.getRecordPath(FileSystemBrowser.this.lastTreeSelectionPath);
                        JPopupMenu jpm = FileSystemBrowser.this.controller.getRightClickRecordPopupMenu(selectionParentPath, selection);
                        jpm.show(FileSystemBrowser.this.fileTable, e.getX(), e.getY());
                    }
                } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int row = FileSystemBrowser.this.fileTable.rowAtPoint(e.getPoint());
                    int col = FileSystemBrowser.this.fileTable.columnAtPoint(e.getPoint());
                    if (col == 0 && row >= 0) {
                        Object colValue = FileSystemBrowser.this.fileTable.getValueAt(row, col);
                        if (colValue instanceof RecordContainer) {
                            Record rec = ((RecordContainer)colValue).getRecord(FileSystemBrowser.this.genericPlaceholder);
                            if (rec.getType() == RecordType.FILE || rec.getType() == RecordType.FILE_LINK) {
                                List dirPath = FileSystemBrowser.this.getRecordPath(FileSystemBrowser.this.lastTreeSelectionPath);
                                ArrayList completePath = new ArrayList(dirPath.size() + 1);
                                completePath.addAll(dirPath);
                                completePath.add(rec);
                                FileSystemBrowser.this.controller.actionDoubleClickFile(completePath);
                            } else if (rec.getType() == RecordType.FOLDER || rec.getType() == RecordType.FOLDER_LINK) {
                                FileSystemBrowser.this.actionChangeDir(rec);
                            }
                        } else {
                            throw new RuntimeException("Invalid type in column 0 in fileTable!");
                        }
                    }
                }
            }
        });
        this.dirTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath tp;
                if (e.getButton() == 3 && FileSystemBrowser.this.controller.isFileSystemLoaded() && (tp = FileSystemBrowser.this.dirTree.getPathForLocation(e.getX(), e.getY())) != null) {
                    FileSystemBrowser.this.dirTree.clearSelection();
                    FileSystemBrowser.this.dirTree.setSelectionPath(tp);
                    FileSystemBrowser.this.dirTree.requestFocus();
                    List recList = Collections.singletonList(FileSystemBrowser.this.getTreeSelection());
                    List selectionParentPath = FileSystemBrowser.this.getRecordPath(FileSystemBrowser.this.lastTreeSelectionPath.getParentPath());
                    FileSystemBrowser.this.controller.getRightClickRecordPopupMenu(selectionParentPath, recList).show(FileSystemBrowser.this.dirTree, e.getX(), e.getY());
                }
            }
        });
        this.setRoot(null);
        this.dirTree.getSelectionModel().setSelectionMode(1);
        this.dirTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath tp = e.getPath();
                FileSystemBrowser.this.actionTreeNodeSelected(tp);
            }
        });
        this.dirTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                FileSystemBrowser.this.actionExpandDirTreeNode(e.getPath());
            }

            public void treeWillCollapse(TreeExpansionEvent e) {
            }
        });
        this.fileTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FileSystemBrowser.this.fileTableLastFocus = System.nanoTime();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.dirTree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FileSystemBrowser.this.dirTreeLastFocus = System.nanoTime();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.fileTableScroller.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FileSystemBrowser.this.adjustTableWidth();
            }
        });
    }

    private void actionGotoParentDir() {
        if (this.ensureFileSystemLoaded() && this.lastTreeSelectionPath.getPathCount() > 1) {
            TreePath parentPath = this.lastTreeSelectionPath.getParentPath();
            this.selectInTree(parentPath);
        }
    }

    private void actionExtractToDir() {
        if (this.ensureFileSystemLoaded()) {
            this.controller.actionExtractToDir(this.getSelectionParentPath(), this.getSelection());
        }
    }

    private void actionChangeDir(Record<A> subDir) {
        TreePath currentTreeSelection = this.lastTreeSelectionPath;
        Object objectToPopulate = this.lastTreeSelectionPath.getLastPathComponent();
        if (objectToPopulate instanceof FolderTreeNode) {
            FolderTreeNode nodeToPopulate = (FolderTreeNode)objectToPopulate;
            List<Record<A>> recordPath = this.getRecordPath(currentTreeSelection);
            this.populateTreeNodeFromPath(nodeToPopulate, recordPath);
            this.dirTree.expandPath(this.lastTreeSelectionPath);
            int childCount = this.treeModel.getChildCount(nodeToPopulate);
            Object finalChild = null;
            for (int i = 0; i < childCount; ++i) {
                Object curChild = this.treeModel.getChild(nodeToPopulate, i);
                if (!(curChild instanceof FolderTreeNode) || !((FolderTreeNode)curChild).getRecordContainer().getRecord(this.genericPlaceholder).getName().equals(subDir.getName())) continue;
                TreePath childPath = this.lastTreeSelectionPath.pathByAddingChild(curChild);
                this.selectInTree(childPath);
                finalChild = curChild;
                break;
            }
            if (finalChild == null) {
                throw new RuntimeException("Selection path to leaf child not found!");
            }
        }
    }

    private void actionGetInfo() {
        List<Record<A>> selection;
        if (this.ensureFileSystemLoaded() && (selection = this.getSelection()) != null) {
            this.controller.actionGetInfo(this.getSelectionParentPath(), selection);
        }
    }

    private void actionGotoDir() {
        if (this.ensureFileSystemLoaded()) {
            String targetAddress = this.addressField.getText();
            String[] addressComponents = this.controller.parseAddressPath(targetAddress);
            if (addressComponents != null) {
                this.setCurrentDirectory(addressComponents);
            } else {
                JOptionPane.showMessageDialog(this.viewComponent, "Invalid pathname.", "Error", 0);
            }
        }
    }

    private void actionExpandDirTreeNode(TreePath targetNodePath) {
        if (this.ensureFileSystemLoaded()) {
            try {
                Object objToExpand = targetNodePath.getLastPathComponent();
                if (!(objToExpand instanceof FolderTreeNode)) {
                    throw new RuntimeException("Unexpected node class in tree: " + objToExpand.getClass());
                }
                FolderTreeNode nodeToPopulate = (FolderTreeNode)objToExpand;
                List<Record<A>> recordPath = this.getRecordPath(targetNodePath);
                this.populateTreeNodeFromPath(nodeToPopulate, recordPath);
            }
            catch (Throwable e) {
                this.displayUnhandledException(e);
            }
        }
    }

    private void actionTreeNodeSelected(TreePath selectionPath) {
        if (selectionPath.getLastPathComponent() instanceof FolderTreeNode && this.ensureFileSystemLoaded()) {
            try {
                List<Record<A>> recordPath = this.getRecordPath(selectionPath);
                this.populateTableFromPath(recordPath);
                this.lastTreeSelectionPath = selectionPath;
            }
            catch (Throwable e) {
                this.displayUnhandledException(e);
            }
        }
    }

    private void displayUnhandledException(Throwable e) {
        e.printStackTrace();
        JOptionPane.showMessageDialog(this.viewComponent, e.getClass() + " while populating " + "tree node:\n  " + e.getMessage(), "Error", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Record<A>> getRecordPath(TreePath tp) {
        if (tp == null) {
            return null;
        }
        ArrayList<Record<A>> recordPath = new ArrayList<Record<A>>(tp.getPathCount());
        for (Object obj : tp.getPath()) {
            if (!(obj instanceof FolderTreeNode)) throw new RuntimeException("Unexpected node class in tree: " + obj.getClass());
            FolderTreeNode noLeafMutableTreeNode = (FolderTreeNode)obj;
            Object userObj = noLeafMutableTreeNode.getUserObject();
            if (!(userObj instanceof RecordContainer)) throw new RuntimeException("Unexpected user object class in tree: " + userObj.getClass());
            Record<A> rec = ((RecordContainer)userObj).getRecord(this.genericPlaceholder);
            if (rec.getType() != RecordType.FOLDER && rec.getType() != RecordType.FOLDER_LINK) {
                throw new RuntimeException("Unexpected record type in tree: " + (Object)((Object)rec.getType()));
            }
            recordPath.add(rec);
        }
        return recordPath;
    }

    private void adjustTableWidth() {
        int columnCount = this.fileTable.getColumnModel().getColumnCount();
        int[] w1 = new int[columnCount];
        for (int i = 0; i < w1.length; ++i) {
            w1[i] = this.fileTable.getColumnModel().getColumn(i).getPreferredWidth();
        }
        this.disableColumnListener[0] = true;
        this.fileTable.setAutoResizeMode(3);
        this.fileTableScroller.invalidate();
        this.fileTableScroller.validate();
        int[] w2 = new int[columnCount];
        int newTotalWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            w2[i] = this.fileTable.getColumnModel().getColumn(i).getWidth();
            newTotalWidth += w2[i];
        }
        this.totalColumnWidth = newTotalWidth;
        int newLastColumnWidth = newTotalWidth;
        for (int i = 0; i < w1.length - 1; ++i) {
            newLastColumnWidth -= w1[i];
        }
        if (newLastColumnWidth < 0) {
            newLastColumnWidth = 0;
        }
        this.fileTable.getColumnModel().getColumn(columnCount - 1).setPreferredWidth(newLastColumnWidth);
        this.fileTable.setAutoResizeMode(0);
        this.fileTableScroller.invalidate();
        this.fileTableScroller.validate();
        this.lastWidths.o = null;
        this.disableColumnListener[0] = false;
    }

    private void populateTreeNodeFromPath(FolderTreeNode nodeToPopulate, List<Record<A>> recordPath) {
        List<Record<A>> childRecords = this.controller.getFolderContents(recordPath);
        this.populateTreeNodeFromContents(nodeToPopulate, childRecords);
    }

    private void populateTreeNodeFromContents(FolderTreeNode nodeToPopulate, List<Record<A>> childRecords) {
        LinkedList<Record<A>> remainingRecords = new LinkedList<Record<A>>();
        for (Record<A> childRecord : childRecords) {
            if (childRecord.getType() != RecordType.FOLDER && childRecord.getType() != RecordType.FOLDER_LINK) continue;
            remainingRecords.add(childRecord);
        }
        LinkedList<Record<A>> remainingQueue = remainingRecords;
        ArrayList<FolderTreeNode> currentNodes = new ArrayList<FolderTreeNode>(nodeToPopulate.getChildCount());
        Enumeration<TreeNode> en = nodeToPopulate.children();
        while (en.hasMoreElements()) {
            TreeNode o = en.nextElement();
            if (o instanceof FolderTreeNode) {
                currentNodes.add((FolderTreeNode)o);
                continue;
            }
            throw new RuntimeException("Unexpected child type: " + o.getClass());
        }
        LinkedList nodesToUpdate = new LinkedList();
        LinkedList<FolderTreeNode> nodesToRemove = new LinkedList<FolderTreeNode>();
        LinkedList<Integer> insertedRecordIndices = new LinkedList<Integer>();
        int currentIndex = 0;
        for (FolderTreeNode node : currentNodes) {
            String nodeName = node.getRecordContainer().getRecord(this.genericPlaceholder).getName();
            Record firstRemainingRecord = (Record)remainingQueue.peek();
            while (firstRemainingRecord != null && firstRemainingRecord.getName().compareTo(nodeName) < 0) {
                FolderTreeNode folderTreeNode = new FolderTreeNode(new RecordContainer((Record)remainingQueue.remove()));
                insertedRecordIndices.add(currentIndex);
                nodeToPopulate.insert(folderTreeNode, currentIndex++);
                firstRemainingRecord = (Record)remainingQueue.peek();
            }
            if (firstRemainingRecord != null && firstRemainingRecord.getName().compareTo(nodeName) == 0) {
                nodesToUpdate.add(new Pair(node, remainingQueue.remove()));
            } else {
                nodesToRemove.add(node);
            }
            ++currentIndex;
        }
        while (remainingQueue.peek() != null) {
            FolderTreeNode newNode = new FolderTreeNode(new RecordContainer((Record)remainingQueue.remove()));
            insertedRecordIndices.add(currentIndex);
            nodeToPopulate.insert(newNode, currentIndex++);
        }
        int[] insertedRecordIndicesArray = new int[insertedRecordIndices.size()];
        int i = 0;
        Iterator i$ = insertedRecordIndices.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            insertedRecordIndicesArray[i++] = index;
        }
        if (insertedRecordIndicesArray.length > 0) {
            this.treeModel.nodesWereInserted(nodeToPopulate, insertedRecordIndicesArray);
        }
        Object[] removedChildren = new FolderTreeNode[nodesToRemove.size()];
        int[] removedIndices = new int[removedChildren.length];
        int index = 0;
        Iterator iterator = nodesToRemove.iterator();
        while (iterator.hasNext()) {
            FolderTreeNode node;
            removedChildren[index] = node = (FolderTreeNode)iterator.next();
            removedIndices[index] = nodeToPopulate.getIndex(node);
            if (removedIndices[index] < 0) {
                throw new RuntimeException("INTERNAL ERROR: Can't find node in nodeToPopulate!");
            }
            ++index;
        }
        for (int i2 : removedIndices) {
            nodeToPopulate.remove(i2);
        }
        if (removedIndices.length > 0) {
            this.treeModel.nodesWereRemoved(nodeToPopulate, removedIndices, removedChildren);
        }
        int[] updatedIndices = new int[nodesToUpdate.size()];
        int index2 = 0;
        for (Pair pair : nodesToUpdate) {
            ((FolderTreeNode)pair.a).setUserObject(new RecordContainer((Record)pair.b));
            updatedIndices[index2] = nodeToPopulate.getIndex((TreeNode)pair.a);
            if (updatedIndices[index2] < 0) {
                throw new RuntimeException("INTERNAL ERROR: Can't find node in nodeToPopulate!");
            }
            ++index2;
        }
        if (updatedIndices.length > 0) {
            this.treeModel.nodesChanged(nodeToPopulate, updatedIndices);
        }
    }

    private List<String> asNameList(List<Record<A>> recordList) {
        ArrayList<String> res = new ArrayList<String>();
        for (Record<A> rec : recordList) {
            res.add(rec.getName());
        }
        return res;
    }

    private void populateTableFromPath(List<Record<A>> folderRecordPath) {
        List<Record<A>> childRecords = this.controller.getFolderContents(folderRecordPath);
        List<String> nameList = this.asNameList(folderRecordPath.subList(1, folderRecordPath.size()));
        String displayPath = this.controller.getAddressPath(nameList);
        this.populateTableFromContents(childRecords, displayPath);
    }

    private void populateTableFromContents(List<Record<A>> contents, String displayPath) {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(this.tableModel.getRowCount() - 1);
        }
        DateFormat dti = DateFormat.getDateTimeInstance(3, 3);
        int i = 0;
        for (Record<A> rec : contents) {
            Vector<Comparable> currentRow = new Vector<Comparable>(4);
            currentRow.add(new RecordContainer(rec));
            currentRow.add(new SizeEntry(rec.getSize()));
            currentRow.add(new RecordTypeEntry(rec.getType()));
            currentRow.add(new DateEntry(rec.getModifyDate(), dti));
            currentRow.add(new IndexEntry(i++));
            this.tableModel.addRow(currentRow);
        }
        this.adjustTableWidth();
        this.fileTableScroller.getVerticalScrollBar().setValue(0);
        this.addressField.setText(displayPath);
    }

    public JComponent getViewComponent() {
        return this.viewComponent;
    }

    public List<A> getUserObjectSelection() {
        List<Record<A>> recs = this.getSelection();
        ArrayList<A> result = new ArrayList<A>(recs.size());
        for (Record<A> rec : recs) {
            result.add(rec.getUserObject());
        }
        return result;
    }

    public List<Record<A>> getSelection() {
        List<Record<A>> result;
        if (this.dirTreeLastFocus >= this.fileTableLastFocus) {
            Record<A> treeSelection = this.getTreeSelection();
            if (treeSelection != null) {
                result = new ArrayList<Record<A>>(1);
                result.add(treeSelection);
            } else {
                result = null;
            }
        } else {
            result = this.getTableSelection();
        }
        return result;
    }

    public List<Record<A>> getSelectionParentPath() {
        if (this.dirTreeLastFocus >= this.fileTableLastFocus) {
            return this.getRecordPath(this.lastTreeSelectionPath.getParentPath());
        }
        return this.getRecordPath(this.lastTreeSelectionPath);
    }

    private Record<A> getTreeSelection() {
        Record<A> result;
        Object o = this.lastTreeSelectionPath.getLastPathComponent();
        if (o == null) {
            JOptionPane.showMessageDialog(this.viewComponent, "No file or folder selected.", "Information", 1);
            result = null;
        } else if (o instanceof DefaultMutableTreeNode) {
            Object o2 = ((DefaultMutableTreeNode)o).getUserObject();
            if (o2 instanceof RecordContainer) {
                Record<A> rec;
                result = rec = ((RecordContainer)o2).getRecord(this.genericPlaceholder);
            } else {
                JOptionPane.showMessageDialog(this.viewComponent, "[getTreeSelection()] Unexpected data in tree model: " + o2.getClass() + ". (Internal error, report to " + "developer)", "Error", 0);
                result = null;
            }
        } else {
            JOptionPane.showMessageDialog(this.viewComponent, "[getTreeSelection()] Unexpected tree node type: " + o.getClass() + "! (Internal error, report to developer)", "Error", 0);
            result = null;
        }
        return result;
    }

    private List<Record<A>> getTableSelection() {
        ArrayList<Record<A>> result;
        int[] selectedRows = this.fileTable.getSelectedRows();
        if (selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this.viewComponent, "No file selected.", "Information", 1);
            result = null;
        } else {
            ArrayList<Record<A>> actualResult = new ArrayList<Record<A>>(selectedRows.length);
            for (int i = 0; i < selectedRows.length; ++i) {
                Object o = this.fileTable.getValueAt(selectedRows[i], 0);
                if (!(o instanceof RecordContainer)) {
                    JOptionPane.showMessageDialog(this.viewComponent, "[getTableSelection()] Unexpected data in table model. (Internal error, report to developer)", "Error", 0);
                    actualResult = null;
                    break;
                }
                Record<A> rekk = ((RecordContainer)o).getRecord(this.genericPlaceholder);
                actualResult.add(rekk);
            }
            result = actualResult;
        }
        return result;
    }

    private boolean ensureFileSystemLoaded() {
        if (this.controller.isFileSystemLoaded()) {
            return true;
        }
        JOptionPane.showMessageDialog(this.viewComponent, "No file system loaded.", "Error", 0);
        return false;
    }

    public void setRoot(Record<A> rootRecord) {
        NoLeafMutableTreeNode rootNode;
        ArrayList<Record<A>> rootRecordPath;
        if (rootRecord != null) {
            rootRecordPath = new ArrayList<Record<A>>(1);
            rootRecordPath.add(rootRecord);
            FolderTreeNode rootTreeNode = new FolderTreeNode(new RecordContainer(rootRecord));
            this.populateTreeNodeFromPath(rootTreeNode, rootRecordPath);
            rootNode = rootTreeNode;
        } else {
            rootRecordPath = null;
            rootNode = new NoLeafMutableTreeNode("No file system loaded");
        }
        this.treeModel = new DefaultTreeModel(rootNode);
        this.dirTree.setModel(this.treeModel);
        this.lastTreeSelectionPath = new TreePath(rootNode);
        this.selectInTree(this.lastTreeSelectionPath);
        if (rootRecordPath != null) {
            this.populateTableFromPath(rootRecordPath);
        } else {
            this.populateTableFromContents(new ArrayList<Record<A>>(0), "");
        }
        this.setSelectionStatus(0L, 0L);
    }

    private void selectInTree(TreePath childPath) {
        if (childPath.getPathCount() > 1) {
            this.dirTree.expandPath(childPath.getParentPath());
        }
        this.dirTree.setSelectionPath(childPath);
        this.dirTree.scrollPathToVisible(childPath);
    }

    private void setCurrentDirectory(String[] pathnameComponents) {
        System.err.println("setCurrentDirectory(): printing pathnameComponents");
        for (int i = 0; i < pathnameComponents.length; ++i) {
            System.err.println("  [" + i + "]: " + pathnameComponents[i]);
        }
        Object rootObj = this.treeModel.getRoot();
        if (!(rootObj instanceof FolderTreeNode)) {
            throw new RuntimeException("Unexpected root node class: " + rootObj.getClass());
        }
        FolderTreeNode curNode = (FolderTreeNode)rootObj;
        LinkedList<Record<A>> dirStack = new LinkedList<Record<A>>();
        TreePath treePath = new TreePath(curNode);
        for (String currentComponent : pathnameComponents) {
            dirStack.addLast(curNode.getRecordContainer().getRecord(this.genericPlaceholder));
            this.populateTreeNodeFromPath(curNode, dirStack);
            this.dirTree.expandPath(treePath);
            int childCount = this.treeModel.getChildCount(curNode);
            FolderTreeNode requestedNode = null;
            for (int i = 0; i < childCount; ++i) {
                Object curChild = this.treeModel.getChild(curNode, i);
                if (curChild instanceof FolderTreeNode) {
                    FolderTreeNode curChildNode = (FolderTreeNode)curChild;
                    Record<A> rec = curChildNode.getRecordContainer().getRecord(this.genericPlaceholder);
                    if (!rec.getName().equals(currentComponent)) continue;
                    requestedNode = curChildNode;
                    break;
                }
                throw new RuntimeException("Unexpected tree node class: " + curChild.getClass());
            }
            if (requestedNode == null) {
                JOptionPane.showMessageDialog(this.viewComponent, "No such directory.", "Error", 0);
                return;
            }
            curNode = requestedNode;
            treePath = treePath.pathByAddingChild(curNode);
        }
        System.err.println("setCurrentDirectory(): selecting the following path in tree:");
        for (Object o : treePath.getPath()) {
            System.err.print(" \"" + o.toString() + "\"");
        }
        System.err.println();
        this.selectInTree(treePath);
    }

    private void setSelectionStatus(long selectedFilesCount, long selectionSize) {
        String sizeString = selectionSize >= 1024L ? SpeedUnitUtils.bytesToBinaryUnit(selectionSize, this.sizeFormat) : selectionSize + " bytes";
        this.statusLabel.setText(selectedFilesCount + (selectedFilesCount == 1L ? " object" : " objects") + " selected (" + sizeString + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenericPlaceholder<A> {
        private GenericPlaceholder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectContainer<A> {
        public A o;

        public ObjectContainer(A o) {
            this.o = o;
        }
    }

    private static class FolderTreeNode
    extends NoLeafMutableTreeNode {
        private final RecordContainer rc;

        public FolderTreeNode(RecordContainer o) {
            super(o);
            this.rc = o;
        }

        public RecordContainer getRecordContainer() {
            return this.rc;
        }
    }

    public static class NoLeafMutableTreeNode
    extends DefaultMutableTreeNode {
        public NoLeafMutableTreeNode(Object userObject) {
            super(userObject);
        }

        public boolean isLeaf() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableComparator
    implements Comparator<Comparable<Comparable>> {
        private ComparableComparator() {
        }

        @Override
        public int compare(Comparable<Comparable> o1, Comparable<Comparable> o2) {
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexEntry
    implements Comparable<IndexEntry> {
        private final int index;

        public IndexEntry(int index) {
            this.index = index;
        }

        @Override
        public int compareTo(IndexEntry o) {
            return this.index - o.index;
        }

        public String toString() {
            return "";
        }
    }

    private static class DateEntry
    implements Comparable {
        private final Date date;
        private final String displayString;

        public DateEntry(Date date, DateFormat formatter) {
            this.date = date;
            this.displayString = formatter.format(date);
        }

        public Date getDate() {
            return this.date;
        }

        public String toString() {
            return this.displayString;
        }

        public int compareTo(Object o) {
            if (o instanceof DateEntry) {
                DateEntry de = (DateEntry)o;
                return this.date.compareTo(de.date);
            }
            throw new RuntimeException("Can not compare a DateEntry to a " + o.getClass());
        }
    }

    public static class RecordTypeEntry
    implements Comparable {
        private final RecordType recordType;
        private final String displayString;

        public RecordTypeEntry(RecordType recordType) {
            this.recordType = recordType;
            switch (recordType) {
                case FILE: {
                    this.displayString = "File";
                    break;
                }
                case FOLDER: {
                    this.displayString = "Folder";
                    break;
                }
                case FILE_LINK: {
                    this.displayString = "File (symlink)";
                    break;
                }
                case FOLDER_LINK: {
                    this.displayString = "Folder (symlink)";
                    break;
                }
                case BROKEN_LINK: {
                    this.displayString = "Broken link";
                    break;
                }
                default: {
                    throw new RuntimeException("INTERNAL ERROR: Encountered unexpected record type (" + (Object)((Object)recordType) + ")");
                }
            }
        }

        public RecordType getRecordType() {
            return this.recordType;
        }

        public String toString() {
            return this.displayString;
        }

        private int getPriority() {
            switch (this.recordType) {
                case FOLDER: {
                    return 0;
                }
                case FOLDER_LINK: {
                    return 1;
                }
                case FILE: {
                    return 2;
                }
                case FILE_LINK: {
                    return 3;
                }
                case BROKEN_LINK: {
                    return 4;
                }
            }
            throw new RuntimeException("INTERNAL ERROR: Encountered unexpected record type (" + (Object)((Object)this.recordType) + ")");
        }

        public int compareTo(Object o) {
            if (o instanceof RecordTypeEntry) {
                RecordTypeEntry rte = (RecordTypeEntry)o;
                return this.getPriority() - rte.getPriority();
            }
            throw new RuntimeException("Can not compare a RecordTypeEntry to a " + o.getClass());
        }
    }

    private static class SizeEntry
    implements Comparable {
        private final String presentedSize;
        private final long trueSize;

        public SizeEntry(long trueSize) {
            this.trueSize = trueSize;
            this.presentedSize = SpeedUnitUtils.bytesToBinaryUnit(trueSize);
        }

        public long getSize() {
            return this.trueSize;
        }

        public int compareTo(Object o) {
            if (o instanceof SizeEntry) {
                SizeEntry se = (SizeEntry)o;
                long res = this.trueSize - se.trueSize;
                if (res > 0L) {
                    return 1;
                }
                if (res < 0L) {
                    return -1;
                }
                return 0;
            }
            throw new RuntimeException("Can not compare a SizeEntry with a " + o.getClass());
        }

        public String toString() {
            return this.presentedSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordContainer
    implements Comparable {
        private Record rec;

        private RecordContainer() {
        }

        public RecordContainer(Record rec) {
            this.rec = rec;
        }

        public <T> Record<T> getRecord(GenericPlaceholder<T> placeholder) {
            return this.rec;
        }

        public String toString() {
            return this.rec.getName();
        }

        public int compareTo(Object o) {
            if (o instanceof RecordContainer) {
                RecordContainer rc = (RecordContainer)o;
                return this.toString().compareTo(rc.toString());
            }
            throw new RuntimeException("Can not compare a RecordContainer with a " + o.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FileSystemProvider<A> {
        public void actionDoubleClickFile(List<Record<A>> var1);

        public void actionExtractToDir(List<Record<A>> var1, List<Record<A>> var2);

        public void actionGetInfo(List<Record<A>> var1, List<Record<A>> var2);

        public JPopupMenu getRightClickRecordPopupMenu(List<Record<A>> var1, List<Record<A>> var2);

        public boolean isFileSystemLoaded();

        public List<Record<A>> getFolderContents(List<Record<A>> var1);

        public String getAddressPath(List<String> var1);

        public String[] parseAddressPath(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record<A> {
        private RecordType type;
        private String name;
        private long size;
        private Date modifyDate;
        private A userObject;

        public Record(RecordType iType, String iName, long iSize, Date iModifyDate, A iUserObject) {
            this.type = iType;
            this.name = iName;
            this.size = iSize;
            this.modifyDate = iModifyDate;
            this.userObject = iUserObject;
        }

        public RecordType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public Date getModifyDate() {
            return this.modifyDate;
        }

        public A getUserObject() {
            return this.userObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordType {
        FILE,
        FOLDER,
        FILE_LINK,
        FOLDER_LINK,
        BROKEN_LINK;

    }
}

