/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFile;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogFolder;
import org.catacombae.hfsexplorer.GUIUtil;
import org.catacombae.hfsexplorer.fs.ResourceForkReader;
import org.catacombae.hfsexplorer.gui.FSEntrySummaryPanel;
import org.catacombae.hfsexplorer.gui.FileInfoPanel;
import org.catacombae.hfsexplorer.gui.FolderInfoPanel;
import org.catacombae.hfsexplorer.gui.ResourceForkViewPanel;
import org.catacombae.hfsexplorer.gui.StructViewPanel;
import org.catacombae.storage.fs.FSEntry;
import org.catacombae.storage.fs.FSFile;
import org.catacombae.storage.fs.FSFork;
import org.catacombae.storage.fs.FSForkType;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSFile;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSFolder;
import org.catacombae.storage.fs.hfscommon.HFSCommonFSLink;

public class FileInfoWindow
extends JFrame {
    public FileInfoWindow(FSEntry fsEntry, String[] parentPath) {
        super("Info - " + fsEntry.getName());
        JScrollPane summaryPanelScroller = null;
        JScrollPane infoPanelScroller = null;
        JTabbedPane tabs = new JTabbedPane();
        try {
            FSEntrySummaryPanel summaryPanel = new FSEntrySummaryPanel(this, fsEntry, parentPath);
            summaryPanelScroller = new JScrollPane(summaryPanel, 20, 31);
            tabs.addTab("Summary", summaryPanelScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            StructViewPanel svp;
            JPanel fip;
            JPanel infoPanel = null;
            if (fsEntry instanceof HFSCommonFSFile || fsEntry instanceof HFSCommonFSLink) {
                CommonHFSCatalogFile hfsFile;
                if (fsEntry instanceof HFSCommonFSFile) {
                    hfsFile = ((HFSCommonFSFile)fsEntry).getInternalCatalogFile();
                } else if (fsEntry instanceof HFSCommonFSLink) {
                    hfsFile = ((HFSCommonFSLink)fsEntry).getInternalCatalogFileRecord().getData();
                } else {
                    throw new RuntimeException();
                }
                if (hfsFile instanceof CommonHFSCatalogFile.HFSPlusImplementation) {
                    fip = new FileInfoPanel();
                    ((FileInfoPanel)fip).setFields(((CommonHFSCatalogFile.HFSPlusImplementation)hfsFile).getUnderlying());
                    infoPanel = fip;
                } else {
                    infoPanel = svp = new StructViewPanel("File", hfsFile.getStructElements());
                }
            } else if (fsEntry instanceof HFSCommonFSFolder) {
                CommonHFSCatalogFolder fld = ((HFSCommonFSFolder)fsEntry).getInternalCatalogFolder();
                if (fld instanceof CommonHFSCatalogFolder.HFSPlusImplementation) {
                    fip = new FolderInfoPanel();
                    ((FolderInfoPanel)fip).setFields(((CommonHFSCatalogFolder.HFSPlusImplementation)fld).getUnderlying());
                    infoPanel = fip;
                } else {
                    infoPanel = svp = new StructViewPanel("Folder", fld.getStructElements());
                }
            }
            if (infoPanel != null) {
                infoPanelScroller = new JScrollPane(infoPanel, 20, 31);
                tabs.addTab("Detailed", infoPanelScroller);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            FSFile fsFile;
            FSFork resourceFork;
            if (fsEntry instanceof FSFile && (resourceFork = (fsFile = (FSFile)fsEntry).getForkByType(FSForkType.MACOS_RESOURCE)) != null && resourceFork.getLength() > 0L) {
                ResourceForkReader resffReader = new ResourceForkReader(resourceFork.getReadableRandomAccessStream());
                ResourceForkViewPanel resffPanel = new ResourceForkViewPanel(resffReader);
                tabs.addTab("Resource fork", resffPanel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GUIUtil.displayExceptionDialog(e, 20, this, "Exception while creating ResourceForkViewPanel.");
        }
        this.add((Component)tabs, "Center");
        if (summaryPanelScroller != null) {
            summaryPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        if (infoPanelScroller != null) {
            infoPanelScroller.getVerticalScrollBar().setUnitIncrement(10);
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        int adjustedHeight = width + width / 2;
        if (adjustedHeight < height) {
            this.setSize(width, adjustedHeight);
        }
        this.setLocationRelativeTo(null);
    }
}

