/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.x;

import org.catacombae.hfs.CatalogOperations;
import org.catacombae.hfs.plus.HFSPlusVolume;
import org.catacombae.hfs.types.hfscommon.CommonBTHeaderRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogIndexNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogKey;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafNode;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogLeafRecord;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfs.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfs.types.hfsplus.BTHeaderRec;
import org.catacombae.hfs.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfs.types.hfsplus.HFSUniStr255;
import org.catacombae.hfs.types.hfsx.HFSXCatalogKey;
import org.catacombae.io.ReadableRandomAccessStream;

public class HFSXVolume
extends HFSPlusVolume {
    public HFSXVolume(ReadableRandomAccessStream hfsFile, boolean cachingEnabled) {
        super(hfsFile, cachingEnabled, new HFSXCatalogOperations());
    }

    private static class HFSXCatalogOperations
    implements CatalogOperations {
        private HFSXCatalogOperations() {
        }

        private BTHeaderRec getBTHeaderRec(CommonBTHeaderRecord bthr) {
            if (bthr instanceof CommonBTHeaderRecord.HFSPlusImplementation) {
                return ((CommonBTHeaderRecord.HFSPlusImplementation)bthr).getInternal();
            }
            throw new IllegalArgumentException("Invalid type of bthr: " + bthr);
        }

        public CommonHFSCatalogIndexNode newCatalogIndexNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            BTHeaderRec trueBthr = this.getBTHeaderRec(bthr);
            return CommonHFSCatalogIndexNode.createHFSX(data, offset, nodeSize, trueBthr);
        }

        public CommonHFSCatalogKey newCatalogKey(CommonHFSCatalogNodeID nodeID, CommonHFSCatalogString searchString, CommonBTHeaderRecord bthr) {
            BTHeaderRec trueBthr = this.getBTHeaderRec(bthr);
            return CommonHFSCatalogKey.create(new HFSXCatalogKey(new HFSCatalogNodeID((int)nodeID.toLong()), new HFSUniStr255(searchString.getStructBytes(), 0), trueBthr));
        }

        public CommonHFSCatalogLeafNode newCatalogLeafNode(byte[] data, int offset, int nodeSize, CommonBTHeaderRecord bthr) {
            BTHeaderRec trueBthr = this.getBTHeaderRec(bthr);
            return CommonHFSCatalogLeafNode.createHFSX(data, offset, nodeSize, trueBthr);
        }

        public CommonHFSCatalogLeafRecord newCatalogLeafRecord(byte[] data, int offset, CommonBTHeaderRecord bthr) {
            BTHeaderRec trueBthr = this.getBTHeaderRec(bthr);
            return CommonHFSCatalogLeafRecord.createHFSX(data, offset, offset + data.length, trueBthr);
        }
    }
}

