/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsx;

import org.catacombae.hfs.FastUnicodeCompare;
import org.catacombae.hfs.types.hfsplus.BTHeaderRec;
import org.catacombae.hfs.types.hfsplus.BTKey;
import org.catacombae.hfs.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogKey;
import org.catacombae.hfs.types.hfsplus.HFSUniStr255;
import org.catacombae.util.Util;

public class HFSXCatalogKey
extends HFSPlusCatalogKey {
    private final byte keyCompareType;

    public HFSXCatalogKey(byte[] data, int offset, BTHeaderRec catalogHeaderRec) {
        super(data, offset);
        if (catalogHeaderRec == null) {
            throw new IllegalArgumentException("catalogHeaderRec == null");
        }
        this.keyCompareType = catalogHeaderRec.getKeyCompareType();
        if (this.keyCompareType != -68 && this.keyCompareType != -49) {
            throw new IllegalArgumentException("Illegal key compare type: " + this.keyCompareType);
        }
    }

    public HFSXCatalogKey(HFSCatalogNodeID parentID, HFSUniStr255 nodeName, BTHeaderRec catalogHeaderRec) {
        super(parentID, nodeName);
        if (catalogHeaderRec == null) {
            throw new IllegalArgumentException("catalogHeaderRec == null");
        }
        this.keyCompareType = catalogHeaderRec.getKeyCompareType();
        if (this.keyCompareType != -68 && this.keyCompareType != -49) {
            throw new IllegalArgumentException("Illegal key compare type: " + this.keyCompareType);
        }
    }

    public HFSXCatalogKey(int parentIDInt, String nodeNameString, BTHeaderRec catalogHeaderRec) {
        super(parentIDInt, nodeNameString);
        if (catalogHeaderRec == null) {
            throw new IllegalArgumentException("catalogHeaderRec == null");
        }
        this.keyCompareType = catalogHeaderRec.getKeyCompareType();
        if (this.keyCompareType != -68 && this.keyCompareType != -49) {
            throw new IllegalArgumentException("Illegal key compare type: " + this.keyCompareType);
        }
    }

    public int compareTo(BTKey btk) {
        if (btk instanceof HFSPlusCatalogKey) {
            HFSPlusCatalogKey catKey = (HFSPlusCatalogKey)btk;
            if (Util.unsign(this.getParentID().toInt()) == Util.unsign(catKey.getParentID().toInt())) {
                switch (this.keyCompareType) {
                    case -49: {
                        return FastUnicodeCompare.compare(this.getNodeName().getUnicode(), catKey.getNodeName().getUnicode());
                    }
                    case -68: {
                        return Util.unsignedArrayCompareLex(this.getNodeName().getUnicode(), catKey.getNodeName().getUnicode());
                    }
                }
                throw new RuntimeException("Invalid value in file system structure! keyCompareType = " + this.keyCompareType);
            }
            return super.compareTo(btk);
        }
        return super.compareTo(btk);
    }
}

