/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.util.Util;

public class JournalInfoBlock
implements StaticStruct,
PrintableStruct,
StructElements {
    public static final int kJIJournalInFSMask = 1;
    public static final int kJIJournalOnOtherDeviceMask = 2;
    public static final int kJIJournalNeedInitMask = 4;
    public static final int STRUCTSIZE = 180;
    private int flags;
    private final byte[] deviceSignature = new byte[32];
    private long offset;
    private long size;
    private final byte[] reserved = new byte[128];

    public JournalInfoBlock(byte[] data, int offset) {
        this.flags = Util.readIntBE(data, offset + 0);
        System.arraycopy(data, offset + 4, this.deviceSignature, 0, 32);
        this.offset = Util.readLongBE(data, offset + 36);
        this.size = Util.readLongBE(data, offset + 44);
        System.arraycopy(data, offset + 52, this.reserved, 0, 128);
    }

    public static int length() {
        return 180;
    }

    public int size() {
        return JournalInfoBlock.length();
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int[] getDeviceSignature() {
        return Util.readIntArrayBE(this.deviceSignature);
    }

    public final BigInteger getOffset() {
        return Util.unsign(this.getRawOffset());
    }

    public final BigInteger getSize() {
        return Util.unsign(this.getRawSize());
    }

    public final int[] getReserved() {
        return Util.readIntArrayBE(this.reserved);
    }

    public final long getRawOffset() {
        return this.offset;
    }

    public final long getRawSize() {
        return this.size;
    }

    public boolean getFlagJournalInFS() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean getFlagJournalOnOtherDevice() {
        return (this.getFlags() & 2) != 0;
    }

    public boolean getFlagJournalNeedInit() {
        return (this.getFlags() & 4) != 0;
    }

    public static int getStructSize() {
        return JournalInfoBlock.length();
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " flags: " + this.getFlags());
        ps.println(prefix + " deviceSignature: " + this.getDeviceSignature());
        ps.println(prefix + " offset: " + this.getOffset());
        ps.println(prefix + " size: " + this.getSize());
        ps.println(prefix + " reserved: " + this.getReserved());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "JournalInfoBlock:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[JournalInfoBlock.length()];
        int _offset = 0;
        Util.arrayPutBE(result, _offset, this.flags);
        System.arraycopy(this.deviceSignature, 0, result, _offset += 4, this.deviceSignature.length);
        Util.arrayPutBE(result, _offset += this.deviceSignature.length, this.offset);
        Util.arrayPutBE(result, _offset += 8, this.size);
        System.arraycopy(this.reserved, 0, result, _offset += 8, this.reserved.length);
        _offset += this.reserved.length;
        return result;
    }

    private Field getPrivateField(String name) throws NoSuchFieldException {
        Field f = this.getClass().getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("JournalInfoBlock", "Journal info block, describing the location and size of the journal.");
        try {
            db.addUIntBE("flags", this.getPrivateField("flags"), this, null, null, HEXADECIMAL);
            db.addIntArray("deviceSignature", this.deviceSignature, BITS_32, UNSIGNED, BIG_ENDIAN, null, HEXADECIMAL);
            db.addUIntBE("offset", this.getPrivateField("offset"), this, null, "bytes", DECIMAL);
            db.addUIntBE("size", this.getPrivateField("size"), this, null, "bytes", DECIMAL);
            db.addIntArray("reserved", this.reserved, BITS_32, UNSIGNED, BIG_ENDIAN, null, HEXADECIMAL);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return db.getResult();
    }
}

