/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.util.Util;

public class JournalHeader
implements StaticStruct,
PrintableStruct,
StructElements {
    public static final int JOURNAL_HEADER_MAGIC_BE = 1246645368;
    public static final int ENDIAN_MAGIC_BE = 305419896;
    public static final int JOURNAL_HEADER_MAGIC_LE = 2018266698;
    public static final int ENDIAN_MAGIC_LE = 2018915346;
    public static final int STRUCTSIZE = 44;
    private final boolean littleEndian;
    private int magic;
    private int endian;
    private long start;
    private long end;
    private long size;
    private int blhdrSize;
    private int checksum;
    private int jhdrSize;

    public JournalHeader(byte[] data, int offset) {
        this.magic = Util.readIntBE(data, offset + 0);
        this.endian = Util.readIntBE(data, offset + 4);
        if (this.magic == 1246645368 && this.endian == 305419896) {
            this.littleEndian = false;
            this.start = Util.readLongBE(data, offset + 8);
            this.end = Util.readLongBE(data, offset + 16);
            this.size = Util.readLongBE(data, offset + 24);
            this.blhdrSize = Util.readIntBE(data, offset + 32);
            this.checksum = Util.readIntBE(data, offset + 36);
            this.jhdrSize = Util.readIntBE(data, offset + 40);
        } else if (this.magic == 2018266698 && this.endian == 2018915346) {
            this.littleEndian = true;
            this.magic = Util.byteSwap(this.magic);
            this.endian = Util.byteSwap(this.endian);
            this.start = Util.readLongLE(data, offset + 8);
            this.end = Util.readLongLE(data, offset + 16);
            this.size = Util.readLongLE(data, offset + 24);
            this.blhdrSize = Util.readIntLE(data, offset + 32);
            this.checksum = Util.readIntLE(data, offset + 36);
            this.jhdrSize = Util.readIntLE(data, offset + 40);
        } else {
            throw new RuntimeException("Unrecognized magic '0x" + Util.toHexStringBE(this.magic) + "'.");
        }
    }

    public static int length() {
        return 44;
    }

    public int size() {
        return JournalHeader.length();
    }

    public final boolean isLittleEndian() {
        return this.littleEndian;
    }

    public final long getMagic() {
        return Util.unsign(this.getRawMagic());
    }

    public final long getEndian() {
        return Util.unsign(this.getRawEndian());
    }

    public final BigInteger getStart() {
        return Util.unsign(this.getRawStart());
    }

    public final BigInteger getEnd() {
        return Util.unsign(this.getRawEnd());
    }

    public final BigInteger getSize() {
        return Util.unsign(this.getRawSize());
    }

    public final long getBlhdrSize() {
        return Util.unsign(this.getRawBlhdrSize());
    }

    public final long getChecksum() {
        return Util.unsign(this.getRawChecksum());
    }

    public final long getJhdrSize() {
        return Util.unsign(this.getRawJhdrSize());
    }

    public final int getRawMagic() {
        return this.magic;
    }

    public final int getRawEndian() {
        return this.endian;
    }

    public final long getRawStart() {
        return this.start;
    }

    public final long getRawEnd() {
        return this.end;
    }

    public final long getRawSize() {
        return this.size;
    }

    public final int getRawBlhdrSize() {
        return this.blhdrSize;
    }

    public final int getRawChecksum() {
        return this.checksum;
    }

    public final int getRawJhdrSize() {
        return this.jhdrSize;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " magic: " + this.getMagic());
        ps.println(prefix + " endian: " + this.getEndian());
        ps.println(prefix + " start: " + this.getStart());
        ps.println(prefix + " end: " + this.getEnd());
        ps.println(prefix + " size: " + this.getSize());
        ps.println(prefix + " blhdrSize: " + this.getBlhdrSize());
        ps.println(prefix + " checksum: " + this.getChecksum());
        ps.println(prefix + " jhdrSize: " + this.getJhdrSize());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "JournalHeader:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[JournalHeader.length()];
        int offset = 0;
        if (!this.littleEndian) {
            Util.arrayPutBE(result, offset, this.magic);
            Util.arrayPutBE(result, offset += 4, this.endian);
            Util.arrayPutBE(result, offset += 4, this.start);
            Util.arrayPutBE(result, offset += 8, this.end);
            Util.arrayPutBE(result, offset += 8, this.size);
            Util.arrayPutBE(result, offset += 8, this.blhdrSize);
            Util.arrayPutBE(result, offset += 4, this.checksum);
            Util.arrayPutBE(result, offset += 4, this.jhdrSize);
            offset += 4;
        } else {
            Util.arrayPutLE(result, offset, this.magic);
            Util.arrayPutLE(result, offset += 4, this.endian);
            Util.arrayPutLE(result, offset += 4, this.start);
            Util.arrayPutLE(result, offset += 8, this.end);
            Util.arrayPutLE(result, offset += 8, this.size);
            Util.arrayPutLE(result, offset += 8, this.blhdrSize);
            Util.arrayPutLE(result, offset += 4, this.checksum);
            Util.arrayPutLE(result, offset += 4, this.jhdrSize);
            offset += 4;
        }
        return result;
    }

    private Field getPrivateField(String name) throws NoSuchFieldException {
        Field f = this.getClass().getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("JournalHeader", "Header for the journal data, describing what region of data is valid and other properties.");
        try {
            db.addUIntBE("magic", this.getPrivateField("magic"), this, "Magic", null, HEXADECIMAL);
            db.addUIntBE("endian", this.getPrivateField("endian"), this, "Endian magic", null, HEXADECIMAL);
            db.addUIntBE("start", this.getPrivateField("start"), this, "Oldest transaction offset (start)", "bytes", DECIMAL);
            db.addUIntBE("end", this.getPrivateField("end"), this, "Newest transaction offset (end)", "bytes", DECIMAL);
            db.addUIntBE("size", this.getPrivateField("size"), this, "Journal size", "bytes", DECIMAL);
            db.addUIntBE("blhdrSize", this.getPrivateField("blhdrSize"), this, "Block list header size", "bytes", DECIMAL);
            db.addUIntBE("checksum", this.getPrivateField("checksum"), this, "Journal header checksum", null, HEXADECIMAL);
            db.addUIntBE("jhdrSize", this.getPrivateField("jhdrSize"), this, "Journal header size", "bytes", DECIMAL);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return db.getResult();
    }

    public int calculateChecksum() {
        byte[] data = this.getBytes();
        int cksum = 0;
        data[36] = 0;
        data[37] = 0;
        data[38] = 0;
        data[39] = 0;
        for (int i = 0; i < data.length; ++i) {
            cksum = cksum << 8 ^ cksum + Util.unsign(data[i]);
        }
        return ~cksum;
    }
}

