/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.UnicodeNormalizationToolkit;
import org.catacombae.util.Util;

public class HFSUniStr255
implements StructElements,
PrintableStruct {
    private final byte[] length = new byte[2];
    private final byte[] unicode;

    public HFSUniStr255(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.length, 0, 2);
        this.unicode = new byte[2 * Util.unsign(this.getLength())];
        System.arraycopy(data, offset + 2, this.unicode, 0, this.unicode.length);
    }

    public HFSUniStr255(String unicodeString) {
        char[] unicodeChars = unicodeString.toCharArray();
        if (unicodeChars.length > 255) {
            throw new RuntimeException("String too large.");
        }
        System.arraycopy(Util.toByteArrayBE((short)unicodeChars.length), 0, this.length, 0, 2);
        this.unicode = Util.readByteArrayBE(unicodeChars);
    }

    public int length() {
        return 2 + this.unicode.length;
    }

    public short getLength() {
        return Util.readShortBE(this.length);
    }

    public byte[] getRawUnicode() {
        return Util.createCopy(this.unicode);
    }

    public char[] getUnicode() {
        return Util.readCharArrayBE(this.unicode);
    }

    public String getUnicodeAsDecomposedString() {
        return new String(this.getUnicode());
    }

    public String getUnicodeAsComposedString() {
        return UnicodeNormalizationToolkit.getDefaultInstance().compose(this.getUnicodeAsDecomposedString());
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        System.arraycopy(this.length, 0, result, 0, 2);
        System.arraycopy(this.unicode, 0, result, 2, this.unicode.length);
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " length: " + Util.unsign(this.getLength()));
        ps.println(prefix + " unicode (decomposed): \"" + this.getUnicodeAsDecomposedString() + "\"");
        ps.println(prefix + "           (composed): \"" + this.getUnicodeAsComposedString() + "\"");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSUniStr255:");
        this.printFields(ps, prefix);
    }

    public String toString() {
        return this.getUnicodeAsComposedString();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSUniStr255.class.getSimpleName());
        db.addUIntBE("length", this.length, "Length");
        db.addEncodedString("unicode", this.unicode, "UTF-16BE", "Unicode data");
        return db.getResult();
    }
}

