/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.MutableStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ASCIIStringField;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.hfs.HFSVolumeFinderInfo;
import org.catacombae.hfs.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfs.types.hfsplus.HFSPlusDate;
import org.catacombae.hfs.types.hfsplus.HFSPlusDateField;
import org.catacombae.hfs.types.hfsplus.HFSPlusForkData;
import org.catacombae.util.Util;

public class HFSPlusVolumeHeader
extends MutableStruct
implements PrintableStruct,
StructElements {
    public static final short SIGNATURE_HFS_PLUS = 18475;
    public static final short SIGNATURE_HFSX = 18520;
    private final byte[] signature = new byte[2];
    private final byte[] version = new byte[2];
    private final byte[] attributes = new byte[4];
    private final byte[] lastMountedVersion = new byte[4];
    private final byte[] journalInfoBlock = new byte[4];
    private final byte[] createDate = new byte[4];
    private final byte[] modifyDate = new byte[4];
    private final byte[] backupDate = new byte[4];
    private final byte[] checkedDate = new byte[4];
    private final byte[] fileCount = new byte[4];
    private final byte[] folderCount = new byte[4];
    private final byte[] blockSize = new byte[4];
    private final byte[] totalBlocks = new byte[4];
    private final byte[] freeBlocks = new byte[4];
    private final byte[] nextAllocation = new byte[4];
    private final byte[] rsrcClumpSize = new byte[4];
    private final byte[] dataClumpSize = new byte[4];
    private final HFSCatalogNodeID nextCatalogID;
    private final byte[] writeCount = new byte[4];
    private final byte[] encodingsBitmap = new byte[8];
    private final HFSVolumeFinderInfo finderInfo;
    private final HFSPlusForkData allocationFile;
    private final HFSPlusForkData extentsFile;
    private final HFSPlusForkData catalogFile;
    private final HFSPlusForkData attributesFile;
    private final HFSPlusForkData startupFile;

    public HFSPlusVolumeHeader(byte[] data) {
        this(data, 0);
    }

    public HFSPlusVolumeHeader(byte[] data, int offset) {
        this(false, data, offset);
    }

    private HFSPlusVolumeHeader(boolean mutable, byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.signature, 0, 2);
        System.arraycopy(data, offset + 2, this.version, 0, 2);
        System.arraycopy(data, offset + 4, this.attributes, 0, 4);
        System.arraycopy(data, offset + 8, this.lastMountedVersion, 0, 4);
        System.arraycopy(data, offset + 12, this.journalInfoBlock, 0, 4);
        System.arraycopy(data, offset + 16, this.createDate, 0, 4);
        System.arraycopy(data, offset + 20, this.modifyDate, 0, 4);
        System.arraycopy(data, offset + 24, this.backupDate, 0, 4);
        System.arraycopy(data, offset + 28, this.checkedDate, 0, 4);
        System.arraycopy(data, offset + 32, this.fileCount, 0, 4);
        System.arraycopy(data, offset + 36, this.folderCount, 0, 4);
        System.arraycopy(data, offset + 40, this.blockSize, 0, 4);
        System.arraycopy(data, offset + 44, this.totalBlocks, 0, 4);
        System.arraycopy(data, offset + 48, this.freeBlocks, 0, 4);
        System.arraycopy(data, offset + 52, this.nextAllocation, 0, 4);
        System.arraycopy(data, offset + 56, this.rsrcClumpSize, 0, 4);
        System.arraycopy(data, offset + 60, this.dataClumpSize, 0, 4);
        this.nextCatalogID = mutable ? new HFSCatalogNodeID.Mutable(data, offset + 64) : new HFSCatalogNodeID(data, offset + 64);
        System.arraycopy(data, offset + 68, this.writeCount, 0, 4);
        System.arraycopy(data, offset + 72, this.encodingsBitmap, 0, 4);
        this.finderInfo = mutable ? new HFSVolumeFinderInfo.Mutable(data, offset + 80) : new HFSVolumeFinderInfo(data, offset + 80);
        this.allocationFile = mutable ? new HFSPlusForkData.Mutable(data, offset + 112) : new HFSPlusForkData(data, offset + 112);
        this.extentsFile = mutable ? new HFSPlusForkData.Mutable(data, offset + 192) : new HFSPlusForkData(data, offset + 192);
        this.catalogFile = mutable ? new HFSPlusForkData.Mutable(data, offset + 272) : new HFSPlusForkData(data, offset + 272);
        this.attributesFile = mutable ? new HFSPlusForkData.Mutable(data, offset + 352) : new HFSPlusForkData(data, offset + 352);
        this.startupFile = mutable ? new HFSPlusForkData.Mutable(data, offset + 432) : new HFSPlusForkData(data, offset + 432);
    }

    public HFSPlusVolumeHeader(InputStream is) throws IOException {
        this(Util.fillBuffer(is, new byte[HFSPlusVolumeHeader._getSize()]), 0);
    }

    private static int _getSize() {
        return 512;
    }

    public short getSignature() {
        return Util.readShortBE(this.signature);
    }

    public short getVersion() {
        return Util.readShortBE(this.version);
    }

    public int getAttributes() {
        return Util.readIntBE(this.attributes);
    }

    public int getLastMountedVersion() {
        return Util.readIntBE(this.lastMountedVersion);
    }

    public int getJournalInfoBlock() {
        return Util.readIntBE(this.journalInfoBlock);
    }

    public int getCreateDate() {
        return Util.readIntBE(this.createDate);
    }

    public int getModifyDate() {
        return Util.readIntBE(this.modifyDate);
    }

    public int getBackupDate() {
        return Util.readIntBE(this.backupDate);
    }

    public int getCheckedDate() {
        return Util.readIntBE(this.checkedDate);
    }

    public int getFileCount() {
        return Util.readIntBE(this.fileCount);
    }

    public int getFolderCount() {
        return Util.readIntBE(this.folderCount);
    }

    public int getBlockSize() {
        return Util.readIntBE(this.blockSize);
    }

    public int getTotalBlocks() {
        return Util.readIntBE(this.totalBlocks);
    }

    public int getFreeBlocks() {
        return Util.readIntBE(this.freeBlocks);
    }

    public int getNextAllocation() {
        return Util.readIntBE(this.nextAllocation);
    }

    public int getRsrcClumpSize() {
        return Util.readIntBE(this.rsrcClumpSize);
    }

    public int getDataClumpSize() {
        return Util.readIntBE(this.dataClumpSize);
    }

    public HFSCatalogNodeID getNextCatalogID() {
        return this.nextCatalogID;
    }

    public int getWriteCount() {
        return Util.readIntBE(this.writeCount);
    }

    public long getEncodingsBitmap() {
        return Util.readLongBE(this.encodingsBitmap);
    }

    public HFSVolumeFinderInfo getFinderInfo() {
        return this.finderInfo;
    }

    public HFSPlusForkData getAllocationFile() {
        return this.allocationFile;
    }

    public HFSPlusForkData getExtentsFile() {
        return this.extentsFile;
    }

    public HFSPlusForkData getCatalogFile() {
        return this.catalogFile;
    }

    public HFSPlusForkData getAttributesFile() {
        return this.attributesFile;
    }

    public HFSPlusForkData getStartupFile() {
        return this.startupFile;
    }

    public Date getCreateDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getCreateDate());
    }

    public Date getModifyDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getModifyDate());
    }

    public Date getBackupDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getBackupDate());
    }

    public Date getCheckedDateAsDate() {
        return HFSPlusDate.localTimestampToDate(this.getCheckedDate());
    }

    public boolean getAttributeVolumeHardwareLock() {
        return (this.getAttributes() >> 7 & 1) != 0;
    }

    public boolean getAttributeVolumeUnmounted() {
        return (this.getAttributes() >> 8 & 1) != 0;
    }

    public boolean getAttributeVolumeSparedBlocks() {
        return (this.getAttributes() >> 9 & 1) != 0;
    }

    public boolean getAttributeVolumeNoCacheRequired() {
        return (this.getAttributes() >> 10 & 1) != 0;
    }

    public boolean getAttributeBootVolumeInconsistent() {
        return (this.getAttributes() >> 11 & 1) != 0;
    }

    public boolean getAttributeCatalogNodeIDsReused() {
        return (this.getAttributes() >> 12 & 1) != 0;
    }

    public boolean getAttributeVolumeJournaled() {
        return (this.getAttributes() >> 13 & 1) != 0;
    }

    public boolean getAttributeVolumeSoftwareLock() {
        return (this.getAttributes() >> 15 & 1) != 0;
    }

    private void _printFields(PrintStream ps, String prefix) {
        ps.println(prefix + "signature: \"" + Util.toASCIIString(this.getSignature()) + "\"");
        ps.println(prefix + "version: " + this.getVersion());
        ps.println(prefix + "attributes: " + this.getAttributes());
        this.printAttributes(ps, prefix + "  ");
        ps.println(prefix + "lastMountedVersion: " + this.getLastMountedVersion());
        ps.println(prefix + "journalInfoBlock: " + this.getJournalInfoBlock());
        ps.println(prefix + "createDate: " + this.getCreateDateAsDate());
        ps.println(prefix + "modifyDate: " + this.getModifyDateAsDate());
        ps.println(prefix + "backupDate: " + this.getBackupDateAsDate());
        ps.println(prefix + "checkedDate: " + this.getCheckedDateAsDate());
        ps.println(prefix + "fileCount: " + this.getFileCount());
        ps.println(prefix + "folderCount: " + this.getFolderCount());
        ps.println(prefix + "blockSize: " + this.getBlockSize());
        ps.println(prefix + "totalBlocks: " + this.getTotalBlocks());
        ps.println(prefix + "freeBlocks: " + this.getFreeBlocks());
        ps.println(prefix + "nextAllocation: " + this.getNextAllocation());
        ps.println(prefix + "rsrcClumpSize: " + this.getRsrcClumpSize());
        ps.println(prefix + "dataClumpSize: " + this.getDataClumpSize());
        ps.println(prefix + "nextCatalogID: " + this.getNextCatalogID().toString());
        ps.println(prefix + "writeCount: " + this.getWriteCount());
        ps.println(prefix + "encodingsBitmap: " + this.getEncodingsBitmap());
        ps.println(prefix + "encodingsBitmap (hex): 0x" + Util.toHexStringBE(this.getEncodingsBitmap()));
        ps.println(prefix + "finderInfo:");
        this.finderInfo.printFields(ps, prefix + "  ");
        ps.println(prefix + "allocationFile: ");
        this.allocationFile.print(ps, prefix + "  ");
        ps.println(prefix + "extentsFile: ");
        this.extentsFile.print(ps, prefix + "  ");
        ps.println(prefix + "catalogFile: ");
        this.catalogFile.print(ps, prefix + "  ");
        ps.println(prefix + "attributesFile: ");
        this.attributesFile.print(ps, prefix + "  ");
        ps.println(prefix + "startupFile: ");
        this.startupFile.print(ps, prefix + "  ");
    }

    public void printFields(PrintStream ps, String prefix) {
        this._printFields(ps, prefix + " ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusVolumeHeader:");
        this._printFields(ps, prefix + " ");
    }

    public void printAttributes(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
        this.printAttributes(ps, pregapString);
    }

    public void printAttributes(PrintStream ps, String prefix) {
        int attributesInt = this.getAttributes();
        ps.println(prefix + "kHFSVolumeHardwareLockBit = " + (attributesInt >> 7 & 1));
        ps.println(prefix + "kHFSVolumeUnmountedBit = " + (attributesInt >> 8 & 1));
        ps.println(prefix + "kHFSVolumeSparedBlocksBit = " + (attributesInt >> 9 & 1));
        ps.println(prefix + "kHFSVolumeNoCacheRequiredBit = " + (attributesInt >> 10 & 1));
        ps.println(prefix + "kHFSBootVolumeInconsistentBit = " + (attributesInt >> 11 & 1));
        ps.println(prefix + "kHFSCatalogNodeIDsReusedBit = " + (attributesInt >> 12 & 1));
        ps.println(prefix + "kHFSVolumeJournaledBit = " + (attributesInt >> 13 & 1));
        ps.println(prefix + "kHFSVolumeSoftwareLockBit = " + (attributesInt >> 15 & 1));
    }

    private Dictionary getAttributeElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("Attributes");
        db.addFlag("kHFSVolumeHardwareLockBit", this.attributes, 7, "Volume hardware lock");
        db.addFlag("kHFSVolumeUnmountedBit", this.attributes, 8, "Volume unmounted");
        db.addFlag("kHFSVolumeSparedBlocksBit", this.attributes, 9, "Volume spared blocks");
        db.addFlag("kHFSVolumeNoCacheRequiredBit", this.attributes, 10, "No cache required");
        db.addFlag("kHFSBootVolumeInconsistentBit", this.attributes, 11, "Boot volume inconsistent");
        db.addFlag("kHFSCatalogNodeIDsReusedBit", this.attributes, 12, "Catalog node IDs reused");
        db.addFlag("kHFSVolumeJournaledBit", this.attributes, 13, "Volume journaled");
        db.addFlag("kHFSVolumeSoftwareLockBit", this.attributes, 15, "Volume software lock");
        return db.getResult();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusVolumeHeader.class.getSimpleName());
        db.add("signature", new ASCIIStringField(this.signature), "Volume signature");
        db.addUIntBE("version", this.version, "File system version");
        db.add("attributes", this.getAttributeElements(), "Attributes");
        db.add("lastMountedVersion", new ASCIIStringField(this.lastMountedVersion), "Last mounted version");
        db.addUIntBE("journalInfoBlock", this.journalInfoBlock, "Journal info block ID");
        db.add("createDate", new HFSPlusDateField(this.createDate, true), "Date created");
        db.add("modifyDate", new HFSPlusDateField(this.modifyDate, true), "Date last modified");
        db.add("backupDate", new HFSPlusDateField(this.backupDate, true), "Date last backuped");
        db.add("checkedDate", new HFSPlusDateField(this.checkedDate, true), "Date last checked");
        db.addUIntBE("fileCount", this.fileCount, "File count");
        db.addUIntBE("folderCount", this.folderCount, "Folder count");
        db.addUIntBE("blockSize", this.blockSize, "Block size", "bytes");
        db.addUIntBE("totalBlocks", this.totalBlocks, "Number of blocks");
        db.addUIntBE("freeBlocks", this.freeBlocks, "Number of free blocks");
        db.addUIntBE("nextAllocation", this.nextAllocation, "Start of next allocation search");
        db.addUIntBE("rsrcClumpSize", this.rsrcClumpSize, "Resource fork default clump size", "bytes");
        db.addUIntBE("dataClumpSize", this.dataClumpSize, "Data fork default clump size", "bytes");
        db.add("nextCatalogID", this.nextCatalogID.getOpaqueStructElement(), "Next unused catalog ID");
        db.addUIntBE("writeCount", this.writeCount, "Write count");
        db.addUIntBE("encodingsBitmap", this.encodingsBitmap, "Encodings bitmap", IntegerFieldRepresentation.HEXADECIMAL);
        db.add("finderInfo", this.finderInfo.getStructElements(), "Finder info");
        db.add("allocationFile", this.allocationFile.getStructElements(), "Allocation file");
        db.add("extentsFile", this.extentsFile.getStructElements(), "Extents file");
        db.add("catalogFile", this.catalogFile.getStructElements(), "Catalog file");
        db.add("attributesFile", this.attributesFile.getStructElements(), "Attributes file");
        db.add("startupFile", this.startupFile.getStructElements(), "Startup file");
        return db.getResult();
    }

    public boolean isValid() {
        short sig = this.getSignature();
        return sig == 18475 || sig == 18520;
    }

    private void _setSignature(short signature) {
        Util.arrayPutBE(this.signature, 0, signature);
    }

    private void _setVersion(short version) {
        Util.arrayPutBE(this.version, 0, version);
    }

    private void _setAttributes(int attributes) {
        Util.arrayPutBE(this.attributes, 0, attributes);
    }

    private void _setLastMountedVersion(int lastMountedVersion) {
        Util.arrayPutBE(this.lastMountedVersion, 0, lastMountedVersion);
    }

    private void _setJournalInfoBlock(int journalInfoBlock) {
        Util.arrayPutBE(this.journalInfoBlock, 0, journalInfoBlock);
    }

    private void _setCreateDate(int createDate) {
        Util.arrayPutBE(this.createDate, 0, createDate);
    }

    private void _setModifyDate(int modifyDate) {
        Util.arrayPutBE(this.modifyDate, 0, modifyDate);
    }

    private void _setBackupDate(int backupDate) {
        Util.arrayPutBE(this.backupDate, 0, backupDate);
    }

    private void _setCheckedDate(int checkedDate) {
        Util.arrayPutBE(this.checkedDate, 0, checkedDate);
    }

    private void _setFileCount(int fileCount) {
        Util.arrayPutBE(this.fileCount, 0, fileCount);
    }

    private void _setFolderCount(int folderCount) {
        Util.arrayPutBE(this.folderCount, 0, folderCount);
    }

    private void _setBlockSize(int blockSize) {
        Util.arrayPutBE(this.blockSize, 0, blockSize);
    }

    private void _setTotalBlocks(int totalBlocks) {
        Util.arrayPutBE(this.totalBlocks, 0, totalBlocks);
    }

    private void _setFreeBlocks(int freeBlocks) {
        Util.arrayPutBE(this.freeBlocks, 0, freeBlocks);
    }

    private void _setNextAllocation(int nextAllocation) {
        Util.arrayPutBE(this.nextAllocation, 0, nextAllocation);
    }

    private void _setRsrcClumpSize(int rsrcClumpSize) {
        Util.arrayPutBE(this.rsrcClumpSize, 0, rsrcClumpSize);
    }

    private void _setDataClumpSize(int dataClumpSize) {
        Util.arrayPutBE(this.dataClumpSize, 0, dataClumpSize);
    }

    private HFSCatalogNodeID.Mutable _getMutableNextCatalogID() {
        return (HFSCatalogNodeID.Mutable)this.nextCatalogID;
    }

    private void _setNextCatalogID(HFSCatalogNodeID nextCatalogID) {
        this._getMutableNextCatalogID().setValue(nextCatalogID.toInt());
    }

    private void _setWriteCount(int writeCount) {
        Util.arrayPutBE(this.writeCount, 0, writeCount);
    }

    private void _setEncodingsBitmap(long encodingsBitmap) {
        Util.arrayPutBE(this.encodingsBitmap, 0, encodingsBitmap);
    }

    private HFSVolumeFinderInfo.Mutable _getMutableFinderInfo() {
        return (HFSVolumeFinderInfo.Mutable)this.finderInfo;
    }

    private void _setFinderInfo(HFSVolumeFinderInfo finderInfo) {
        this._getMutableFinderInfo().set(finderInfo);
    }

    private HFSPlusForkData.Mutable _getMutableAllocationFile() {
        return (HFSPlusForkData.Mutable)this.allocationFile;
    }

    private void _setAllocationFile(HFSPlusForkData allocationFile) {
        this._getMutableAllocationFile().set(allocationFile);
    }

    private HFSPlusForkData.Mutable _getMutableExtentsFile() {
        return (HFSPlusForkData.Mutable)this.extentsFile;
    }

    private void _setExtentsFile(HFSPlusForkData extentsFile) {
        this._getMutableExtentsFile().set(extentsFile);
    }

    private HFSPlusForkData.Mutable _getMutableCatalogFile() {
        return (HFSPlusForkData.Mutable)this.catalogFile;
    }

    private void _setCatalogFile(HFSPlusForkData catalogFile) {
        this._getMutableCatalogFile().set(catalogFile);
    }

    private HFSPlusForkData.Mutable _getMutableAttributesFile() {
        return (HFSPlusForkData.Mutable)this.attributesFile;
    }

    private void _setAttributesFile(HFSPlusForkData attributesFile) {
        this._getMutableAttributesFile().set(attributesFile);
    }

    private HFSPlusForkData.Mutable _getMutableStartupFile() {
        return (HFSPlusForkData.Mutable)this.startupFile;
    }

    private void _setStartupFile(HFSPlusForkData startupFile) {
        this._getMutableStartupFile().set(startupFile);
    }

    private void _set(HFSPlusVolumeHeader header) {
        Util.arrayCopy(header.signature, this.signature);
        Util.arrayCopy(header.version, this.version);
        Util.arrayCopy(header.attributes, this.attributes);
        Util.arrayCopy(header.lastMountedVersion, this.lastMountedVersion);
        Util.arrayCopy(header.journalInfoBlock, this.journalInfoBlock);
        Util.arrayCopy(header.createDate, this.createDate);
        Util.arrayCopy(header.modifyDate, this.modifyDate);
        Util.arrayCopy(header.backupDate, this.backupDate);
        Util.arrayCopy(header.checkedDate, this.checkedDate);
        Util.arrayCopy(header.fileCount, this.fileCount);
        Util.arrayCopy(header.folderCount, this.folderCount);
        Util.arrayCopy(header.blockSize, this.blockSize);
        Util.arrayCopy(header.totalBlocks, this.totalBlocks);
        Util.arrayCopy(header.freeBlocks, this.freeBlocks);
        Util.arrayCopy(header.nextAllocation, this.nextAllocation);
        Util.arrayCopy(header.rsrcClumpSize, this.rsrcClumpSize);
        Util.arrayCopy(header.dataClumpSize, this.dataClumpSize);
        this._setNextCatalogID(header.nextCatalogID);
        Util.arrayCopy(header.writeCount, this.writeCount);
        Util.arrayCopy(header.encodingsBitmap, this.encodingsBitmap);
        this._setFinderInfo(header.finderInfo);
        this._setAllocationFile(header.allocationFile);
        this._setExtentsFile(header.extentsFile);
        this._setCatalogFile(header.catalogFile);
        this._setAttributesFile(header.attributesFile);
        this._setStartupFile(header.startupFile);
    }

    public static class Mutable
    extends HFSPlusVolumeHeader {
        public Mutable(byte[] data) {
            super(data);
        }

        public Mutable(byte[] data, int offset) {
            super(data, offset);
        }

        public Mutable(InputStream is) throws IOException {
            super(is);
        }

        public void set(HFSPlusVolumeHeader header) {
            ((HFSPlusVolumeHeader)this)._set(header);
        }

        public void setSignature(short signature) {
            ((HFSPlusVolumeHeader)this)._setSignature(signature);
        }

        public void setVersion(short version) {
            ((HFSPlusVolumeHeader)this)._setVersion(version);
        }

        public void setAttributes(int attributes) {
            ((HFSPlusVolumeHeader)this)._setAttributes(attributes);
        }

        public void setLastMountedVersion(int lastMountedVersion) {
            ((HFSPlusVolumeHeader)this)._setLastMountedVersion(lastMountedVersion);
        }

        public void setJournalInfoBlock(int journalInfoBlock) {
            ((HFSPlusVolumeHeader)this)._setJournalInfoBlock(journalInfoBlock);
        }

        public void setCreateDate(int createDate) {
            ((HFSPlusVolumeHeader)this)._setCreateDate(createDate);
        }

        public void setModifyDate(int modifyDate) {
            ((HFSPlusVolumeHeader)this)._setModifyDate(modifyDate);
        }

        public void setBackupDate(int backupDate) {
            ((HFSPlusVolumeHeader)this)._setBackupDate(backupDate);
        }

        public void setCheckedDate(int checkedDate) {
            ((HFSPlusVolumeHeader)this)._setCheckedDate(checkedDate);
        }

        public void setFileCount(int fileCount) {
            ((HFSPlusVolumeHeader)this)._setFileCount(fileCount);
        }

        public void setFolderCount(int folderCount) {
            ((HFSPlusVolumeHeader)this)._setFolderCount(folderCount);
        }

        public void setBlockSize(int blockSize) {
            ((HFSPlusVolumeHeader)this)._setBlockSize(blockSize);
        }

        public void setTotalBlocks(int totalBlocks) {
            ((HFSPlusVolumeHeader)this)._setTotalBlocks(totalBlocks);
        }

        public void setFreeBlocks(int freeBlocks) {
            ((HFSPlusVolumeHeader)this)._setFreeBlocks(freeBlocks);
        }

        public void setNextAllocation(int nextAllocation) {
            ((HFSPlusVolumeHeader)this)._setNextAllocation(nextAllocation);
        }

        public void setRsrcClumpSize(int rsrcClumpSize) {
            ((HFSPlusVolumeHeader)this)._setRsrcClumpSize(rsrcClumpSize);
        }

        public void setDataClumpSize(int dataClumpSize) {
            ((HFSPlusVolumeHeader)this)._setDataClumpSize(dataClumpSize);
        }

        public HFSCatalogNodeID.Mutable getMutableNextCatalogID() {
            return ((HFSPlusVolumeHeader)this)._getMutableNextCatalogID();
        }

        public void setNextCatalogID(HFSCatalogNodeID nextCatalogID) {
            ((HFSPlusVolumeHeader)this)._setNextCatalogID(nextCatalogID);
        }

        public void setWriteCount(int writeCount) {
            ((HFSPlusVolumeHeader)this)._setWriteCount(writeCount);
        }

        public void setEncodingsBitmap(long encodingsBitmap) {
            ((HFSPlusVolumeHeader)this)._setEncodingsBitmap(encodingsBitmap);
        }

        public void setFinderInfo(HFSVolumeFinderInfo finderInfo) {
            ((HFSPlusVolumeHeader)this)._setFinderInfo(finderInfo);
        }

        public HFSPlusForkData.Mutable getMutableAllocationFile() {
            return ((HFSPlusVolumeHeader)this)._getMutableAllocationFile();
        }

        public void setAllocationFile(HFSPlusForkData allocationFile) {
            ((HFSPlusVolumeHeader)this)._setAllocationFile(allocationFile);
        }

        public HFSPlusForkData.Mutable getMutableExtentsFile() {
            return ((HFSPlusVolumeHeader)this)._getMutableExtentsFile();
        }

        public void setExtentsFile(HFSPlusForkData extentsFile) {
            ((HFSPlusVolumeHeader)this)._setExtentsFile(extentsFile);
        }

        public HFSPlusForkData.Mutable getMutableCatalogFile() {
            return ((HFSPlusVolumeHeader)this)._getMutableCatalogFile();
        }

        public void setCatalogFile(HFSPlusForkData catalogFile) {
            ((HFSPlusVolumeHeader)this)._setCatalogFile(catalogFile);
        }

        public HFSPlusForkData.Mutable getMutableAttributesFile() {
            return ((HFSPlusVolumeHeader)this)._getMutableAttributesFile();
        }

        public void setAttributesFile(HFSPlusForkData attributesFile) {
            ((HFSPlusVolumeHeader)this)._setAttributesFile(attributesFile);
        }

        public HFSPlusForkData.Mutable getMutableStartupFile() {
            return ((HFSPlusVolumeHeader)this)._getMutableStartupFile();
        }

        public void setStartupFile(HFSPlusForkData startupFile) {
            ((HFSPlusVolumeHeader)this)._setStartupFile(startupFile);
        }
    }
}

