/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentRecord;
import org.catacombae.util.Util;

public class HFSPlusForkData
implements StructElements,
PrintableStruct {
    private final byte[] logicalSize = new byte[8];
    private final byte[] clumpSize = new byte[4];
    private final byte[] totalBlocks = new byte[4];
    private final HFSPlusExtentRecord extents;

    public HFSPlusForkData(byte[] data, int offset) {
        this(false, data, offset);
    }

    private HFSPlusForkData(boolean mutable, byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.logicalSize, 0, 8);
        System.arraycopy(data, offset + 8, this.clumpSize, 0, 4);
        System.arraycopy(data, offset + 12, this.totalBlocks, 0, 4);
        this.extents = mutable ? new HFSPlusExtentRecord.Mutable(data, offset + 16) : new HFSPlusExtentRecord(data, offset + 16);
    }

    public static int length() {
        return 80;
    }

    public long getLogicalSize() {
        return Util.readLongBE(this.logicalSize);
    }

    public int getClumpSize() {
        return Util.readIntBE(this.clumpSize);
    }

    public int getTotalBlocks() {
        return Util.readIntBE(this.totalBlocks);
    }

    public HFSPlusExtentRecord getExtents() {
        return this.extents;
    }

    public void print(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
        this.print(ps, pregapString);
    }

    private void _printFields(PrintStream ps, String prefix) {
        ps.println(prefix + "logicalSize: " + this.getLogicalSize());
        ps.println(prefix + "clumpSize: " + this.getClumpSize());
        ps.println(prefix + "totalBlocks: " + this.getTotalBlocks());
        ps.println(prefix + "extents:");
        this.extents.print(ps, prefix + "  ");
    }

    public void printFields(PrintStream ps, String prefix) {
        this._printFields(ps, prefix + " ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusForkData:");
        this._printFields(ps, prefix + " ");
    }

    byte[] getBytes() {
        byte[] result = new byte[HFSPlusForkData.length()];
        int offset = 0;
        System.arraycopy(this.logicalSize, 0, result, offset, this.logicalSize.length);
        System.arraycopy(this.clumpSize, 0, result, offset += this.logicalSize.length, this.clumpSize.length);
        System.arraycopy(this.totalBlocks, 0, result, offset += this.clumpSize.length, this.totalBlocks.length);
        byte[] tempData = this.extents.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.totalBlocks.length, tempData.length);
        offset += tempData.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusForkData.class.getSimpleName());
        db.addUIntBE("logicalSize", this.logicalSize, "Logical size", "bytes");
        db.addUIntBE("clumpSize", this.clumpSize, "Clump size", "bytes");
        db.addUIntBE("totalBlocks", this.totalBlocks, "Total blocks");
        db.add("extents", this.extents.getStructElement(), "Extents");
        return db.getResult();
    }

    private void _setLogicalSize(long logicalSize) {
        Util.arrayPutBE(this.logicalSize, 0, logicalSize);
    }

    private void _setClumpSize(int clumpSize) {
        Util.arrayPutBE(this.clumpSize, 0, clumpSize);
    }

    private void _setTotalBlocks(int totalBlocks) {
        Util.arrayPutBE(this.totalBlocks, 0, totalBlocks);
    }

    private void _setExtents(HFSPlusExtentRecord extents) {
        ((HFSPlusExtentRecord.Mutable)this.extents).set(extents);
    }

    private void _set(HFSPlusForkData forkData) {
        Util.arrayCopy(forkData.logicalSize, this.logicalSize);
        Util.arrayCopy(forkData.clumpSize, this.clumpSize);
        Util.arrayCopy(forkData.totalBlocks, this.totalBlocks);
        this._setExtents(forkData.extents);
    }

    private HFSPlusExtentRecord.Mutable _getMutableExtents() {
        return (HFSPlusExtentRecord.Mutable)this.extents;
    }

    public static class Mutable
    extends HFSPlusForkData {
        public Mutable(byte[] data, int offset) {
            super(data, offset);
        }

        public void set(HFSPlusForkData forkData) {
            ((HFSPlusForkData)this)._set(forkData);
        }

        public void setLogicalSize(long logicalSize) {
            ((HFSPlusForkData)this)._setLogicalSize(logicalSize);
        }

        public void setClumpSize(int clumpSize) {
            ((HFSPlusForkData)this)._setClumpSize(clumpSize);
        }

        public void setTotalBlocks(int totalBlocks) {
            ((HFSPlusForkData)this)._setTotalBlocks(totalBlocks);
        }

        public void setExtents(HFSPlusExtentRecord extents) {
            ((HFSPlusForkData)this)._setExtents(extents);
        }

        public HFSPlusExtentRecord.Mutable getMutableExtents() {
            return ((HFSPlusForkData)this)._getMutableExtents();
        }
    }
}

