/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.structelements.Array;
import org.catacombae.csjc.structelements.ArrayBuilder;
import org.catacombae.hfs.types.hfsplus.HFSPlusExtentDescriptor;

public class HFSPlusExtentRecord
implements PrintableStruct {
    private final HFSPlusExtentDescriptor[] array = new HFSPlusExtentDescriptor[8];

    public HFSPlusExtentRecord(byte[] data, int offset) {
        this(false, data, offset);
    }

    private HFSPlusExtentRecord(boolean mutable, byte[] data, int offset) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = mutable ? new HFSPlusExtentDescriptor.Mutable(data, offset + i * HFSPlusExtentDescriptor.getSize()) : new HFSPlusExtentDescriptor(data, offset + i * HFSPlusExtentDescriptor.getSize());
        }
    }

    public HFSPlusExtentDescriptor getExtentDescriptor(int index) {
        return this.array[index];
    }

    public HFSPlusExtentDescriptor[] getExtentDescriptors() {
        HFSPlusExtentDescriptor[] arrayCopy = new HFSPlusExtentDescriptor[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            arrayCopy[i] = this.array[i];
        }
        return arrayCopy;
    }

    public int length() {
        int res = 0;
        for (HFSPlusExtentDescriptor desc : this.array) {
            res += desc.getSize();
        }
        return res;
    }

    public int getNumExtentsInUse() {
        for (int i = 0; i < this.array.length; ++i) {
            HFSPlusExtentDescriptor cur = this.array[i];
            if (cur.getBlockCount() != 0 || cur.getStartBlock() != 0) continue;
            return i;
        }
        return this.array.length;
    }

    public void print(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
        this.print(ps, pregapString);
    }

    private void _printFields(PrintStream ps, String prefix) {
        for (int i = 0; i < this.array.length; ++i) {
            ps.println(prefix + "array[" + i + "]:");
            this.array[i].print(ps, prefix + "  ");
        }
    }

    public void printFields(PrintStream ps, String prefix) {
        this._printFields(ps, prefix + " ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusExtentRecord:");
        this._printFields(ps, prefix + " ");
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        int offset = 0;
        for (HFSPlusExtentDescriptor desc : this.array) {
            byte[] tempData = desc.getBytes();
            System.arraycopy(tempData, 0, result, offset, tempData.length);
            offset += tempData.length;
        }
        return result;
    }

    public Array getStructElement() {
        ArrayBuilder ab = new ArrayBuilder("HFSPlusExtentDescriptor[8]");
        for (HFSPlusExtentDescriptor descriptor : this.array) {
            ab.add(descriptor.getStructElements());
        }
        return ab.getResult();
    }

    private void _set(HFSPlusExtentRecord rec) {
        for (int i = 0; i < this.array.length; ++i) {
            ((HFSPlusExtentDescriptor.Mutable)this.array[i]).set(rec.array[i]);
        }
    }

    private void _setExtentDescriptor(int index, HFSPlusExtentDescriptor extentDescriptor) {
        if (index < 0 || index > this.array.length) {
            throw new RuntimeException("index out of range: " + index);
        }
        ((HFSPlusExtentDescriptor.Mutable)this.array[index]).set(extentDescriptor);
    }

    private void _setExtentDescriptors(HFSPlusExtentDescriptor[] extentDescriptors) {
        if (extentDescriptors.length != this.array.length) {
            throw new RuntimeException("Invalid length of array 'extentDescriptors': " + extentDescriptors.length);
        }
        for (int i = 0; i < this.array.length; ++i) {
            this._setExtentDescriptor(i, extentDescriptors[i]);
        }
    }

    private HFSPlusExtentDescriptor.Mutable[] _getMutableExtentDescriptors() {
        HFSPlusExtentDescriptor.Mutable[] result = new HFSPlusExtentDescriptor.Mutable[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = (HFSPlusExtentDescriptor.Mutable)this.array[i];
        }
        return result;
    }

    public static class Mutable
    extends HFSPlusExtentRecord {
        public Mutable(byte[] data, int offset) {
            super(true, data, offset);
        }

        public void set(HFSPlusExtentRecord rec) {
            ((HFSPlusExtentRecord)this)._set(rec);
        }

        public void setExtentDescriptor(int index, HFSPlusExtentDescriptor extentDescriptor) {
            ((HFSPlusExtentRecord)this)._setExtentDescriptor(index, extentDescriptor);
        }

        public void setExtentDescriptors(HFSPlusExtentDescriptor[] extentDescriptors) {
            ((HFSPlusExtentRecord)this)._setExtentDescriptors(extentDescriptors);
        }

        public HFSPlusExtentDescriptor.Mutable[] getMutableExtentDescriptors() {
            return ((HFSPlusExtentRecord)this)._getMutableExtentDescriptors();
        }
    }
}

