/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.util.Date;
import java.util.TimeZone;
import org.catacombae.hfs.types.hfs.HFSDate;

public class HFSPlusDate
extends HFSDate {
    private static final Date baseDate = HFSPlusDate.getBaseDate(TimeZone.getTimeZone("GMT"));

    protected HFSPlusDate() {
    }

    public static Date gmtTimestampToDate(int hfsPlusTimestamp) {
        return new Date(baseDate.getTime() + ((long)hfsPlusTimestamp & 0xFFFFFFFFL) * 1000L);
    }

    public static int dateToGmtTimestamp(Date date) {
        long timestamp = (date.getTime() - baseDate.getTime()) / 1000L;
        if (timestamp < 0L || timestamp > 0xFFFFFFFFL) {
            throw new RuntimeException("Timestamp outside of UInt32 range:" + timestamp);
        }
        return (int)timestamp;
    }
}

