/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.finder.ExtendedFolderInfo;
import org.catacombae.hfs.types.finder.FolderInfo;
import org.catacombae.hfs.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfs.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogAttributes;
import org.catacombae.hfs.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfs.types.hfsplus.HFSPlusDate;
import org.catacombae.hfs.types.hfsplus.HFSPlusDateField;
import org.catacombae.util.Util;

public class HFSPlusCatalogFolder
extends HFSPlusCatalogLeafRecordData
implements HFSPlusCatalogAttributes,
StructElements {
    private final byte[] recordType = new byte[2];
    private final byte[] flags = new byte[2];
    private final byte[] valence = new byte[4];
    private final HFSCatalogNodeID folderID;
    private final byte[] createDate = new byte[4];
    private final byte[] contentModDate = new byte[4];
    private final byte[] attributeModDate = new byte[4];
    private final byte[] accessDate = new byte[4];
    private final byte[] backupDate = new byte[4];
    private final HFSPlusBSDInfo permissions;
    private final FolderInfo userInfo;
    private final ExtendedFolderInfo finderInfo;
    private final byte[] textEncoding = new byte[4];
    private final byte[] reserved = new byte[4];

    public HFSPlusCatalogFolder(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.recordType, 0, 2);
        System.arraycopy(data, offset + 2, this.flags, 0, 2);
        System.arraycopy(data, offset + 4, this.valence, 0, 4);
        this.folderID = new HFSCatalogNodeID(data, offset + 8);
        System.arraycopy(data, offset + 12, this.createDate, 0, 4);
        System.arraycopy(data, offset + 16, this.contentModDate, 0, 4);
        System.arraycopy(data, offset + 20, this.attributeModDate, 0, 4);
        System.arraycopy(data, offset + 24, this.accessDate, 0, 4);
        System.arraycopy(data, offset + 28, this.backupDate, 0, 4);
        this.permissions = new HFSPlusBSDInfo(data, offset + 32);
        this.userInfo = new FolderInfo(data, offset + 48);
        this.finderInfo = new ExtendedFolderInfo(data, offset + 64);
        System.arraycopy(data, offset + 80, this.textEncoding, 0, 4);
        System.arraycopy(data, offset + 84, this.reserved, 0, 4);
    }

    public static int length() {
        return 88;
    }

    public short getRecordType() {
        return Util.readShortBE(this.recordType);
    }

    public short getFlags() {
        return Util.readShortBE(this.flags);
    }

    public int getValence() {
        return Util.readIntBE(this.valence);
    }

    public HFSCatalogNodeID getFolderID() {
        return this.folderID;
    }

    public int getCreateDate() {
        return Util.readIntBE(this.createDate);
    }

    public int getContentModDate() {
        return Util.readIntBE(this.contentModDate);
    }

    public int getAttributeModDate() {
        return Util.readIntBE(this.attributeModDate);
    }

    public int getAccessDate() {
        return Util.readIntBE(this.accessDate);
    }

    public int getBackupDate() {
        return Util.readIntBE(this.backupDate);
    }

    public HFSPlusBSDInfo getPermissions() {
        return this.permissions;
    }

    public FolderInfo getUserInfo() {
        return this.userInfo;
    }

    public ExtendedFolderInfo getFinderInfo() {
        return this.finderInfo;
    }

    public int getTextEncoding() {
        return Util.readIntBE(this.textEncoding);
    }

    public int getReserved() {
        return Util.readIntBE(this.reserved);
    }

    public boolean getFileLockedFlag() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean getThreadExistsFlag() {
        return (this.getFlags() & 2) != 0;
    }

    public boolean getHasAttributesFlag() {
        return (this.getFlags() & 4) != 0;
    }

    public boolean getHasSecurityMaskFlag() {
        return (this.getFlags() & 8) != 0;
    }

    public boolean getHasFolderCountFlag() {
        return (this.getFlags() & 0x10) != 0;
    }

    public boolean getHasLinkChainFlag() {
        return (this.getFlags() & 0x20) != 0;
    }

    public boolean getHasChildLinkFlag() {
        return (this.getFlags() & 0x40) != 0;
    }

    public boolean getHasDateAddedFlag() {
        return (this.getFlags() & 0x80) != 0;
    }

    public Date getCreateDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getCreateDate());
    }

    public Date getContentModDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getContentModDate());
    }

    public Date getAttributeModDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getAttributeModDate());
    }

    public Date getAccessDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getAccessDate());
    }

    public Date getBackupDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getBackupDate());
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " flags: " + this.getFlags());
        ps.println(prefix + " valence: " + this.getValence());
        ps.println(prefix + " folderID: ");
        this.getFolderID().print(ps, prefix + "  ");
        ps.println(prefix + " createDate: " + this.getCreateDateAsDate());
        ps.println(prefix + " contentModDate: " + this.getContentModDateAsDate());
        ps.println(prefix + " attributeModDate: " + this.getAttributeModDateAsDate());
        ps.println(prefix + " accessDate: " + this.getAccessDateAsDate());
        ps.println(prefix + " backupDate: " + this.getBackupDateAsDate());
        ps.println(prefix + " permissions: ");
        this.getPermissions().print(ps, prefix + "  ");
        ps.println(prefix + " userInfo: ");
        this.getUserInfo().print(ps, prefix + "  ");
        ps.println(prefix + " finderInfo: ");
        this.getFinderInfo().print(ps, prefix + "  ");
        ps.println(prefix + " textEncoding: " + this.getTextEncoding());
        ps.println(prefix + " reserved: " + this.getReserved());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusCatalogFolder:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[HFSPlusCatalogFolder.length()];
        int offset = 0;
        System.arraycopy(this.recordType, 0, result, offset, this.recordType.length);
        System.arraycopy(this.flags, 0, result, offset += this.recordType.length, this.flags.length);
        System.arraycopy(this.valence, 0, result, offset += this.flags.length, this.valence.length);
        byte[] tempData = this.folderID.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.valence.length, tempData.length);
        System.arraycopy(this.createDate, 0, result, offset += tempData.length, this.createDate.length);
        System.arraycopy(this.contentModDate, 0, result, offset += this.createDate.length, this.contentModDate.length);
        System.arraycopy(this.attributeModDate, 0, result, offset += this.contentModDate.length, this.attributeModDate.length);
        System.arraycopy(this.accessDate, 0, result, offset += this.attributeModDate.length, this.accessDate.length);
        System.arraycopy(this.backupDate, 0, result, offset += this.accessDate.length, this.backupDate.length);
        tempData = this.permissions.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.backupDate.length, tempData.length);
        offset += tempData.length;
        tempData = this.userInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.finderInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.textEncoding, 0, result, offset += tempData.length, this.textEncoding.length);
        System.arraycopy(this.reserved, 0, result, offset += this.textEncoding.length, this.reserved.length);
        offset += this.reserved.length;
        return result;
    }

    public Dictionary getFlagsStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("<anonymous>");
        db.addFlag("kHFSFileLocked", this.flags, 0, "File locked");
        db.addFlag("kHFSThreadExists", this.flags, 1, "Thread exists");
        db.addFlag("kHFSHasAttributes", this.flags, 2, "Has attributes");
        db.addFlag("kHFSHasSecurity", this.flags, 3, "Has security");
        db.addFlag("kHFSHasFolderCount", this.flags, 4, "Has folder count");
        db.addFlag("kHFSHasLinkChain", this.flags, 5, "Has link chain");
        db.addFlag("kHFSHasChildLink", this.flags, 6, "Has child link");
        db.addFlag("kHFSHasDateAdded", this.flags, 7, "Has date added");
        return db.getResult();
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusCatalogFolder.class.getSimpleName());
        db.addUIntBE("recordType", this.recordType, "Record type", IntegerFieldRepresentation.HEXADECIMAL);
        db.add("flags", this.getFlagsStructElements(), "Flags");
        db.addUIntBE("valence", this.valence, "Valence");
        db.add("folderID", this.folderID.getOpaqueStructElement(), "Folder ID");
        db.add("createDate", new HFSPlusDateField(this.createDate, false), "Created");
        db.add("contentModDate", new HFSPlusDateField(this.contentModDate, false), "Content modified");
        db.add("attributeModDate", new HFSPlusDateField(this.attributeModDate, false), "Attributes modified");
        db.add("accessDate", new HFSPlusDateField(this.accessDate, false), "Accessed");
        db.add("backupDate", new HFSPlusDateField(this.backupDate, false), "Backuped");
        db.add("permissions", this.permissions.getStructElements(), "POSIX permissions");
        db.add("userInfo", this.userInfo.getStructElements(), "User info");
        db.add("finderInfo", this.finderInfo.getStructElements(), "Finder info");
        db.addUIntBE("textEncoding", this.textEncoding, "Text encoding");
        db.addUIntBE("reserved", this.reserved, "Reserved");
        return db.getResult();
    }
}

