/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.StringRepresentableField;
import org.catacombae.util.Util;

public class HFSPlusBSDInfo
implements PrintableStruct,
StructElements {
    public static final byte MASK_ADMIN_ARCHIVED = 1;
    public static final byte MASK_ADMIN_IMMUTABLE = 2;
    public static final byte MASK_ADMIN_APPEND = 4;
    public static final byte MASK_OWNER_NODUMP = 1;
    public static final byte MASK_OWNER_IMMUTABLE = 2;
    public static final byte MASK_OWNER_APPEND = 4;
    public static final byte MASK_OWNER_OPAQUE = 8;
    public static final byte FILETYPE_UNDEFINED = 0;
    public static final byte FILETYPE_FIFO = 1;
    public static final byte FILETYPE_CHARACTER_SPECIAL = 2;
    public static final byte FILETYPE_DIRECTORY = 4;
    public static final byte FILETYPE_BLOCK_SPECIAL = 6;
    public static final byte FILETYPE_REGULAR = 8;
    public static final byte FILETYPE_SYMBOLIC_LINK = 10;
    public static final byte FILETYPE_SOCKET = 12;
    public static final byte FILETYPE_WHITEOUT = 14;
    private final byte[] ownerID = new byte[4];
    private final byte[] groupID = new byte[4];
    private final byte[] adminFlags = new byte[1];
    private final byte[] ownerFlags = new byte[1];
    private final byte[] fileMode = new byte[2];
    private final byte[] special = new byte[4];

    public HFSPlusBSDInfo(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.ownerID, 0, 4);
        System.arraycopy(data, offset + 4, this.groupID, 0, 4);
        System.arraycopy(data, offset + 8, this.adminFlags, 0, 1);
        System.arraycopy(data, offset + 9, this.ownerFlags, 0, 1);
        System.arraycopy(data, offset + 10, this.fileMode, 0, 2);
        System.arraycopy(data, offset + 12, this.special, 0, 4);
    }

    public static int length() {
        return 16;
    }

    public int getOwnerID() {
        return Util.readIntBE(this.ownerID);
    }

    public int getGroupID() {
        return Util.readIntBE(this.groupID);
    }

    public byte getAdminFlags() {
        return Util.readByteBE(this.adminFlags);
    }

    public byte getOwnerFlags() {
        return Util.readByteBE(this.ownerFlags);
    }

    public short getFileMode() {
        return Util.readShortBE(this.fileMode);
    }

    public int getSpecial() {
        return Util.readIntBE(this.special);
    }

    public boolean getAdminArchivedFlag() {
        return (this.getAdminFlags() & 1) != 0;
    }

    public boolean getAdminImmutableFlag() {
        return (this.getAdminFlags() & 2) != 0;
    }

    public boolean getAdminAppendFlag() {
        return (this.getAdminFlags() & 4) != 0;
    }

    public boolean getOwnerNodumpFlag() {
        return (this.getOwnerFlags() & 1) != 0;
    }

    public boolean getOwnerImmutableFlag() {
        return (this.getOwnerFlags() & 2) != 0;
    }

    public boolean getOwnerAppendFlag() {
        return (this.getOwnerFlags() & 4) != 0;
    }

    public boolean getOwnerOpaqueFlag() {
        return (this.getOwnerFlags() & 8) != 0;
    }

    public byte getFileModeFileType() {
        int type = this.getFileMode() >> 12 & 0xF;
        return (byte)type;
    }

    public boolean getFileModeSetUserID() {
        return (this.getFileMode() >> 9 & 4) != 0;
    }

    public boolean getFileModeSetGroupID() {
        return (this.getFileMode() >> 9 & 2) != 0;
    }

    public boolean getFileModeSticky() {
        return (this.getFileMode() >> 9 & 1) != 0;
    }

    public boolean getFileModeOwnerRead() {
        return (this.getFileMode() >> 6 & 4) != 0;
    }

    public boolean getFileModeOwnerWrite() {
        return (this.getFileMode() >> 6 & 2) != 0;
    }

    public boolean getFileModeOwnerExecute() {
        return (this.getFileMode() >> 6 & 1) != 0;
    }

    public boolean getFileModeGroupRead() {
        return (this.getFileMode() >> 3 & 4) != 0;
    }

    public boolean getFileModeGroupWrite() {
        return (this.getFileMode() >> 3 & 2) != 0;
    }

    public boolean getFileModeGroupExecute() {
        return (this.getFileMode() >> 3 & 1) != 0;
    }

    public boolean getFileModeOtherRead() {
        return (this.getFileMode() >> 0 & 4) != 0;
    }

    public boolean getFileModeOtherWrite() {
        return (this.getFileMode() >> 0 & 2) != 0;
    }

    public boolean getFileModeOtherExecute() {
        return (this.getFileMode() >> 0 & 1) != 0;
    }

    public String getFileModeString() {
        String result;
        byte fileType = this.getFileModeFileType();
        switch (fileType) {
            case 0: {
                result = "?";
                break;
            }
            case 1: {
                result = "p";
                break;
            }
            case 2: {
                result = "c";
                break;
            }
            case 4: {
                result = "d";
                break;
            }
            case 6: {
                result = "b";
                break;
            }
            case 8: {
                result = "-";
                break;
            }
            case 10: {
                result = "l";
                break;
            }
            case 12: {
                result = "s";
                break;
            }
            case 14: {
                result = "w";
                break;
            }
            default: {
                throw new RuntimeException("Unknown file type (read: " + fileType + " REGULAR: " + 8 + " MODE: 0x" + Util.toHexStringBE(this.getFileMode()) + ")!");
            }
        }
        result = this.getFileModeOwnerRead() ? result + "r" : result + "-";
        result = this.getFileModeOwnerWrite() ? result + "w" : result + "-";
        result = this.getFileModeOwnerExecute() ? (this.getFileModeSetUserID() ? result + "s" : result + "x") : (this.getFileModeSetUserID() ? result + "S" : result + "-");
        result = this.getFileModeGroupRead() ? result + "r" : result + "-";
        result = this.getFileModeGroupWrite() ? result + "w" : result + "-";
        result = this.getFileModeGroupExecute() ? (this.getFileModeSetGroupID() ? result + "s" : result + "x") : (this.getFileModeSetGroupID() ? result + "S" : result + "-");
        result = this.getFileModeOtherRead() ? result + "r" : result + "-";
        result = this.getFileModeOtherWrite() ? result + "w" : result + "-";
        result = this.getFileModeOtherExecute() ? (this.getFileModeSticky() ? result + "t" : result + "x") : (this.getFileModeSticky() ? result + "T" : result + "-");
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " ownerID: " + this.getOwnerID());
        ps.println(prefix + " groupID: " + this.getGroupID());
        ps.println(prefix + " adminFlags: " + this.getAdminFlags());
        ps.println(prefix + " ownerFlags: " + this.getOwnerFlags());
        ps.println(prefix + " fileMode: " + this.getFileMode());
        ps.println(prefix + " special: " + this.getSpecial());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusBSDInfo:");
        this.printFields(ps, prefix);
    }

    byte[] getBytes() {
        byte[] result = new byte[HFSPlusBSDInfo.length()];
        int offset = 0;
        System.arraycopy(this.ownerID, 0, result, offset, this.ownerID.length);
        System.arraycopy(this.groupID, 0, result, offset += this.ownerID.length, this.groupID.length);
        System.arraycopy(this.adminFlags, 0, result, offset += this.groupID.length, this.adminFlags.length);
        System.arraycopy(this.ownerFlags, 0, result, offset += this.adminFlags.length, this.ownerFlags.length);
        System.arraycopy(this.fileMode, 0, result, offset += this.ownerFlags.length, this.fileMode.length);
        System.arraycopy(this.special, 0, result, offset += this.fileMode.length, this.special.length);
        offset += this.special.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusBSDInfo.class.getSimpleName());
        db.addUIntBE("ownerID", this.ownerID);
        db.addUIntBE("groupID", this.groupID);
        StructElements.DictionaryBuilder dbAdminFlags = new StructElements.DictionaryBuilder("UInt8");
        dbAdminFlags.addFlag("append", this.adminFlags, 2, "Writes to file may only append");
        dbAdminFlags.addFlag("immutable", this.adminFlags, 1, "File may not be changed");
        dbAdminFlags.addFlag("archived", this.adminFlags, 0, "File has been archived");
        Dictionary adminFlagsDict = dbAdminFlags.getResult();
        db.add("adminFlags", adminFlagsDict);
        StructElements.DictionaryBuilder dbOwnerFlags = new StructElements.DictionaryBuilder("UInt8");
        dbOwnerFlags.addFlag("opaque", this.ownerFlags, 3, "Directory is opaque");
        dbOwnerFlags.addFlag("append", this.ownerFlags, 2, "Writes to file may only append");
        dbOwnerFlags.addFlag("immutable", this.ownerFlags, 1, "File may not be changed");
        dbOwnerFlags.addFlag("nodump", this.ownerFlags, 0, "Do not dump (backup or archive) this file");
        Dictionary ownerFlagsDict = dbOwnerFlags.getResult();
        db.add("ownerFlags", ownerFlagsDict);
        StructElements.DictionaryBuilder dbFileModeFlags = new StructElements.DictionaryBuilder("UInt16");
        dbFileModeFlags.add("fileType", new FileTypeField());
        dbFileModeFlags.addFlag("setUserID", this.fileMode, 11, "Set user ID on execution");
        dbFileModeFlags.addFlag("setGroupID", this.fileMode, 10, "Set group ID on execution");
        dbFileModeFlags.addFlag("sticky", this.fileMode, 9, "Sticky bit");
        dbFileModeFlags.addFlag("ownerRead", this.fileMode, 8, "Owner can read");
        dbFileModeFlags.addFlag("ownerWrite", this.fileMode, 7, "Owner can write");
        dbFileModeFlags.addFlag("ownerExecute", this.fileMode, 6, "Owner can execute");
        dbFileModeFlags.addFlag("groupRead", this.fileMode, 5, "Group can read");
        dbFileModeFlags.addFlag("groupWrite", this.fileMode, 4, "Group can write");
        dbFileModeFlags.addFlag("groupExecute", this.fileMode, 3, "Group can execute");
        dbFileModeFlags.addFlag("otherRead", this.fileMode, 2, "Others can read");
        dbFileModeFlags.addFlag("otherWrite", this.fileMode, 1, "Others can write");
        dbFileModeFlags.addFlag("otherExecute", this.fileMode, 0, "Others can execute");
        Dictionary fileModeFlagsDict = dbFileModeFlags.getResult();
        db.add("fileMode", fileModeFlagsDict);
        db.addUIntBE("special", this.special);
        return db.getResult();
    }

    private class FileTypeField
    extends StringRepresentableField {
        public FileTypeField() {
            super("FileType", StructElements.ASCIISTRING);
        }

        public String getValueAsString() {
            byte fileTypeByte = HFSPlusBSDInfo.this.getFileModeFileType();
            switch (fileTypeByte) {
                case 0: {
                    return "Undefined";
                }
                case 1: {
                    return "FIFO";
                }
                case 2: {
                    return "Character special file";
                }
                case 4: {
                    return "Directory";
                }
                case 6: {
                    return "Block special file";
                }
                case 8: {
                    return "Regular file";
                }
                case 10: {
                    return "Symbolic link";
                }
                case 12: {
                    return "Socket";
                }
                case 14: {
                    return "Whiteout";
                }
            }
            return "[Unknown file type: " + fileTypeByte + "]";
        }

        public void setStringValue(String value) throws IllegalArgumentException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String validateStringValue(String s) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

