/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.lang.reflect.Field;
import org.catacombae.csjc.AbstractStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.util.Util;

public abstract class HFSPlusAttributesLeafRecordData
implements AbstractStruct,
PrintableStruct,
StructElements {
    public static final int kHFSPlusAttrInlineData = 16;
    public static final int kHFSPlusAttrForkData = 32;
    public static final int kHFSPlusAttrExtents = 48;
    private int recordType;

    public HFSPlusAttributesLeafRecordData(byte[] data, int offset) {
        this.recordType = Util.readIntBE(data, offset + 0);
    }

    public final long getRecordType() {
        return Util.unsign(this.getRawRecordType());
    }

    public final int getRawRecordType() {
        return this.recordType;
    }

    public String getRecordTypeAsString() {
        if (this.recordType == 16) {
            return "kHFSPlusAttrInlineData";
        }
        if (this.recordType == 32) {
            return "kHFSPlusAttrForkData";
        }
        if (this.recordType == 48) {
            return "kHFSPlusAttrExtents";
        }
        return "UNKNOWN!";
    }

    public abstract int size();

    protected int getBytes(byte[] result, int offset) {
        Util.arrayPutBE(result, offset, this.recordType);
        offset += 4;
        return 4;
    }

    public Dictionary getStructElements() {
        Class<HFSPlusAttributesLeafRecordData> thisClass = HFSPlusAttributesLeafRecordData.class;
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(thisClass.getSimpleName(), "HFS+ attributes leaf record data (abstract superclass)");
        try {
            Field recordTypeField = thisClass.getDeclaredField("recordType");
            recordTypeField.setAccessible(true);
            db.addUIntBE("recordType", recordTypeField, (Object)this, "Record type", IntegerFieldRepresentation.HEXADECIMAL);
            return db.getResult();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

