/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.AbstractStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesData;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesExtents;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesForkData;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesKey;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesLeafRecordData;
import org.catacombae.util.Util;

public class HFSPlusAttributesLeafRecord
implements AbstractStruct,
PrintableStruct,
StructElements {
    protected final HFSPlusAttributesKey key;
    protected final HFSPlusAttributesLeafRecordData recordData;

    public HFSPlusAttributesLeafRecord(byte[] data, int offset) {
        this.key = new HFSPlusAttributesKey(data, offset);
        int recordType = Util.readIntBE(data, offset + this.key.length());
        switch (recordType) {
            case 16: {
                this.recordData = new HFSPlusAttributesData(data, offset + this.key.length());
                break;
            }
            case 32: {
                this.recordData = new HFSPlusAttributesForkData(data, offset + this.key.length());
                break;
            }
            case 48: {
                this.recordData = new HFSPlusAttributesExtents(data, offset + this.key.length());
                break;
            }
            default: {
                throw new RuntimeException("Invalid record type: 0x" + Util.toHexStringBE(recordType));
            }
        }
    }

    public HFSPlusAttributesKey getKey() {
        return this.key;
    }

    public HFSPlusAttributesLeafRecordData getData() {
        return this.recordData;
    }

    public int size() {
        return this.key.length() + this.recordData.size();
    }

    public byte[] getBytes() {
        byte[] keyBytes = this.key.getBytes();
        byte[] recordDataBytes = this.recordData.getBytes();
        byte[] result = new byte[keyBytes.length + recordDataBytes.length];
        Util.arrayCopy(keyBytes, result, 0);
        Util.arrayCopy(recordDataBytes, result, keyBytes.length);
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " key:");
        this.key.printFields(ps, prefix + "  ");
        ps.println(prefix + " recordData:");
        this.recordData.printFields(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusAttributesLeafRecord:");
        this.printFields(ps, prefix);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("HFSPlusAttributesLeafRecord", "HFS+ attributes file leaf record");
        db.add("key", this.key.getStructElements(), "Key");
        db.add("recordData", this.recordData.getStructElements(), "Record data");
        return db.getResult();
    }
}

