/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfs.types.hfsplus.BTHeaderRec;
import org.catacombae.hfs.types.hfsplus.BTLeafNode;
import org.catacombae.hfs.types.hfsplus.HFSPlusAttributesLeafRecord;
import org.catacombae.util.Util;

public class HFSPlusAttributesLeafNode
extends BTLeafNode {
    protected HFSPlusAttributesLeafRecord[] leafRecords;

    public HFSPlusAttributesLeafNode(byte[] data, int offset, int nodeSize) {
        this(data, offset, nodeSize, null);
    }

    protected HFSPlusAttributesLeafNode(byte[] data, int offset, int nodeSize, BTHeaderRec catalogHeaderRec) {
        super(data, offset, nodeSize);
        int i;
        short[] offsets = new short[Util.unsign(this.nodeDescriptor.getNumRecords()) + 1];
        for (i = 0; i < offsets.length; ++i) {
            offsets[i] = Util.readShortBE(data, offset + nodeSize - (i + 1) * 2);
        }
        this.leafRecords = new HFSPlusAttributesLeafRecord[offsets.length - 1];
        for (i = 0; i < this.leafRecords.length; ++i) {
            int currentOffset = Util.unsign(offsets[i]);
            this.leafRecords[i] = new HFSPlusAttributesLeafRecord(data, offset + currentOffset);
        }
    }

    public HFSPlusAttributesLeafRecord getLeafRecord(int index) {
        return this.leafRecords[index];
    }

    public HFSPlusAttributesLeafRecord[] getLeafRecords() {
        HFSPlusAttributesLeafRecord[] copy = new HFSPlusAttributesLeafRecord[this.leafRecords.length];
        System.arraycopy(this.leafRecords, 0, copy, 0, this.leafRecords.length);
        return copy;
    }

    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        for (int i = 0; i < this.leafRecords.length; ++i) {
            ps.println(prefix + " leafRecords[" + i + "]:");
            this.leafRecords[i].printFields(ps, prefix + "  ");
        }
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }
}

