/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfs.types.hfsplus;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfs.types.hfsplus.BTKey;
import org.catacombae.hfs.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.util.Util;

public class HFSPlusAttributesKey
extends BTKey
implements PrintableStruct,
StructElements,
DynamicStruct {
    public static final int STATIC_SIZE = 14;
    public static final int kHFSPlusAttrMinNodeSize = 4096;
    private static final int kHFSMaxAttrNameLen = 127;
    private short keyLength;
    private short pad;
    private final HFSCatalogNodeID fileID;
    private int startBlock;
    private short attrNameLen;
    private final byte[] attrName;

    public HFSPlusAttributesKey(byte[] data, int offset) {
        this.keyLength = Util.readShortBE(data, offset + 0);
        this.pad = Util.readShortBE(data, offset + 2);
        this.fileID = new HFSCatalogNodeID(data, offset + 4);
        this.startBlock = Util.readIntBE(data, offset + 8);
        this.attrNameLen = Util.readShortBE(data, offset + 12);
        if (this.attrNameLen > 127) {
            throw new RuntimeException("Invalid attrNameLen value: " + this.attrNameLen);
        }
        this.attrName = Util.createCopy(data, offset + 14, 2 * this.attrNameLen);
    }

    public int length() {
        return this.occupiedSize();
    }

    public int maxSize() {
        return 268;
    }

    public int occupiedSize() {
        return 14 + 2 * this.getAttrNameLen();
    }

    public final short getKeyLength() {
        return this.getRawKeyLength();
    }

    public final int getKeyLengthUnsigned() {
        return Util.unsign(this.getRawKeyLength());
    }

    public final int getPad() {
        return Util.unsign(this.getRawPad());
    }

    public final HFSCatalogNodeID getFileID() {
        return this.fileID;
    }

    public final long getStartBlock() {
        return Util.unsign(this.getRawStartBlock());
    }

    public final int getAttrNameLen() {
        return Util.unsign(this.getRawAttrNameLen());
    }

    public final char[] getAttrName() {
        return Util.readCharArrayBE(this.attrName);
    }

    public final short getRawKeyLength() {
        return this.keyLength;
    }

    public final short getRawPad() {
        return this.pad;
    }

    public final int getRawStartBlock() {
        return this.startBlock;
    }

    public final short getRawAttrNameLen() {
        return this.attrNameLen;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " keyLength: " + this.getKeyLength());
        ps.println(prefix + " pad: " + this.getPad());
        ps.println(prefix + " fileID:");
        this.fileID.printFields(ps, prefix + "  ");
        ps.println(prefix + " startBlock: " + this.getStartBlock());
        ps.println(prefix + " attrNameLen: " + this.getAttrNameLen());
        ps.println(prefix + " attrName: \"" + new String(this.getAttrName()) + "\"");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusAttributesKey:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        int offset = 0;
        Util.arrayPutBE(result, offset, this.keyLength);
        Util.arrayPutBE(result, offset += 2, this.pad);
        Util.arrayCopy(this.fileID.getBytes(), result, offset += 2);
        Util.arrayPutBE(result, offset += 4, this.startBlock);
        Util.arrayPutBE(result, offset += 4, this.attrNameLen);
        Util.arrayCopy(this.attrName, result, offset += 2);
        offset += 254;
        return result;
    }

    public Dictionary getStructElements() {
        Class<HFSPlusAttributesKey> thisClass = HFSPlusAttributesKey.class;
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(thisClass.getSimpleName(), "HFS+ attributes key");
        try {
            Field keyLengthField = thisClass.getDeclaredField("keyLength");
            Field padField = thisClass.getDeclaredField("pad");
            Field startBlockField = thisClass.getDeclaredField("startBlock");
            Field attrNameLenField = thisClass.getDeclaredField("attrNameLen");
            keyLengthField.setAccessible(true);
            padField.setAccessible(true);
            startBlockField.setAccessible(true);
            attrNameLenField.setAccessible(true);
            db.addUIntBE("keyLength", keyLengthField, (Object)this, "Key length", "bytes");
            db.addUIntBE("pad", padField, (Object)this, "Padding", IntegerFieldRepresentation.HEXADECIMAL);
            db.add("fileID", this.fileID.getOpaqueStructElement(), "File ID");
            db.addUIntBE("startBlock", startBlockField, this, "Start block number");
            db.addUIntBE("attrNameLen", attrNameLenField, this, "Attribute name length");
            db.addEncodedString("attrName", this.attrName, "UTF-16BE", "Attribute name");
            return db.getResult();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

